/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import workbench.db.ConstraintDefinition;
import workbench.db.ConstraintType;
import workbench.db.DbObject;
import workbench.db.IndexColumn;
import workbench.db.IndexReader;
import workbench.db.ObjectSourceOptions;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class IndexDefinition
implements DbObject,
Serializable {
    private boolean isPK;
    private boolean isUnique;
    private String schema;
    private String indexName;
    private String indexType;
    private TableIdentifier baseTable;
    private List<IndexColumn> columns = new ArrayList<IndexColumn>();
    private String comment;
    private ConstraintDefinition uniqueConstraint;
    private String indexExpression;
    private String displayName;
    private String status;
    private String filterExpression;
    private ObjectSourceOptions sourceOptions = new ObjectSourceOptions();
    private String tableSpace;
    private boolean autoGenerated;
    private boolean partitioned;
    private String direction;
    private Boolean enabled;
    private Boolean validated;

    public IndexDefinition(TableIdentifier tableIdentifier, String string) {
        this.indexName = string;
        this.baseTable = tableIdentifier;
    }

    public void setSourceOptions(ObjectSourceOptions objectSourceOptions) {
        if (objectSourceOptions != null) {
            this.sourceOptions = objectSourceOptions;
        }
    }

    public ObjectSourceOptions getSourceOptions() {
        return this.sourceOptions;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean bl) {
        this.partitioned = bl;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean bl) {
        this.autoGenerated = bl;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getTablespace() {
        return this.tableSpace;
    }

    public void setTablespace(String string) {
        this.tableSpace = string;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String string) {
        this.direction = string;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean bl) {
        this.enabled = bl;
    }

    public Boolean isValidated() {
        return this.validated;
    }

    public void setValid(Boolean bl) {
        this.validated = bl;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(String string) {
        this.filterExpression = string;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public void setName(String string) {
        this.indexName = string;
    }

    public void setCatalog(String string) {
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    @Override
    public String getSchema() {
        if (this.schema != null) {
            return this.schema;
        }
        return this.baseTable.getSchema();
    }

    @Override
    public String getCatalog() {
        return null;
    }

    public boolean isNonStandardExpression() {
        return this.indexExpression != null;
    }

    public String getIndexExpression() {
        return this.indexExpression;
    }

    public void setIndexExpression(String string) {
        this.indexExpression = string;
    }

    public boolean isUniqueConstraint() {
        return this.uniqueConstraint != null;
    }

    public void setUniqueConstraint(ConstraintDefinition constraintDefinition) {
        if (constraintDefinition != null && constraintDefinition.getConstraintType() != ConstraintType.Unique) {
            LogMgr.logError(new CallerInfo(){}, "setUniqueConstraint() called with a different constraint type", new IllegalArgumentException("Invalid type: " + (Object)((Object)constraintDefinition.getConstraintType())));
        }
        this.uniqueConstraint = constraintDefinition;
    }

    public String getUniqueConstraintName() {
        return this.uniqueConstraint == null ? null : this.uniqueConstraint.getConstraintName();
    }

    public ConstraintDefinition getUniqueConstraint() {
        return this.uniqueConstraint;
    }

    public void addColumn(String string, String string2) {
        this.columns.add(new IndexColumn(string, string2));
    }

    public void setIndexType(String string) {
        this.indexType = string == null ? "NORMAL" : string;
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return SqlUtil.fullyQualifiedName(wbConnection, this);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return SqlUtil.buildExpression(wbConnection, null, this.getSchema(), this.indexName);
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        if (wbConnection != null && wbConnection.getMetadata().isSqlServer()) {
            return this.indexName;
        }
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        return wbConnection.getMetadata().quoteObjectname(this.indexName);
    }

    @Override
    public String getObjectType() {
        return "INDEX";
    }

    @Override
    public String getObjectName() {
        return this.getName();
    }

    public List<IndexColumn> getColumns() {
        if (this.columns == null) {
            return Collections.emptyList();
        }
        return this.columns;
    }

    public String getIndexType() {
        return this.indexType;
    }

    @Override
    public DbObject getOwnerObject() {
        return this.getBaseTable();
    }

    public TableIdentifier getBaseTable() {
        return this.baseTable;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String toString() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.indexName;
    }

    public String getColumnList() {
        StringBuilder stringBuilder = new StringBuilder(this.columns.size() * 10);
        for (int i = 0; i < this.columns.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.columns.get(i).getColumn());
        }
        return stringBuilder.toString();
    }

    public String getExpression() {
        return this.getExpression(null);
    }

    public String getExpression(WbConnection wbConnection) {
        if (this.indexExpression != null) {
            return this.indexExpression;
        }
        StringBuilder stringBuilder = new StringBuilder(this.columns.size() * 10);
        for (int i = 0; i < this.columns.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.columns.get(i).getExpression());
        }
        return stringBuilder.toString();
    }

    public String getName() {
        return this.indexName;
    }

    public void setPrimaryKeyIndex(boolean bl) {
        this.isPK = bl;
    }

    public boolean isPrimaryKeyIndex() {
        return this.isPK;
    }

    public void setUnique(boolean bl) {
        this.isUnique = bl;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public int hashCode() {
        int n = 497 + (this.indexName != null ? this.indexName.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof IndexDefinition) {
            IndexDefinition indexDefinition = (IndexDefinition)object;
            boolean bl = false;
            if (this.isPK && indexDefinition.isPK || this.isUnique && indexDefinition.isUnique) {
                bl = true;
                for (IndexColumn indexColumn : this.columns) {
                    if (indexDefinition.columns.contains(indexColumn)) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = this.columns.equals(indexDefinition.columns);
                if (bl) {
                    bl = StringUtil.equalStringOrEmpty(this.getFilterExpression(), indexDefinition.getFilterExpression(), false);
                }
            }
            if (bl) {
                bl = this.isPK == indexDefinition.isPK && this.isUnique == indexDefinition.isUnique;
            }
            return bl;
        }
        if (object instanceof String) {
            return this.getExpression().equals((String)object);
        }
        return false;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) {
        if (wbConnection == null) {
            return null;
        }
        IndexReader indexReader = wbConnection.getMetadata().getIndexReader();
        return indexReader.getIndexSource(this.baseTable, this);
    }

    public boolean isNameEqual(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (SqlUtil.objectNamesAreEqual(this.getName(), string2)) {
            if (this.getSchema() != null && string != null) {
                return SqlUtil.objectNamesAreEqual(this.getSchema(), string);
            }
            return true;
        }
        return false;
    }

    public static IndexDefinition findIndex(Collection<IndexDefinition> collection, String string, String string2) {
        for (IndexDefinition indexDefinition : collection) {
            if (!indexDefinition.isNameEqual(string2, string)) continue;
            return indexDefinition;
        }
        return null;
    }

    public IndexDefinition createCopy() {
        IndexDefinition indexDefinition = new IndexDefinition(this.baseTable.createCopy(), this.indexName);
        indexDefinition.autoGenerated = this.autoGenerated;
        indexDefinition.enabled = this.enabled;
        indexDefinition.columns = new ArrayList<IndexColumn>(this.columns);
        indexDefinition.comment = this.comment;
        indexDefinition.direction = this.direction;
        indexDefinition.displayName = this.displayName;
        indexDefinition.indexExpression = this.indexExpression;
        indexDefinition.indexType = this.indexType;
        indexDefinition.isPK = this.isPK;
        indexDefinition.isUnique = this.isUnique;
        indexDefinition.schema = this.schema;
        indexDefinition.tableSpace = this.tableSpace;
        indexDefinition.uniqueConstraint = this.uniqueConstraint;
        indexDefinition.validated = this.validated;
        indexDefinition.partitioned = this.partitioned;
        return indexDefinition;
    }

    public static Comparator<IndexDefinition> getNameSorter() {
        Comparator comparator = (indexDefinition, indexDefinition2) -> {
            if (indexDefinition == null) {
                return 1;
            }
            if (indexDefinition2 == null) {
                return -1;
            }
            String string = indexDefinition.getName();
            String string2 = indexDefinition2.getName();
            return StringUtil.compareStrings(string, string2, true);
        };
        return comparator;
    }

    public boolean isEmpty() {
        if (this.columns == null) {
            return true;
        }
        for (IndexColumn indexColumn : this.columns) {
            if (indexColumn == null || !StringUtil.isNonEmpty(indexColumn.getColumn())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }
}

