/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.IOException;
import java.io.Reader;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import workbench.db.DBID;
import workbench.db.ResultSetProcessor;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.VersionNumber;

public class JdbcUtils {
    public static <T> T getArray(ResultSet resultSet, String string, Class<T> clazz) {
        try {
            Array array = resultSet.getArray(string);
            if (resultSet.wasNull() || array == null) {
                return null;
            }
            return clazz.cast(array.getArray());
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Could not read array for column " + string, throwable);
            return null;
        }
    }

    public static boolean hasMinimumServerVersion(WbConnection wbConnection, String string) {
        if (wbConnection == null) {
            return false;
        }
        VersionNumber versionNumber = wbConnection.getDatabaseVersion();
        VersionNumber versionNumber2 = new VersionNumber(string);
        return versionNumber.isNewerOrEqual(versionNumber2);
    }

    public static boolean hasMinimumServerVersion(VersionNumber versionNumber, String string) {
        VersionNumber versionNumber2 = new VersionNumber(string);
        return versionNumber.isNewerOrEqual(versionNumber2);
    }

    public static boolean hasMinimumServerVersion(Connection connection, String string) {
        if (connection == null) {
            return false;
        }
        VersionNumber versionNumber = new VersionNumber(string);
        try {
            int n = connection.getMetaData().getDatabaseMajorVersion();
            int n2 = connection.getMetaData().getDatabaseMinorVersion();
            VersionNumber versionNumber2 = new VersionNumber(n, n2);
            return versionNumber2.isNewerOrEqual(versionNumber);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean hasMiniumDriverVersion(WbConnection wbConnection, String string) {
        return JdbcUtils.hasMiniumDriverVersion(wbConnection.getSqlConnection(), string);
    }

    public static boolean hasMiniumDriverVersion(Connection connection, String string) {
        if (connection == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        VersionNumber versionNumber = new VersionNumber(string);
        try {
            int n = connection.getMetaData().getDriverMajorVersion();
            int n2 = connection.getMetaData().getDriverMinorVersion();
            VersionNumber versionNumber2 = new VersionNumber(n, n2);
            return versionNumber2.isNewerOrEqual(versionNumber);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static int getColumnIndex(ResultSet resultSet, String string) {
        try {
            if (resultSet == null) {
                return -1;
            }
            if (StringUtil.isEmptyString(string)) {
                return -1;
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String string2 = resultSetMetaData.getColumnName(i);
                if (string.equalsIgnoreCase(string2)) {
                    return i;
                }
                String string3 = resultSetMetaData.getColumnLabel(i);
                if (!string.equalsIgnoreCase(string3)) continue;
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static boolean driverMightBufferResults(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        if (wbConnection.getMetadata().isPostgres()) {
            return JdbcUtils.checkPostgresBuffering(wbConnection);
        }
        if (wbConnection.getMetadata().isSqlServer()) {
            return JdbcUtils.checkSqlServerBuffering(wbConnection);
        }
        return false;
    }

    public static boolean checkPostgresBuffering(WbConnection wbConnection) {
        if (!wbConnection.getMetadata().isPostgres()) {
            return false;
        }
        if (wbConnection.getAutoCommit()) {
            return true;
        }
        if (wbConnection.getProfile() == null) {
            return true;
        }
        int n = wbConnection.getProfile().getFetchSize();
        return n <= 0;
    }

    private static boolean checkSqlServerBuffering(WbConnection wbConnection) {
        String string = wbConnection.getUrl();
        if (string.startsWith("jdbc:jtds")) {
            return !string.contains("useCursors=false");
        }
        if (string.startsWith("jdbc:sqlserver")) {
            if (JdbcUtils.hasMiniumDriverVersion(wbConnection, "6.0")) {
                return false;
            }
            return !string.contains("selectMethod=cursor");
        }
        return false;
    }

    public static SQLXML createXML(String string, WbConnection wbConnection) throws SQLException {
        SQLXML sQLXML = wbConnection.getSqlConnection().createSQLXML();
        sQLXML.setString(string);
        return sQLXML;
    }

    public static SQLXML createXML(Clob clob, WbConnection wbConnection) throws SQLException {
        return JdbcUtils.createXML(clob.getCharacterStream(), wbConnection);
    }

    public static SQLXML createXML(Reader reader, WbConnection wbConnection) throws SQLException {
        try {
            String string = FileUtil.readCharacters(reader);
            return JdbcUtils.createXML(string, wbConnection);
        }
        catch (IOException iOException) {
            throw new SQLException("Can not read input data", iOException);
        }
    }

    public static ResultSet runQuery(WbConnection wbConnection, Statement statement, String string, boolean bl) {
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        try {
            if (bl && !wbConnection.getAutoCommit()) {
                savepoint = wbConnection.setSavepoint();
            }
            resultSet = statement.executeQuery(string);
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Throwable throwable) {
            wbConnection.rollback(savepoint);
            LogMgr.logError(new CallerInfo(){}, "Error running query", throwable);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runQuery(WbConnection wbConnection, String string, boolean bl, ResultSetProcessor resultSetProcessor) throws SQLException {
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        Statement statement = null;
        try {
            statement = wbConnection.createStatementForQuery();
            if (bl && !wbConnection.getAutoCommit()) {
                savepoint = wbConnection.setSavepoint();
            }
            resultSet = statement.executeQuery(string);
            resultSetProcessor.process(resultSet);
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeAll(resultSet, statement);
            throw throwable;
        }
        JdbcUtils.closeAll(resultSet, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runStatement(WbConnection wbConnection, String string) {
        Statement statement = null;
        try {
            statement = wbConnection.getSqlConnection().createStatement();
            statement.execute(string);
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error running statement", throwable);
        }
        finally {
            JdbcUtils.close((AutoCloseable)statement);
        }
        return false;
    }

    public static String getDbIdFromUrl(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        if (string.startsWith("jdbc:postgresql")) {
            return DBID.Postgres.getId();
        }
        if (string.startsWith("jdbc:pgsql")) {
            return DBID.Postgres.getId();
        }
        if (string.startsWith("jdbc:oracle")) {
            return DBID.Oracle.getId();
        }
        if (string.startsWith("jdbc:sqlserver")) {
            return DBID.SQL_Server.getId();
        }
        if (string.startsWith("jdbc:jtds:sqlserver")) {
            return DBID.SQL_Server.getId();
        }
        if (string.startsWith("jdbc:microsoft:sqlserver")) {
            return DBID.SQL_Server.getId();
        }
        if (string.startsWith("jdbc:firebirdsql")) {
            return DBID.Firebird.getId();
        }
        if (string.startsWith("jdbc:h2")) {
            return DBID.H2.getId();
        }
        if (string.startsWith("jdbc:derby")) {
            return DBID.Derby.getId();
        }
        if (string.startsWith("jdbc:hsqldb")) {
            return DBID.HSQLDB.getId();
        }
        if (string.startsWith("jdbc:sapdb:")) {
            return DBID.SAP_DB.getId();
        }
        if (string.startsWith("jdbc:sap:")) {
            return DBID.HANA.getId();
        }
        if (string.startsWith("jdbc:datadirect:openedge")) {
            return DBID.OPENEDGE.getId();
        }
        if (string.startsWith("jdbc:db2")) {
            return DBID.DB2_LUW.getId();
        }
        if (string.startsWith("jdbc:informix")) {
            return DBID.Informix.getId();
        }
        if (string.startsWith("jdbc:cubrid")) {
            return DBID.Cubrid.getId();
        }
        if (string.startsWith("jdbc:sqlite")) {
            return DBID.SQLite.getId();
        }
        if (string.startsWith("jdbc:vertica")) {
            return DBID.Vertica.getId();
        }
        if (string.startsWith("jdbc:mysql")) {
            return DBID.MySQL.getId();
        }
        if (string.startsWith("jdbc:mariadb")) {
            return DBID.MariaDB.getId();
        }
        String string2 = string.replaceFirst("[^:]+:([^:]+):[^:]+", "$1");
        return string2;
    }

    public static String getDBMSName(String string) {
        String string2 = JdbcUtils.extractPrefix(string);
        return string2.substring("jdbc:".length(), string2.length() - 1);
    }

    public static String extractPrefix(String string) {
        if (StringUtil.isBlank(string)) {
            return null;
        }
        int n = string.indexOf(58, "jdbc:".length());
        if (n < 0) {
            return string;
        }
        return string.substring(0, n + 1);
    }

    public static void closeResult(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        JdbcUtils.clearWarnings(resultSet);
        try {
            resultSet.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeStatement(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeAll(ResultSet resultSet, Statement statement) {
        JdbcUtils.closeResult(resultSet);
        JdbcUtils.closeStatement(statement);
    }

    public static void close(AutoCloseable ... autoCloseableArray) {
        if (autoCloseableArray == null) {
            return;
        }
        for (AutoCloseable autoCloseable : autoCloseableArray) {
            JdbcUtils.close(autoCloseable);
        }
    }

    public static void close(AutoCloseable autoCloseable) {
        if (autoCloseable == null) {
            return;
        }
        if (autoCloseable instanceof ResultSet) {
            JdbcUtils.clearWarnings((ResultSet)autoCloseable);
        }
        try {
            autoCloseable.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void clearWarnings(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.clearWarnings();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void clearWarnings(WbConnection wbConnection, Statement statement) {
        JdbcUtils.clearWarnings(wbConnection);
        JdbcUtils.clearWarnings(statement);
    }

    public static void clearWarnings(WbConnection wbConnection) {
        try {
            if (wbConnection != null) {
                wbConnection.clearWarnings();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void clearWarnings(Statement statement) {
        try {
            if (statement != null) {
                statement.clearWarnings();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

