/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.NoConfigException;
import workbench.db.ProcedureReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.wbcommands.CommandTester;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ProcedureDefinition
implements DbObject,
Serializable {
    private static final long serialVersionUID = 1L;
    private String schema;
    private String catalog;
    private String procName;
    private String comment;
    private String displayName;
    private Object internalIdentifier;
    private int resultType;
    private ProcType procType;
    private String oracleOverloadIndex;
    private CharSequence source;
    private List<ColumnIdentifier> parameters;
    private String dbmsProcType;
    private String specificName;

    public ProcedureDefinition(String string, int n) {
        this.procName = string;
        this.resultType = n;
    }

    public ProcedureDefinition(String string, String string2, String string3, int n) {
        this.schema = string2;
        this.catalog = string;
        this.procName = string3;
        this.resultType = n;
    }

    public ProcedureDefinition(String string, String string2, String string3) {
        this.schema = string2;
        this.catalog = string;
        this.procName = string3;
        this.resultType = 0;
    }

    public static ProcedureDefinition createOracleDefinition(String string, String string2, String string3, int n, String string4) {
        ProcedureDefinition procedureDefinition = new ProcedureDefinition(string3, string, string2, n);
        if (StringUtil.isNonBlank(string3)) {
            procedureDefinition.procType = "OBJECT TYPE".equals(string4) ? ProcType.objectType : ProcType.packageType;
        }
        return procedureDefinition;
    }

    public Object getInternalIdentifier() {
        return this.internalIdentifier;
    }

    public void setInternalIdentifier(Object object) {
        this.internalIdentifier = object;
    }

    public String getSpecificName() {
        return this.specificName;
    }

    public void setSpecificName(String string) {
        this.specificName = string;
    }

    public void setOracleOverloadIndex(String string) {
        this.oracleOverloadIndex = string;
    }

    public String getOracleOverloadIndex() {
        return this.oracleOverloadIndex;
    }

    public void setDbmsProcType(String string) {
        this.dbmsProcType = string;
    }

    public String getDbmsProcType() {
        return this.dbmsProcType;
    }

    @Override
    public void setName(String string) {
        this.procName = string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.procName;
        }
        return this.displayName;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        this.comment = string;
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameters(List<ColumnIdentifier> list) {
        ProcedureDefinition procedureDefinition = this;
        synchronized (procedureDefinition) {
            this.parameters = list == null ? null : new ArrayList<ColumnIdentifier>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnIdentifier> getParameters(WbConnection wbConnection) {
        if (wbConnection == null) {
            ProcedureDefinition procedureDefinition = this;
            synchronized (procedureDefinition) {
                if (this.parameters == null) {
                    return Collections.emptyList();
                }
                return Collections.unmodifiableList(this.parameters);
            }
        }
        this.readParameters(wbConnection);
        return Collections.unmodifiableList(this.parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readParameters(WbConnection wbConnection) {
        ProcedureDefinition procedureDefinition = this;
        synchronized (procedureDefinition) {
            if (this.parameters == null) {
                try {
                    ProcedureReader procedureReader = wbConnection.getMetadata().getProcedureReader();
                    procedureReader.readProcedureParameters(this);
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Could not read procedure parameters", sQLException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getParameterNames() {
        ProcedureDefinition procedureDefinition = this;
        synchronized (procedureDefinition) {
            if (this.parameters == null) {
                return Collections.emptyList();
            }
            ArrayList<String> arrayList = new ArrayList<String>(this.parameters.size());
            for (ColumnIdentifier columnIdentifier : this.parameters) {
                arrayList.add(columnIdentifier.getColumnName());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getParameterTypes() {
        ProcedureDefinition procedureDefinition = this;
        synchronized (procedureDefinition) {
            if (this.parameters == null) {
                return Collections.emptyList();
            }
            ArrayList<String> arrayList = new ArrayList<String>(this.parameters.size());
            for (ColumnIdentifier columnIdentifier : this.parameters) {
                arrayList.add(columnIdentifier.getDbmsType());
            }
            return arrayList;
        }
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (this.isPackageProcedure()) {
            return "DROP PACKAGE " + dbMetadata.quoteObjectname(this.schema) + "." + dbMetadata.quoteObjectname(this.catalog);
        }
        if (this.isOracleObjectType()) {
            String string = "DROP TYPE " + dbMetadata.quoteObjectname(this.schema) + "." + dbMetadata.quoteObjectname(this.catalog);
            if (bl) {
                string = string + " FORCE";
            }
            return string;
        }
        return null;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        boolean bl = wbConnection == null ? false : wbConnection.getDbSettings().needParametersToDropFunction();
        boolean bl2 = wbConnection == null ? false : wbConnection.getDbSettings().includeOutParameterForDropFunction();
        boolean bl3 = wbConnection == null ? false : wbConnection.getDbSettings().useSpecificNameForDropFunction();
        return this.getObjectNameForDrop(wbConnection, bl, bl2, bl3);
    }

    public String getObjectNameForDrop(WbConnection wbConnection, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (this.procType != null) {
            return this.catalog;
        }
        boolean bl5 = bl4 = this.procName.indexOf(40) > -1;
        if (bl3 && this.specificName != null) {
            boolean bl6 = bl4 = this.specificName.indexOf(40) > -1;
        }
        if (!bl || bl4 && bl2) {
            return this.buildObjectExpression(wbConnection, bl3);
        }
        this.readParameters(wbConnection);
        if (CollectionUtil.isEmpty(this.parameters)) {
            return this.getObjectExpression(wbConnection) + "()";
        }
        int n = 0;
        for (ColumnIdentifier columnIdentifier : this.parameters) {
            boolean bl7 = bl2 || columnIdentifier.getArgumentMode().startsWith("IN");
            if (!bl7) continue;
            ++n;
        }
        if (n == 0) {
            return this.getObjectExpression(wbConnection) + "()";
        }
        StringBuilder stringBuilder = new StringBuilder(this.procName.length() + n * 5 + 5);
        stringBuilder.append(SqlUtil.buildExpression(wbConnection, this.catalog, this.schema, this.getBasename(bl3)));
        stringBuilder.append('(');
        int n2 = 0;
        Iterator<ColumnIdentifier> iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ColumnIdentifier columnIdentifier;
            ColumnIdentifier columnIdentifier2 = columnIdentifier = iterator.next();
            boolean bl8 = bl2 || columnIdentifier2.getArgumentMode().startsWith("IN");
            if (!bl8) continue;
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(columnIdentifier.getDbmsType());
            ++n2;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        if (wbConnection == null) {
            return this.source;
        }
        if (this.source == null) {
            try {
                wbConnection.getMetadata().getProcedureReader().readProcedureSource(this);
            }
            catch (NoConfigException noConfigException) {
                this.source = "N/A";
            }
        }
        return this.source;
    }

    protected String getBasename(boolean bl) {
        if (bl && this.specificName != null) {
            return this.specificName;
        }
        String string = this.procName;
        if (this.procName.indexOf(40) > -1) {
            string = this.procName.substring(0, string.indexOf(40));
        }
        return string;
    }

    @Override
    public String getObjectName(WbConnection wbConnection) {
        String string = this.getBasename(false);
        return wbConnection.getMetadata().quoteObjectname(string);
    }

    @Override
    public String getFullyQualifiedName(WbConnection wbConnection) {
        return this.getObjectExpression(null);
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return this.buildObjectExpression(wbConnection, false);
    }

    private String buildObjectExpression(WbConnection wbConnection, boolean bl) {
        String string = null;
        string = bl && this.specificName != null ? this.specificName : this.procName;
        String string2 = string;
        int n = string.indexOf(40);
        if (n > -1) {
            string2 = string2.substring(0, n);
        }
        String string3 = SqlUtil.buildExpression(wbConnection, this.catalog, this.schema, string2);
        if (n > -1) {
            string3 = string3 + string.substring(n);
        }
        return string3;
    }

    @Override
    public String getObjectName() {
        return this.procName;
    }

    public void setSource(CharSequence charSequence) {
        this.source = charSequence;
    }

    public CharSequence getSource() {
        return this.source;
    }

    public void setPackageName(String string) {
        if (StringUtil.isNonEmpty(string)) {
            this.procType = ProcType.packageType;
            this.catalog = string;
        }
    }

    public boolean isPackageProcedure() {
        return this.procType == ProcType.packageType;
    }

    public boolean isOracleObjectType() {
        return this.procType == ProcType.objectType;
    }

    public String getPackageName() {
        if (this.isPackageProcedure() || this.isOracleObjectType()) {
            return this.catalog;
        }
        return null;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public String getProcedureName() {
        return this.getObjectName();
    }

    public int getResultType() {
        return this.resultType;
    }

    @Override
    public String getObjectType() {
        if (this.dbmsProcType != null) {
            return this.dbmsProcType;
        }
        if (this.isOracleObjectType()) {
            return "TYPE";
        }
        if (this.resultType == 2) {
            return "FUNCTION";
        }
        return "PROCEDURE";
    }

    public String toString() {
        String string;
        String string2 = string = this.procType != null ? this.catalog + "." + this.procName : this.procName;
        if (CollectionUtil.isNonEmpty(this.parameters)) {
            return string + "( " + StringUtil.listToString(this.getParameterNames(), ", ", false) + " )";
        }
        return string;
    }

    public String createSql(WbConnection wbConnection) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        DataStore dataStore = null;
        try {
            dataStore = wbConnection.getMetadata().getProcedureReader().getProcedureColumns(this);
            bl2 = ProcedureDefinition.returnsRefCursor(wbConnection, dataStore);
            int n = dataStore.getRowCount();
            for (int i = 0; i < n; ++i) {
                String string2 = dataStore.getValueAsString(i, 1);
                if (string2.endsWith("OUT")) {
                    bl = true;
                }
                if (!string2.equals("RETURN")) continue;
                bl3 = true;
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read procedure definition", exception);
            return null;
        }
        if (bl3 && !bl2 && !bl && (string = this.buildFunctionCall(wbConnection, dataStore)) != null) {
            return string;
        }
        return this.createWbCallStatement(dataStore);
    }

    public String createWbCallStatement(DataStore dataStore) {
        StringBuilder stringBuilder = new StringBuilder(150);
        CommandTester commandTester = new CommandTester();
        StringBuilder stringBuilder2 = new StringBuilder(50);
        stringBuilder.append(commandTester.formatVerb("WbCall"));
        stringBuilder.append(' ');
        stringBuilder.append(this.procType != null ? this.catalog + "." + this.procName : this.procName);
        stringBuilder.append("(");
        int n = 0;
        int n2 = dataStore.getRowCount();
        for (int i = 0; i < n2; ++i) {
            String string = dataStore.getValueAsString(i, 1);
            String string2 = dataStore.getValueAsString(i, 0);
            if (n > 0) {
                stringBuilder.append(',');
            }
            if (!string.equals("IN") && !string.endsWith("OUT")) continue;
            if (n == 0) {
                stringBuilder2.append("-- Parameters: ");
            } else {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append(string2);
            stringBuilder2.append(" (");
            stringBuilder2.append(string);
            stringBuilder2.append(')');
            stringBuilder.append('?');
            ++n;
        }
        stringBuilder.append(");");
        if (n > 0) {
            stringBuilder2.append('\n');
            stringBuilder.insert(0, stringBuilder2);
        }
        return stringBuilder.toString();
    }

    private String buildFunctionCall(WbConnection wbConnection, DataStore dataStore) {
        String string = wbConnection.getDbSettings().getSelectForFunctionSQL();
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append(this.procType != null ? this.catalog + "." + this.procName : this.procName);
        stringBuilder.append("(");
        int n = dataStore.getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string2 = dataStore.getValueAsString(i, 1);
            String string3 = dataStore.getValueAsString(i, 0);
            int n3 = dataStore.getValueAsInt(i, 3, 1111);
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            if (string2.equals("RETURN")) continue;
            if (SqlUtil.isCharacterType(n3)) {
                stringBuilder.append('\'');
            }
            stringBuilder.append("$[?");
            stringBuilder.append(string3);
            stringBuilder.append(']');
            if (SqlUtil.isCharacterType(n3)) {
                stringBuilder.append('\'');
            }
            ++n2;
        }
        stringBuilder.append(")");
        String string4 = string.replace("%function%", stringBuilder.toString());
        return string4;
    }

    public static boolean isRefCursor(WbConnection wbConnection, String string) {
        Collection<String> collection = wbConnection.getDbSettings().getRefCursorTypeNames();
        return collection.contains(string);
    }

    public boolean hasOutParameter(DataStore dataStore) {
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string = dataStore.getValueAsString(i, 1);
            if (!string.endsWith("OUT")) continue;
            return true;
        }
        return false;
    }

    public static boolean returnsRefCursor(WbConnection wbConnection, DataStore dataStore) {
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string = dataStore.getValueAsString(i, 2);
            String string2 = dataStore.getValueAsString(i, 1);
            if (!ProcedureDefinition.isRefCursor(wbConnection, string) || !"RETURN".equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFunction(ProcedureDefinition procedureDefinition, DataStore dataStore) {
        if (procedureDefinition.isFunction()) {
            return true;
        }
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string = dataStore.getValueAsString(i, 1);
            if (!"RETURN".equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isFunction() {
        return this.resultType == 2;
    }

    public boolean isFunction(DataStore dataStore) {
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string = dataStore.getValueAsString(i, 1);
            if (!"RETURN".equals(string)) continue;
            return true;
        }
        return false;
    }

    private static enum ProcType implements Serializable
    {
        packageType,
        objectType;

    }
}

