/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import workbench.db.ConstraintReader;
import workbench.db.DBID;
import workbench.db.DbMetadata;
import workbench.db.DefaultViewReader;
import workbench.db.ErrorInformationReader;
import workbench.db.IndexReader;
import workbench.db.JdbcIndexReader;
import workbench.db.JdbcProcedureReader;
import workbench.db.JdbcUtils;
import workbench.db.ProcedureReader;
import workbench.db.SequenceReader;
import workbench.db.SybaseConstraintReader;
import workbench.db.SynonymReader;
import workbench.db.UniqueConstraintReader;
import workbench.db.ViewReader;
import workbench.db.WbConnection;
import workbench.db.clickhouse.ClickhouseViewReader;
import workbench.db.cubrid.CubridSequenceReader;
import workbench.db.derby.DerbyConstraintReader;
import workbench.db.derby.DerbySequenceReader;
import workbench.db.derby.DerbySynonymReader;
import workbench.db.firebird.FirebirdConstraintReader;
import workbench.db.firebird.FirebirdIndexReader;
import workbench.db.firebird.FirebirdProcedureReader;
import workbench.db.firebird.FirebirdSequenceReader;
import workbench.db.firstsql.FirstSqlConstraintReader;
import workbench.db.h2database.H2ConstraintReader;
import workbench.db.h2database.H2IndexReader;
import workbench.db.h2database.H2SequenceReader;
import workbench.db.h2database.H2UniqueConstraintReader;
import workbench.db.hana.HanaProcedureReader;
import workbench.db.hana.HanaSequenceReader;
import workbench.db.hana.HanaSynonymReader;
import workbench.db.hana.HanaViewReader;
import workbench.db.hsqldb.HsqlConstraintReader;
import workbench.db.hsqldb.HsqlIndexReader;
import workbench.db.hsqldb.HsqlSequenceReader;
import workbench.db.hsqldb.HsqlSynonymReader;
import workbench.db.hsqldb.HsqlUniqueConstraintReader;
import workbench.db.ibm.DB2UniqueConstraintReader;
import workbench.db.ibm.Db2ConstraintReader;
import workbench.db.ibm.Db2IndexReader;
import workbench.db.ibm.Db2ProcedureReader;
import workbench.db.ibm.Db2SequenceReader;
import workbench.db.ibm.Db2SynonymReader;
import workbench.db.ibm.InformixProcedureReader;
import workbench.db.ibm.InformixSequenceReader;
import workbench.db.ibm.InformixSynonymReader;
import workbench.db.ingres.IngresSequenceReader;
import workbench.db.ingres.IngresSynonymReader;
import workbench.db.mariadb.MariaDBSequenceReader;
import workbench.db.monetdb.MonetDbIndexReader;
import workbench.db.monetdb.MonetDbProcedureReader;
import workbench.db.monetdb.MonetDbSequenceReader;
import workbench.db.mssql.SqlServerConstraintReader;
import workbench.db.mssql.SqlServerIndexReader;
import workbench.db.mssql.SqlServerProcedureReader;
import workbench.db.mssql.SqlServerSequenceReader;
import workbench.db.mssql.SqlServerSynonymReader;
import workbench.db.mssql.SqlServerUniqueConstraintReader;
import workbench.db.mssql.SqlServerViewReader;
import workbench.db.mysql.MySQLConstraintReader;
import workbench.db.mysql.MySQLIndexReader;
import workbench.db.mysql.MySQLViewReader;
import workbench.db.mysql.MySqlProcedureReader;
import workbench.db.nuodb.NuoDBSequenceReader;
import workbench.db.oracle.OracleConstraintReader;
import workbench.db.oracle.OracleErrorInformationReader;
import workbench.db.oracle.OracleIndexReader;
import workbench.db.oracle.OracleProcedureReader;
import workbench.db.oracle.OracleSequenceReader;
import workbench.db.oracle.OracleSynonymReader;
import workbench.db.oracle.OracleUniqueConstraintReader;
import workbench.db.oracle.OracleViewReader;
import workbench.db.postgres.PostgresConstraintReader;
import workbench.db.postgres.PostgresIndexReader;
import workbench.db.postgres.PostgresProcedureReader;
import workbench.db.postgres.PostgresSequenceReader;
import workbench.db.postgres.PostgresUniqueConstraintReader;
import workbench.db.postgres.PostgresViewReader;
import workbench.db.progress.OpenEdgeSequenceReader;
import workbench.db.progress.OpenEdgeSynonymReader;
import workbench.db.redshift.RedshiftUDFReader;
import workbench.db.teradata.TeradataIndexReader;
import workbench.db.teradata.TeradataProcedureReader;
import workbench.db.vertica.VerticaSequenceReader;
import workbench.resource.Settings;

public class ReaderFactory {
    public static ProcedureReader getProcedureReader(DbMetadata dbMetadata) {
        DBID dBID = DBID.fromID(dbMetadata.getDbId());
        switch (dBID) {
            case DB2_LUW: 
            case DB2_ISERIES: 
            case DB2_ZOS: {
                return new Db2ProcedureReader(dbMetadata.getWbConnection(), dbMetadata.getDbId());
            }
            case Oracle: {
                return new OracleProcedureReader(dbMetadata.getWbConnection());
            }
            case Postgres: 
            case Greenplum: {
                return new PostgresProcedureReader(dbMetadata.getWbConnection());
            }
            case Redshift: {
                return new RedshiftUDFReader(dbMetadata.getWbConnection());
            }
            case Firebird: {
                return new FirebirdProcedureReader(dbMetadata.getWbConnection());
            }
            case SQL_Server: {
                boolean bl = Settings.getInstance().getBoolProperty("workbench.db.mssql.usejdbcprocreader", false);
                if (!bl) {
                    return new SqlServerProcedureReader(dbMetadata.getWbConnection());
                }
            }
            case MySQL: 
            case MariaDB: {
                return new MySqlProcedureReader(dbMetadata.getWbConnection());
            }
            case Teradata: {
                return new TeradataProcedureReader(dbMetadata.getWbConnection());
            }
            case MonetDB: {
                if (!Settings.getInstance().getBoolProperty("workbench.db.monetdb.procedurelist.usedriver")) {
                    return new MonetDbProcedureReader(dbMetadata.getWbConnection());
                }
            }
            case Informix: {
                if (Settings.getInstance().getBoolProperty("workbench.db.informix_dynamic_server.procedurelist.usecustom", true)) {
                    return new InformixProcedureReader(dbMetadata.getWbConnection());
                }
            }
            case HANA: {
                return new HanaProcedureReader(dbMetadata.getWbConnection());
            }
        }
        return new JdbcProcedureReader(dbMetadata.getWbConnection());
    }

    public static SequenceReader getSequenceReader(WbConnection wbConnection) {
        DbMetadata dbMetadata = wbConnection.getMetadata();
        DBID dBID = DBID.fromConnection(wbConnection);
        switch (dBID) {
            case Postgres: 
            case Greenplum: 
            case Redshift: {
                return new PostgresSequenceReader(wbConnection);
            }
            case Oracle: {
                return new OracleSequenceReader(wbConnection);
            }
            case HSQLDB: {
                return new HsqlSequenceReader(wbConnection);
            }
            case Derby: {
                if (JdbcUtils.hasMinimumServerVersion(wbConnection, "10.6")) {
                    return new DerbySequenceReader(wbConnection);
                }
            }
            case H2: {
                return new H2SequenceReader(wbConnection);
            }
            case Firebird: {
                return new FirebirdSequenceReader(wbConnection);
            }
            case DB2_LUW: 
            case DB2_ISERIES: 
            case DB2_ZOS: {
                return new Db2SequenceReader(wbConnection, dbMetadata.getDbId());
            }
            case Cubrid: {
                return new CubridSequenceReader(wbConnection);
            }
            case Vertica: {
                return new VerticaSequenceReader(wbConnection);
            }
            case SQL_Server: {
                return new SqlServerSequenceReader(wbConnection);
            }
            case Informix: {
                return new InformixSequenceReader(wbConnection);
            }
            case Ingres: {
                return new IngresSequenceReader(wbConnection);
            }
            case MonetDB: {
                return new MonetDbSequenceReader(wbConnection);
            }
            case HANA: {
                return new HanaSequenceReader(wbConnection);
            }
            case OPENEDGE: {
                return new OpenEdgeSequenceReader(wbConnection);
            }
            case MariaDB: {
                if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "10.3")) break;
                return new MariaDBSequenceReader(wbConnection);
            }
        }
        if (wbConnection.getDbId().equals("nuodb")) {
            return new NuoDBSequenceReader(wbConnection);
        }
        return null;
    }

    public static IndexReader getIndexReader(DbMetadata dbMetadata) {
        DBID dBID = DBID.fromID(dbMetadata.getDbId());
        switch (dBID) {
            case Oracle: {
                return new OracleIndexReader(dbMetadata);
            }
            case Postgres: 
            case Greenplum: 
            case Redshift: {
                return new PostgresIndexReader(dbMetadata);
            }
            case H2: {
                return new H2IndexReader(dbMetadata);
            }
            case HSQLDB: {
                return new HsqlIndexReader(dbMetadata);
            }
            case Firebird: {
                if (JdbcUtils.hasMinimumServerVersion(dbMetadata.getWbConnection(), "2.5")) {
                    return new FirebirdIndexReader(dbMetadata);
                }
            }
            case MySQL: 
            case MariaDB: {
                return new MySQLIndexReader(dbMetadata);
            }
            case SQL_Server: {
                return new SqlServerIndexReader(dbMetadata);
            }
            case DB2_LUW: {
                return new Db2IndexReader(dbMetadata);
            }
            case Teradata: {
                return new TeradataIndexReader(dbMetadata);
            }
            case MonetDB: {
                return new MonetDbIndexReader(dbMetadata);
            }
        }
        return new JdbcIndexReader(dbMetadata);
    }

    public static ConstraintReader getConstraintReader(DbMetadata dbMetadata) {
        DBID dBID = DBID.fromID(dbMetadata.getDbId());
        switch (dBID) {
            case Postgres: 
            case Greenplum: 
            case Redshift: {
                return new PostgresConstraintReader(dbMetadata.getDbId());
            }
            case Oracle: {
                return new OracleConstraintReader(dbMetadata.getDbId());
            }
            case HSQLDB: {
                return new HsqlConstraintReader(dbMetadata.getWbConnection());
            }
            case SQL_Server: {
                return new SqlServerConstraintReader(dbMetadata.getWbConnection());
            }
            case DB2_LUW: 
            case DB2_ISERIES: 
            case DB2_ZOS: {
                return new Db2ConstraintReader(dbMetadata.getWbConnection());
            }
            case Firebird: {
                return new FirebirdConstraintReader();
            }
            case H2: {
                return new H2ConstraintReader();
            }
            case Derby: {
                return new DerbyConstraintReader();
            }
            case MySQL: {
                if (JdbcUtils.hasMinimumServerVersion(dbMetadata.getWbConnection(), "8.0.16")) {
                    return new MySQLConstraintReader();
                }
            }
            case MariaDB: {
                if (!JdbcUtils.hasMinimumServerVersion(dbMetadata.getWbConnection(), "10.2")) break;
                return new MySQLConstraintReader();
            }
        }
        if (dBID.getId().startsWith("adaptive_server")) {
            return new SybaseConstraintReader(dbMetadata.getWbConnection());
        }
        if (dBID.getId().startsWith("firstsql")) {
            return new FirstSqlConstraintReader();
        }
        return ConstraintReader.NULL_READER;
    }

    public static UniqueConstraintReader getUniqueConstraintReader(WbConnection wbConnection) {
        if (wbConnection == null) {
            return null;
        }
        DBID dBID = DBID.fromConnection(wbConnection);
        switch (dBID) {
            case Postgres: 
            case Greenplum: 
            case Redshift: {
                return new PostgresUniqueConstraintReader();
            }
            case Oracle: {
                return new OracleUniqueConstraintReader();
            }
            case DB2_LUW: 
            case DB2_ZOS: {
                return new DB2UniqueConstraintReader();
            }
            case SQL_Server: {
                return new SqlServerUniqueConstraintReader();
            }
            case HSQLDB: {
                return new HsqlUniqueConstraintReader();
            }
            case H2: {
                return new H2UniqueConstraintReader();
            }
        }
        return null;
    }

    public static ViewReader createViewReader(WbConnection wbConnection) {
        DBID dBID = DBID.fromID(wbConnection.getDbId());
        switch (dBID) {
            case Postgres: {
                return new PostgresViewReader(wbConnection);
            }
            case MySQL: 
            case MariaDB: {
                return new MySQLViewReader(wbConnection);
            }
            case Oracle: {
                return new OracleViewReader(wbConnection);
            }
            case SQL_Server: {
                return new SqlServerViewReader(wbConnection);
            }
            case HANA: {
                return new HanaViewReader(wbConnection);
            }
            case Clickhouse: {
                return new ClickhouseViewReader(wbConnection);
            }
        }
        return new DefaultViewReader(wbConnection);
    }

    public static SynonymReader getSynonymReader(WbConnection wbConnection) {
        if (wbConnection == null) {
            return null;
        }
        DBID dBID = DBID.fromID(wbConnection.getDbId());
        switch (dBID) {
            case Oracle: {
                return new OracleSynonymReader();
            }
            case Derby: {
                return new DerbySynonymReader();
            }
            case SQL_Server: {
                if (SqlServerSynonymReader.supportsSynonyms(wbConnection)) {
                    return new SqlServerSynonymReader(wbConnection.getMetadata());
                }
            }
            case DB2_LUW: 
            case DB2_ISERIES: 
            case DB2_ZOS: {
                return new Db2SynonymReader();
            }
            case Ingres: {
                return new IngresSynonymReader();
            }
            case Informix: {
                return new InformixSynonymReader();
            }
            case HANA: {
                return new HanaSynonymReader();
            }
            case OPENEDGE: {
                return new OpenEdgeSynonymReader();
            }
            case HSQLDB: {
                if (!JdbcUtils.hasMinimumServerVersion(wbConnection, "2.3.4")) break;
                return new HsqlSynonymReader();
            }
        }
        return null;
    }

    public static ErrorInformationReader getErrorInformationReader(WbConnection wbConnection) {
        if (wbConnection == null) {
            return null;
        }
        if (wbConnection.getMetadata().isOracle()) {
            return new OracleErrorInformationReader(wbConnection);
        }
        return null;
    }
}

