/*
 * Decompiled with CFR 0.152.
 */
package workbench.db;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.PkDefinition;
import workbench.db.QuoteHandler;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.TableSourceBuilderFactory;
import workbench.db.TypeMapper;
import workbench.db.WbConnection;
import workbench.db.sqltemplates.ColumnDefinitionTemplate;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.formatter.FormatterUtil;
import workbench.sql.syntax.SqlKeywordHelper;

public class TableCreator {
    private WbConnection connection;
    private List<ColumnIdentifier> columnList;
    private TableIdentifier tablename;
    private TypeMapper mapper;
    private boolean useDbmsDataType;
    private boolean useColumnAlias;
    private boolean removeDefaults;
    private String creationType;
    private ColumnDefinitionTemplate columnTemplate;
    private boolean storeSQL;
    private List<String> generatedSQL;
    private boolean useFormatterSettings;

    public TableCreator(TableIdentifier tableIdentifier, Collection<ColumnIdentifier> collection) throws SQLException {
        this(null, null, tableIdentifier, collection);
    }

    public TableCreator(WbConnection wbConnection, String string, TableIdentifier tableIdentifier, Collection<ColumnIdentifier> collection) throws SQLException {
        this.connection = wbConnection;
        this.tablename = tableIdentifier.createCopy();
        this.columnList = new ArrayList<ColumnIdentifier>(collection);
        ColumnIdentifier.sortByPosition(this.columnList);
        if (this.connection != null) {
            this.mapper = new TypeMapper(this.connection);
            this.columnTemplate = new ColumnDefinitionTemplate(this.connection.getMetadata().getDbId());
            this.columnTemplate.setFixDefaultValues(!this.connection.getDbSettings().returnsValidDefaultExpressions());
        } else {
            this.mapper = new TypeMapper();
            this.columnTemplate = new ColumnDefinitionTemplate();
            this.columnTemplate.setFixDefaultValues(false);
        }
        this.creationType = string;
    }

    public void setUseColumnAlias(boolean bl) {
        this.useColumnAlias = bl;
    }

    public void useDbmsDataType(boolean bl) {
        this.useDbmsDataType = bl;
    }

    public void setRemoveDefaults(boolean bl) {
        this.removeDefaults = bl;
    }

    public void setUseFormatterSettings(boolean bl) {
        this.useFormatterSettings = bl;
    }

    public TableIdentifier getTable() {
        return this.tablename;
    }

    public String getCreateTableSQL() throws SQLException {
        CharSequence charSequence;
        StringBuilder stringBuilder = new StringBuilder(100);
        String string = null;
        string = this.connection != null ? this.connection.getDbSettings().getCreateTableTemplate(this.creationType) : "CREATE TABLE %fq_table_name%\n(\n%columnlist%\n)";
        String string2 = this.getIdentifier(this.tablename.getTableExpression(this.connection));
        int n = 0;
        List<String> list = this.getPKColumns();
        stringBuilder.append("  ");
        for (ColumnIdentifier columnIdentifier : this.columnList) {
            charSequence = this.getColumnDefintionString(columnIdentifier);
            if (charSequence == null) continue;
            if (n > 0) {
                stringBuilder.append(",\n  ");
            }
            stringBuilder.append((String)charSequence);
            ++n;
        }
        Object object = string.replace("%fq_table_name%", string2);
        object = ((String)object).replace("%columnlist%", stringBuilder);
        int n2 = ((String)object).indexOf("%pk_definition%");
        if (list.size() > 0 && n2 > -1) {
            charSequence = new StringBuilder(list.size() * 10);
            ((StringBuilder)charSequence).append(",\n  ");
            String string3 = "PRIMARY KEY";
            if (this.connection != null) {
                string3 = this.connection.getDbSettings().getInlinePKKeyword();
            }
            ((StringBuilder)charSequence).append(string3);
            ((StringBuilder)charSequence).append(" (");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    ((StringBuilder)charSequence).append(',');
                }
                ((StringBuilder)charSequence).append(this.getIdentifier(this.getQuoteHandler().quoteObjectname(list.get(i))));
            }
            ((StringBuilder)charSequence).append(')');
            object = ((String)object).replace("%pk_definition%", ((StringBuilder)charSequence).toString());
        } else if (n2 > -1) {
            object = ((String)object).replace("%pk_definition%", "");
        }
        return object;
    }

    public String getAddPKSQL() {
        PkDefinition pkDefinition;
        TableSourceBuilder tableSourceBuilder;
        CharSequence charSequence;
        if (this.connection == null) {
            return null;
        }
        List<String> list = this.getPKColumns();
        if (list.size() > 0 && (charSequence = (tableSourceBuilder = TableSourceBuilderFactory.getBuilder(this.connection)).getPkSource(this.tablename, pkDefinition = new PkDefinition(list), false, false)).length() > 0) {
            return charSequence.toString();
        }
        return null;
    }

    private boolean addPKNeeded() {
        String string = this.connection.getDbSettings().getCreateTableTemplate(this.creationType);
        return !string.contains("%pk_definition%");
    }

    private List<String> getPKColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ColumnIdentifier columnIdentifier : this.columnList) {
            if (!columnIdentifier.isPkColumn()) continue;
            arrayList.add(columnIdentifier.getColumnName());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable() throws SQLException {
        String string = this.getCreateTableSQL();
        if (this.storeSQL) {
            this.generatedSQL = new ArrayList<String>(2);
            this.generatedSQL.add(string);
        }
        Statement statement = this.connection.createStatement();
        boolean bl = this.needsCommit();
        try {
            LogMgr.logInfo(new CallerInfo(){}, "Creating table using sql: " + string);
            statement.executeUpdate(string);
            if (this.addPKNeeded()) {
                String string2 = this.getAddPKSQL();
                if (string2 != null) {
                    LogMgr.logInfo(new CallerInfo(){}, "Adding primary key using: " + string2);
                    statement.executeUpdate(string2);
                }
                if (this.storeSQL) {
                    this.generatedSQL.add(string2);
                }
            }
            if (bl) {
                LogMgr.logDebug(new CallerInfo(){}, "Commiting the CREATE TABLE");
                this.connection.commit();
            }
        }
        finally {
            JdbcUtils.closeStatement(statement);
        }
    }

    private boolean needsCommit() {
        return this.connection.shouldCommitDDL() && this.connection.getDbSettings().commitCreateTable(this.creationType);
    }

    private String getColumnDefintionString(ColumnIdentifier columnIdentifier) {
        if (columnIdentifier == null) {
            return null;
        }
        int n = columnIdentifier.getDataType();
        int n2 = columnIdentifier.getColumnSize();
        int n3 = columnIdentifier.getDecimalDigits();
        String string = this.useColumnAlias ? columnIdentifier.getDisplayName() : columnIdentifier.getColumnName();
        StringBuilder stringBuilder = new StringBuilder(30);
        if (!this.getQuoteHandler().isQuoted(string)) {
            boolean bl;
            if (this.connection != null) {
                bl = this.connection.getMetadata().isReservedWord(string);
            } else {
                SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper();
                bl = sqlKeywordHelper.getReservedWords().contains(string);
            }
            if (bl || !this.getQuoteHandler().isLegalIdentifier(string)) {
                string = this.getQuoteHandler().getIdentifierQuoteCharacter() + string + this.getQuoteHandler().getIdentifierQuoteCharacter();
            }
        }
        stringBuilder.append(this.getIdentifier(string));
        stringBuilder.append(' ');
        String string2 = null;
        if (!this.useDbmsDataType) {
            string2 = this.mapper.getTypeName(n, n2, n3);
        }
        if (this.useFormatterSettings) {
            string2 = FormatterUtil.getDataType(string2);
        }
        if (this.removeDefaults) {
            columnIdentifier = columnIdentifier.createCopy();
            columnIdentifier.setDefaultValue(null);
        }
        stringBuilder.append(this.columnTemplate.getColumnDefinitionSQL(columnIdentifier, null, 0, string2));
        return stringBuilder.toString();
    }

    private String getIdentifier(String string) {
        if (this.useFormatterSettings) {
            return FormatterUtil.getIdentifier(string);
        }
        return string;
    }

    private QuoteHandler getQuoteHandler() {
        if (this.connection != null) {
            return this.connection.getMetadata();
        }
        return QuoteHandler.STANDARD_HANDLER;
    }

    public List<String> getGeneratedSQL() {
        return this.generatedSQL;
    }

    public void setStoreSQL(boolean bl) {
        this.storeSQL = bl;
    }
}

