/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.compare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import workbench.db.ColumnIdentifier;
import workbench.db.WbConnection;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.ExportType;
import workbench.db.exporter.SqlRowDataConverter;
import workbench.db.exporter.XmlRowDataConverter;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class RowDataComparer {
    private RowData migrationData;
    private boolean targetWasNull;
    private WbConnection targetDb;
    private ResultInfo resultInfo;
    private BlobMode blobMode;
    private String clobFileEncoding;
    private int clobFileThreshold = -1;
    private SqlRowDataConverter sqlConverter;
    private XmlRowDataConverter xmlConverter;
    private String sqlDateLiteral;
    private WbFile baseDir;
    private boolean applySQLFormatting;

    public void setApplySQLFormatting(boolean bl) {
        this.applySQLFormatting = bl;
    }

    public void setBaseDir(WbFile wbFile) {
        this.baseDir = wbFile;
        if (this.sqlConverter != null) {
            this.sqlConverter.setOutputFile(wbFile);
        }
        if (this.xmlConverter != null) {
            this.xmlConverter.setOutputFile(wbFile);
        }
    }

    public void setSqlDateLiteralType(String string) {
        this.sqlDateLiteral = string;
        if (this.sqlConverter != null) {
            this.sqlConverter.setDateLiteralType(string);
        }
    }

    public void setTypeSql() {
        this.sqlConverter = new SqlRowDataConverter(this.targetDb);
        this.sqlConverter.setBlobMode(this.blobMode);
        if (this.resultInfo != null) {
            this.sqlConverter.setResultInfo(this.resultInfo);
        }
        if (this.sqlDateLiteral != null) {
            this.sqlConverter.setDateLiteralType(this.sqlDateLiteral);
        }
        if (this.blobMode != null) {
            this.sqlConverter.setBlobMode(this.blobMode);
        }
        this.sqlConverter.setOutputFile(this.baseDir);
        if (this.clobFileEncoding != null) {
            this.sqlConverter.setClobAsFile(this.clobFileEncoding, this.clobFileThreshold);
        }
        this.xmlConverter = null;
    }

    public void setClobAsFile(String string, int n) {
        this.clobFileEncoding = StringUtil.trimToNull(string);
        this.clobFileThreshold = n;
        if (this.sqlConverter != null) {
            this.sqlConverter.setClobAsFile(this.clobFileEncoding, this.clobFileThreshold);
        }
    }

    public boolean isTypeXml() {
        return this.xmlConverter != null;
    }

    public void setTypeXml(boolean bl) {
        this.xmlConverter = new XmlRowDataConverter();
        this.xmlConverter.setUseVerboseFormat(false);
        this.xmlConverter.setUseDiffFormat(true);
        this.xmlConverter.setWriteClobToFile(false);
        this.xmlConverter.setUseCDATA(bl);
        this.xmlConverter.setOriginalConnection(this.targetDb);
        if (this.resultInfo != null) {
            this.xmlConverter.setResultInfo(this.resultInfo);
        }
        this.sqlConverter = null;
        this.xmlConverter.setOutputFile(this.baseDir);
    }

    public void setSqlBlobMode(BlobMode blobMode) {
        this.blobMode = blobMode;
        if (this.sqlConverter != null) {
            this.sqlConverter.setBlobMode(blobMode);
        }
    }

    public void setConnection(WbConnection wbConnection) {
        this.targetDb = wbConnection;
    }

    public void setResultInfo(ResultInfo resultInfo) {
        this.resultInfo = resultInfo;
        if (this.sqlConverter != null) {
            this.sqlConverter.setResultInfo(resultInfo);
        }
        if (this.xmlConverter != null) {
            this.xmlConverter.setResultInfo(resultInfo);
        }
    }

    public void setRows(RowData rowData, RowData rowData2) {
        int n = rowData.getColumnCount();
        if (rowData2 == null) {
            this.targetWasNull = true;
            this.migrationData = rowData.createCopy();
            this.migrationData.resetStatus();
            this.migrationData.setNew();
        } else {
            this.targetWasNull = false;
            this.migrationData = rowData2.createCopy();
            this.migrationData.resetStatus();
            this.migrationData.setNormalizeNewLines(true);
            int n2 = this.migrationData.getColumnCount();
            if (n != n2) {
                throw new IllegalArgumentException("Column counts must match!");
            }
            for (int i = 0; i < n; ++i) {
                this.migrationData.setValue(i, rowData.getValue(i));
            }
        }
    }

    public void ignoreColumns(Collection<String> collection, ResultInfo resultInfo) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (!collection.contains(resultInfo.getColumnName(i))) continue;
            this.migrationData.resetStatusForColumn(i);
        }
    }

    public void excludeColumns(Set<String> set, ResultInfo resultInfo) {
        ColumnIdentifier[] columnIdentifierArray = resultInfo.getColumns();
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        for (ColumnIdentifier columnIdentifier : columnIdentifierArray) {
            if (set.contains(columnIdentifier.getColumnName())) continue;
            arrayList.add(columnIdentifier);
        }
        this.sqlConverter.setColumnsToExport(arrayList);
    }

    public String getMigration(long l) {
        StringBuilder stringBuilder = null;
        if (this.sqlConverter != null) {
            if (this.targetWasNull) {
                this.sqlConverter.setIgnoreColumnStatus(true);
                this.sqlConverter.setType(ExportType.SQL_INSERT);
            } else {
                this.sqlConverter.setIgnoreColumnStatus(false);
                this.sqlConverter.setType(ExportType.SQL_UPDATE);
            }
            this.sqlConverter.setApplySQLFormatting(this.applySQLFormatting);
            this.sqlConverter.setLineEnding(StringUtil.LINE_TERMINATOR);
            stringBuilder = this.sqlConverter.convertRowData(this.migrationData, l);
        }
        if (this.xmlConverter != null) {
            if (this.targetWasNull) {
                StringBuilder stringBuilder2 = this.xmlConverter.convertRowData(this.migrationData, l);
                stringBuilder = new StringBuilder(stringBuilder2.length() + 20);
                stringBuilder.append("<insert>");
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append("</insert>");
            } else if (this.migrationData.isModified()) {
                StringBuilder stringBuilder3 = this.xmlConverter.convertRowData(this.migrationData, l);
                stringBuilder = new StringBuilder(stringBuilder3.length() + 20);
                stringBuilder.append("<update>");
                stringBuilder.append((CharSequence)stringBuilder3);
                stringBuilder.append("</update>");
            }
        }
        if (stringBuilder == null) {
            return null;
        }
        return stringBuilder.toString();
    }
}

