/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.compare;

import java.io.IOException;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObjectFinder;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.compare.BatchedStatement;
import workbench.db.compare.TableDataDiff;
import workbench.db.compare.TableDiffStatus;
import workbench.db.exporter.XmlRowDataConverter;
import workbench.interfaces.ProgressReporter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.ColumnData;
import workbench.storage.ResultInfo;
import workbench.storage.RowActionMonitor;
import workbench.storage.RowData;
import workbench.storage.SqlLiteralFormatter;
import workbench.storage.reader.RowDataReader;
import workbench.storage.reader.RowDataReaderFactory;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class TableDeleteSync
implements ProgressReporter {
    private WbConnection targetConnection;
    private WbConnection referenceConnection;
    private TableIdentifier referenceTable;
    private TableDefinition tableToDeleteFrom;
    private BatchedStatement deleteStatement;
    private int chunkSize = 50;
    private int batchSize = 50;
    private Statement checkStatement;
    private final Map<ColumnIdentifier, Integer> columnMap = new HashMap<ColumnIdentifier, Integer>();
    private RowActionMonitor monitor;
    private Writer outputWriter;
    private String lineEnding = "\n";
    private String encoding;
    private SqlLiteralFormatter formatter;
    private long deletedRows;
    private boolean firstDelete;
    private XmlRowDataConverter xmlConverter;
    private boolean cancelExecution;
    private int progressInterval = 10;
    private final Set<String> alternatePKColumns = CollectionUtil.caseInsensitiveSet();

    public TableDeleteSync(WbConnection wbConnection, WbConnection wbConnection2) throws SQLException {
        this.targetConnection = wbConnection;
        this.referenceConnection = wbConnection2;
        this.formatter = new SqlLiteralFormatter(this.targetConnection);
        this.chunkSize = Settings.getInstance().getSyncChunkSize();
    }

    public void setTypeSql() {
        this.xmlConverter = null;
    }

    public void setTypeXml(boolean bl) {
        this.xmlConverter = new XmlRowDataConverter();
        this.xmlConverter.setUseDiffFormat(true);
        this.xmlConverter.setUseVerboseFormat(false);
        this.xmlConverter.setWriteClobToFile(false);
        this.xmlConverter.setUseCDATA(bl);
        this.xmlConverter.setOriginalConnection(this.targetConnection);
        this.xmlConverter.setWriteBlobToFile(false);
    }

    public void setBatchSize(int n) {
        if (n > 0) {
            this.batchSize = n;
        }
    }

    public void setRowMonitor(RowActionMonitor rowActionMonitor) {
        this.monitor = rowActionMonitor;
    }

    public void cancel() {
        this.cancelExecution = true;
    }

    public void setOutputWriter(Writer writer, String string, String string2) {
        this.outputWriter = writer;
        this.lineEnding = string != null ? string : "\n";
        this.encoding = string2;
    }

    @Override
    public void setReportInterval(int n) {
        this.progressInterval = n;
    }

    public long getDeletedRows() {
        return this.deletedRows;
    }

    public TableDiffStatus setTableName(TableIdentifier tableIdentifier, TableIdentifier tableIdentifier2) throws SQLException {
        return this.setTableName(tableIdentifier, tableIdentifier2, null);
    }

    public TableDiffStatus setTableName(TableIdentifier tableIdentifier, TableIdentifier tableIdentifier2, Set<String> set) throws SQLException {
        List<ColumnIdentifier> list;
        if (tableIdentifier == null) {
            throw new IllegalArgumentException("Source table may not be null!");
        }
        if (tableIdentifier2 == null) {
            throw new IllegalArgumentException("Target table (for source: " + tableIdentifier.getTableName() + ") may not be null!");
        }
        DbObjectFinder dbObjectFinder = new DbObjectFinder(this.referenceConnection);
        this.referenceTable = dbObjectFinder.findSelectableObject(tableIdentifier);
        DbObjectFinder dbObjectFinder2 = new DbObjectFinder(this.targetConnection);
        TableIdentifier tableIdentifier3 = dbObjectFinder2.findTable(tableIdentifier2);
        this.tableToDeleteFrom = this.targetConnection.getMetadata().getTableDefinition(tableIdentifier3, true);
        if (this.tableToDeleteFrom == null) {
            throw new SQLException("Table " + tableIdentifier2.getTableName() + " not found in target database");
        }
        this.firstDelete = true;
        this.columnMap.clear();
        this.alternatePKColumns.clear();
        if (set != null) {
            this.alternatePKColumns.addAll(set);
        }
        if ((list = this.tableToDeleteFrom.getColumns()) == null || list.isEmpty()) {
            throw new SQLException("Table " + this.tableToDeleteFrom.getTable().getTableName() + " not found in target database");
        }
        String string = " WHERE ";
        int n = 1;
        for (ColumnIdentifier object : list) {
            if (!this.isPkColumn(object)) continue;
            if (n > 1) {
                string = string + " AND ";
            }
            String string2 = this.targetConnection.getMetadata().quoteObjectname(object.getColumnName());
            string = string + string2 + " = ?";
            this.columnMap.put(object, n);
            ++n;
        }
        if (this.columnMap.isEmpty()) {
            LogMgr.logWarning(new CallerInfo(){}, "No primary key found to delete rows from target table " + tableIdentifier2.getTableName(), null);
            return TableDiffStatus.NoPK;
        }
        if (this.outputWriter == null) {
            String string3 = "DELETE FROM " + this.tableToDeleteFrom.getTable().getFullyQualifiedName(this.targetConnection) + string;
            PreparedStatement preparedStatement = this.targetConnection.getSqlConnection().prepareStatement(string3);
            this.deleteStatement = new BatchedStatement(preparedStatement, this.targetConnection, this.batchSize);
            LogMgr.logInfo(new CallerInfo(){}, "Using " + (String)string3 + " to delete rows from target database");
        }
        return TableDiffStatus.OK;
    }

    private boolean isPkColumn(ColumnIdentifier columnIdentifier) {
        if (columnIdentifier == null) {
            return false;
        }
        if (this.alternatePKColumns.isEmpty()) {
            return columnIdentifier.isPkColumn();
        }
        return this.alternatePKColumns.contains(columnIdentifier.getColumnName());
    }

    public void doSync() throws SQLException, IOException {
        Statement statement;
        ResultSet resultSet;
        block21: {
            List<ColumnIdentifier> list = this.tableToDeleteFrom.getColumns();
            String string = "";
            int n = 0;
            for (ColumnIdentifier object2 : list) {
                if (!this.isPkColumn(object2)) continue;
                if (n > 0) {
                    string = string + ", ";
                }
                string = string + this.targetConnection.getMetadata().quoteObjectname(object2.getColumnName());
                ++n;
            }
            TableIdentifier tableIdentifier = this.tableToDeleteFrom.getTable();
            String string2 = "SELECT " + string + " FROM " + tableIdentifier.getFullyQualifiedName(this.targetConnection);
            LogMgr.logInfo(new CallerInfo(){}, "Using " + string2 + " to retrieve rows from the reference table");
            this.deletedRows = 0L;
            this.cancelExecution = false;
            this.checkStatement = this.referenceConnection.createStatement();
            resultSet = null;
            statement = null;
            try {
                Object object;
                statement = this.targetConnection.createStatementForQuery();
                resultSet = statement.executeQuery(string2);
                ResultInfo sQLException = new ResultInfo(resultSet.getMetaData(), this.targetConnection);
                if (this.xmlConverter != null) {
                    for (int l = 0; l < sQLException.getColumnCount(); ++l) {
                        sQLException.getColumn(l).setIsPkColumn(true);
                    }
                    this.xmlConverter.setResultInfo(sQLException);
                }
                long throwable = 0L;
                if (this.monitor != null) {
                    if (this.outputWriter == null) {
                        this.monitor.setMonitorType(8);
                        this.monitor.setCurrentObject(tableIdentifier.getTableName(), -1L, -1L);
                    } else {
                        this.monitor.setMonitorType(7);
                        object = ResourceMgr.getFormattedString("MsgDeleteSyncProcess", tableIdentifier.getTableName());
                        this.monitor.setCurrentObject((String)object, -1L, -1L);
                    }
                }
                object = new ArrayList(this.chunkSize);
                RowDataReader rowDataReader = RowDataReaderFactory.createReader(sQLException, this.targetConnection);
                while (resultSet.next() && !this.cancelExecution) {
                    if (this.monitor != null && ++throwable % (long)this.progressInterval == 0L) {
                        this.monitor.setCurrentRow(throwable, -1L);
                    }
                    RowData rowData = rowDataReader.read(resultSet, false);
                    object.add(rowData);
                    if (object.size() != this.chunkSize) continue;
                    this.checkRows((List<RowData>)object, sQLException);
                    object.clear();
                }
                if (object.size() > 0 && !this.cancelExecution) {
                    this.checkRows((List<RowData>)object, sQLException);
                }
                if (this.outputWriter == null) {
                    this.deletedRows += this.deleteStatement.flush();
                    if (!this.targetConnection.getAutoCommit()) {
                        this.targetConnection.commit();
                    }
                    break block21;
                }
                this.writeEnd(this.outputWriter);
            }
            catch (SQLException sQLException) {
                try {
                    if (!this.targetConnection.getAutoCommit()) {
                        try {
                            this.targetConnection.rollback();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    if (this.deleteStatement != null) {
                        this.deleteStatement.close();
                    }
                    JdbcUtils.closeStatement(this.checkStatement);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        if (this.deleteStatement != null) {
            this.deleteStatement.close();
        }
        JdbcUtils.closeStatement(this.checkStatement);
    }

    /*
     * Exception decompiling
     */
    private void checkRows(List<RowData> var1_1, ResultInfo var2_2) throws SQLException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processRowToDelete(RowData rowData, ResultInfo resultInfo) throws SQLException {
        if (this.outputWriter == null) {
            for (int i = 0; i < rowData.getColumnCount(); ++i) {
                Integer n = this.columnMap.get(resultInfo.getColumn(i));
                this.deleteStatement.setObject(n, rowData.getValue(i));
            }
            long l = this.deleteStatement.executeUpdate();
            this.deletedRows += l;
        } else {
            try {
                if (this.firstDelete) {
                    this.firstDelete = false;
                    this.writeHeader(this.outputWriter);
                }
                if (this.xmlConverter == null) {
                    this.outputWriter.write("DELETE FROM " + this.tableToDeleteFrom.getTable().getTableExpression(this.targetConnection) + " WHERE ");
                    for (int i = 0; i < rowData.getColumnCount(); ++i) {
                        Object object = rowData.getValue(i);
                        ColumnIdentifier columnIdentifier = resultInfo.getColumn(i);
                        if (i > 0) {
                            this.outputWriter.write(" AND ");
                        }
                        this.outputWriter.write(columnIdentifier.getColumnName());
                        this.outputWriter.write(" = ");
                        this.outputWriter.write(this.formatter.getDefaultLiteral(new ColumnData(object, columnIdentifier)).toString());
                    }
                    this.outputWriter.write(59);
                } else {
                    StringBuilder stringBuilder = this.xmlConverter.convertRowData(rowData, this.deletedRows);
                    if (stringBuilder != null) {
                        this.outputWriter.write("<delete>");
                        this.outputWriter.write(stringBuilder.toString());
                        this.outputWriter.write("</delete>");
                    }
                }
                this.outputWriter.write(this.lineEnding);
            }
            catch (IOException iOException) {
                LogMgr.logError(new CallerInfo(){}, "Error writing DELETE statement", iOException);
            }
        }
    }

    private String buildCheckSql(List<RowData> list, ResultInfo resultInfo) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(150);
        stringBuilder.append("SELECT ");
        for (n = 0; n < resultInfo.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            this.appendReferenceIdentifier(stringBuilder, resultInfo.getColumnName(n));
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.referenceTable.getTableExpression(this.referenceConnection));
        stringBuilder.append(" WHERE ");
        for (n = 0; n < list.size(); ++n) {
            if (n > 0) {
                stringBuilder.append(" OR ");
            }
            stringBuilder.append('(');
            for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
                if (i > 0) {
                    stringBuilder.append(" AND ");
                }
                this.appendReferenceIdentifier(stringBuilder, resultInfo.getColumnName(i));
                Object object = list.get(n).getValue(i);
                if (object == null) {
                    stringBuilder.append(" IS NULL");
                    continue;
                }
                stringBuilder.append(" = ");
                ColumnIdentifier columnIdentifier = resultInfo.getColumn(i);
                ColumnData columnData = new ColumnData(object, columnIdentifier);
                stringBuilder.append(this.formatter.getDefaultLiteral(columnData));
            }
            stringBuilder.append(") ");
        }
        return stringBuilder.toString();
    }

    private void appendReferenceIdentifier(StringBuilder stringBuilder, String string) {
        string = this.targetConnection.getMetadata().removeQuotes(string);
        if (this.targetConnection.getMetadata().needsQuotes(string)) {
            stringBuilder.append(this.referenceConnection.getMetadata().quoteObjectname(string));
        } else {
            stringBuilder.append(string);
        }
    }

    private void writeEnd(Writer writer) throws IOException {
        if (this.xmlConverter != null && !this.firstDelete) {
            writer.write("</table-data-diff>");
            writer.write(this.lineEnding);
        }
    }

    private void writeHeader(Writer writer) throws IOException {
        String string = "Generated by SQL Workbench/J at: " + StringUtil.getCurrentTimestampWithTZString();
        if (this.xmlConverter != null) {
            writer.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            writer.write(this.lineEnding);
            writer.write("<!-- ");
            writer.write(string);
            writer.write(" -->");
            writer.write(this.lineEnding);
            TableDataDiff.writeTableNameTag(writer, "table-data-diff", this.tableToDeleteFrom.getTable());
            writer.write(this.lineEnding);
        } else {
            writer.write("------------------------------------------------------------------");
            writer.write(this.lineEnding);
            writer.write("-- ");
            writer.write(string);
            writer.write(this.lineEnding);
            writer.write("------------------------------------------------------------------");
            writer.write(this.lineEnding);
        }
    }
}

