/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.cubrid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;

public class CubridSequenceReader
implements SequenceReader {
    private WbConnection dbConnection;
    private final String baseSql = "SELECT name,  \n       current_val,  \n       increment_val as increment,  \n       case when max_val = 10000000000000000000000000000000000000 then null else max_val end as maxvalue,  \n       min_val as minvalue,  \n       case when cyclic = 0 then 'NOCYCLE' else 'CYCLE' end as cycle_flag, \n       cached_num as cache \nFROM db_serial \n";

    public CubridSequenceReader(WbConnection wbConnection) {
        this.dbConnection = wbConnection;
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(250);
        try {
            String string = sequenceDefinition.getSequenceName();
            BigDecimal bigDecimal = (BigDecimal)sequenceDefinition.getSequenceProperty("MAXVALUE");
            BigDecimal bigDecimal2 = (BigDecimal)sequenceDefinition.getSequenceProperty("MINVALUE");
            BigDecimal bigDecimal3 = (BigDecimal)sequenceDefinition.getSequenceProperty("INCREMENT");
            Integer n = (Integer)sequenceDefinition.getSequenceProperty("CACHE");
            String string2 = (String)sequenceDefinition.getSequenceProperty("CYCLE");
            stringBuilder.append("CREATE SERIAL ");
            stringBuilder.append(string);
            stringBuilder.append("\n       INCREMENT BY ");
            stringBuilder.append(bigDecimal3);
            stringBuilder.append("\n       MINVALUE ");
            stringBuilder.append(bigDecimal2);
            if (bigDecimal != null) {
                stringBuilder.append("\n       MAXVALUE ");
                stringBuilder.append(bigDecimal.toString());
            }
            stringBuilder.append("\n       CACHE ");
            stringBuilder.append(n);
            if (string2 != null) {
                stringBuilder.append("\n       ");
                stringBuilder.append(string2);
            }
            stringBuilder.append(";\n");
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error reading sequence definition", exception);
        }
        sequenceDefinition.setSource(stringBuilder);
    }

    @Override
    public CharSequence getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        this.readSequenceSource(sequenceDefinition);
        return sequenceDefinition.getSource();
    }

    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        StringBuilder stringBuilder = new StringBuilder("SELECT name,  \n       current_val,  \n       increment_val as increment,  \n       case when max_val = 10000000000000000000000000000000000000 then null else max_val end as maxvalue,  \n       min_val as minvalue,  \n       case when cyclic = 0 then 'NOCYCLE' else 'CYCLE' end as cycle_flag, \n       cached_num as cache \nFROM db_serial \n".length() + 20);
        stringBuilder.append("SELECT name,  \n       current_val,  \n       increment_val as increment,  \n       case when max_val = 10000000000000000000000000000000000000 then null else max_val end as maxvalue,  \n       min_val as minvalue,  \n       case when cyclic = 0 then 'NOCYCLE' else 'CYCLE' end as cycle_flag, \n       cached_num as cache \nFROM db_serial \n");
        if (string3 != null) {
            stringBuilder.append(" WHERE ");
        }
        SqlUtil.appendExpression(stringBuilder, "name", string3, this.dbConnection);
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequences", stringBuilder, new Object[0]);
        try {
            DataStore dataStore = SqlUtil.getResultData(this.dbConnection, stringBuilder.toString(), false);
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                arrayList.add(this.createDefinition(dataStore, i));
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "sequences", stringBuilder, new Object[0]);
        }
        return arrayList;
    }

    private SequenceDefinition createDefinition(DataStore dataStore, int n) throws SQLException {
        String string = dataStore.getValueAsString(n, "name");
        SequenceDefinition sequenceDefinition = new SequenceDefinition(null, string);
        sequenceDefinition.setObjectTypeName(this.getSequenceTypeName());
        sequenceDefinition.setSequenceProperty("INCREMENT", dataStore.getValue(n, "increment"));
        sequenceDefinition.setSequenceProperty("MAXVALUE", dataStore.getValue(n, "maxvalue"));
        sequenceDefinition.setSequenceProperty("MINVALUE", dataStore.getValue(n, "minvalue"));
        sequenceDefinition.setSequenceProperty("CACHE", dataStore.getValue(n, "cache"));
        sequenceDefinition.setSequenceProperty("CYCLE", dataStore.getValue(n, "cycle_flag"));
        return sequenceDefinition;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        List<SequenceDefinition> list = this.getSequences(string, string2, string3);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        if (string3 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("SELECT name,  \n       current_val,  \n       increment_val as increment,  \n       case when max_val = 10000000000000000000000000000000000000 then null else max_val end as maxvalue,  \n       min_val as minvalue,  \n       case when cyclic = 0 then 'NOCYCLE' else 'CYCLE' end as cycle_flag, \n       cached_num as cache \nFROM db_serial \n".length() + 20);
        stringBuilder.append("SELECT name,  \n       current_val,  \n       increment_val as increment,  \n       case when max_val = 10000000000000000000000000000000000000 then null else max_val end as maxvalue,  \n       min_val as minvalue,  \n       case when cyclic = 0 then 'NOCYCLE' else 'CYCLE' end as cycle_flag, \n       cached_num as cache \nFROM db_serial \n");
        stringBuilder.append(" WHERE name = '" + string3 + "'");
        ResultSet resultSet = null;
        Statement statement = null;
        DataStore dataStore = null;
        try {
            statement = this.dbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(stringBuilder.toString());
            dataStore = new DataStore(resultSet, true);
        }
        catch (SQLException sQLException) {
            DataStore dataStore2;
            try {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving sequences using SQL:\n" + stringBuilder, sQLException);
                dataStore2 = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
            return dataStore2;
        }
        JdbcUtils.closeAll(resultSet, statement);
        return dataStore;
    }

    @Override
    public String getSequenceTypeName() {
        return "SERIAL";
    }
}

