/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.diff;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.ComparableDbObject;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.diff.ObjectDiff;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.StringUtil;

public class GenericDiffLoader {
    private WbConnection referenceDb;
    private WbConnection targetDb;
    private String referenceSchema;
    private String targetSchema;
    private List<ObjectDiff> objects;
    private String[] objectTypes;
    private RowActionMonitor progressMonitor;
    private boolean cancelProcessing;

    public GenericDiffLoader(WbConnection wbConnection, WbConnection wbConnection2, String string, String string2, String[] stringArray) {
        this.referenceDb = wbConnection;
        this.targetDb = wbConnection2;
        this.referenceSchema = string;
        this.targetSchema = string2;
        this.objectTypes = stringArray;
    }

    public void setProgressMonitor(RowActionMonitor rowActionMonitor) {
        this.progressMonitor = rowActionMonitor;
    }

    public int getObjectCount() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.size();
    }

    public StringBuilder getMigrateTargetXml(StringBuilder stringBuilder) {
        if (this.objects == null) {
            this.loadObjects();
        }
        StringBuilder stringBuilder2 = new StringBuilder(this.objects.size() * 50);
        for (ObjectDiff objectDiff : this.objects) {
            objectDiff.setIndent(stringBuilder);
            StringBuilder stringBuilder3 = objectDiff.getMigrateTargetXml(this.referenceDb, this.targetDb);
            stringBuilder2.append((CharSequence)stringBuilder3);
            stringBuilder2.append('\n');
        }
        return stringBuilder2;
    }

    public void cancel() {
        this.cancelProcessing = true;
    }

    public void loadObjects() {
        this.cancelProcessing = false;
        this.objects = new ArrayList<ObjectDiff>();
        String string = ResourceMgr.getString("MsgProcessObject") + ": ";
        try {
            DbObject dbObject;
            DbObject dbObject2;
            List<TableIdentifier> list = this.referenceDb.getMetadata().getObjectList(this.referenceSchema, this.objectTypes);
            List<TableIdentifier> list2 = this.targetDb.getMetadata().getObjectList(this.targetSchema, this.objectTypes);
            if (this.progressMonitor != null) {
                this.progressMonitor.setMonitorType(7);
            }
            for (TableIdentifier tableIdentifier : list) {
                Object object;
                if (this.cancelProcessing) break;
                if (this.progressMonitor != null) {
                    this.progressMonitor.setCurrentObject(string + tableIdentifier.getObjectName(), -1L, -1L);
                }
                if (!((dbObject2 = this.referenceDb.getMetadata().getObjectDefinition(tableIdentifier)) instanceof ComparableDbObject)) continue;
                dbObject = (ComparableDbObject)dbObject2;
                ComparableDbObject comparableDbObject = null;
                TableIdentifier tableIdentifier2 = this.findInList(list2, dbObject2);
                if (tableIdentifier2 != null && (object = this.targetDb.getMetadata().getObjectDefinition(tableIdentifier2)) instanceof ComparableDbObject) {
                    comparableDbObject = (ComparableDbObject)object;
                }
                if (!((ObjectDiff)(object = new ObjectDiff((ComparableDbObject)dbObject, comparableDbObject, this.targetSchema))).isDifferent(this.referenceDb, this.targetDb)) continue;
                this.objects.add((ObjectDiff)object);
            }
            if (this.cancelProcessing) {
                return;
            }
            for (TableIdentifier tableIdentifier : list2) {
                if (!this.cancelProcessing) {
                    dbObject2 = this.findInList(list, tableIdentifier);
                    if (dbObject2 != null || !((dbObject = this.targetDb.getMetadata().getObjectDefinition(tableIdentifier)) instanceof ComparableDbObject)) continue;
                    this.objects.add(new ObjectDiff(null, (ComparableDbObject)dbObject, this.targetSchema));
                    continue;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not load database objects", sQLException);
        }
    }

    private TableIdentifier findInList(List<TableIdentifier> list, DbObject dbObject) {
        if (list == null) {
            return null;
        }
        if (dbObject == null) {
            return null;
        }
        for (TableIdentifier tableIdentifier : list) {
            if (!StringUtil.equalStringIgnoreCase(dbObject.getObjectName(), tableIdentifier.getObjectName())) continue;
            return tableIdentifier;
        }
        return null;
    }

    public List<DbObject> getObjectDefinitions(WbConnection wbConnection, String string, String[] stringArray) throws SQLException {
        if (wbConnection == null) {
            return Collections.emptyList();
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata == null) {
            return Collections.emptyList();
        }
        List<TableIdentifier> list = dbMetadata.getObjectList(string, stringArray);
        int n = list.size();
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>(n);
        for (TableIdentifier tableIdentifier : list) {
            DbObject dbObject = dbMetadata.getObjectDefinition(tableIdentifier);
            arrayList.add(dbObject);
        }
        return arrayList;
    }
}

