/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import workbench.db.IndexDefinition;
import workbench.db.TableConstraint;
import workbench.db.TableIdentifier;
import workbench.db.TriggerDefinition;
import workbench.db.diff.ColumnDiff;
import workbench.db.diff.IndexDiff;
import workbench.db.diff.SchemaDiff;
import workbench.db.diff.TableGrantDiff;
import workbench.db.diff.TriggerListDiff;
import workbench.db.report.ForeignKeyDefinition;
import workbench.db.report.ObjectOption;
import workbench.db.report.ReportColumn;
import workbench.db.report.ReportTable;
import workbench.db.report.ReportTableGrants;
import workbench.db.report.TagWriter;
import workbench.resource.Settings;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class TableDiff {
    public static final String TAG_RENAME_TABLE = "rename";
    public static final String TAG_MODIFY_TABLE = "modify-table";
    public static final String TAG_ADD_COLUMN = "add-column";
    public static final String TAG_REMOVE_COLUMN = "remove-column";
    public static final String TAG_ADD_PK = "add-primary-key";
    public static final String TAG_MODIFY_PK = "modify-primary-key";
    public static final String TAG_REMOVE_PK = "remove-primary-key";
    private ReportTable referenceTable;
    private ReportTable targetTable;
    private StringBuilder indent = StringUtil.emptyBuilder();
    private final TagWriter writer = new TagWriter();
    private SchemaDiff diff;
    private boolean checkConstraintNames;

    public TableDiff(ReportTable reportTable, ReportTable reportTable2, SchemaDiff schemaDiff) {
        if (reportTable == null) {
            throw new NullPointerException("Reference table may not be null");
        }
        if (reportTable2 == null) {
            throw new NullPointerException("Target table may not be null");
        }
        this.referenceTable = reportTable;
        this.targetTable = reportTable2;
        this.diff = schemaDiff;
    }

    public void setExactConstraintMatch(boolean bl) {
        this.checkConstraintNames = bl;
    }

    public StringBuilder getMigrateTargetXml() {
        Object object;
        boolean bl;
        Object object22;
        Object object3;
        StringBuilder stringBuilder = new StringBuilder(500);
        TableIdentifier tableIdentifier = this.referenceTable.getTable();
        TableIdentifier tableIdentifier2 = this.targetTable.getTable();
        StringBuilder stringBuilder2 = new StringBuilder(500);
        ArrayList<ReportColumn> arrayList = new ArrayList<ReportColumn>();
        List<ReportColumn> list = this.referenceTable.getColumns();
        StringBuilder stringBuilder3 = new StringBuilder(this.indent);
        stringBuilder3.append("  ");
        for (ReportColumn object42 : list) {
            object3 = this.targetTable.findColumn(object42.getColumn().getColumnName());
            if (object3 == null) {
                arrayList.add(object42);
                continue;
            }
            object22 = new ColumnDiff(object42, (ReportColumn)object3);
            bl = Settings.getInstance().getBoolProperty("workbench.tablediff.columnfk", false);
            ((ColumnDiff)object22).setCompareForeignKeys(bl && this.diff.getIncludeForeignKeys());
            ((ColumnDiff)object22).setCompareJdbcTypes(this.diff.getCompareJdbcTypes());
            ((ColumnDiff)object22).setIndent(stringBuilder3);
            object = ((ColumnDiff)object22).getMigrateTargetXml();
            if (((StringBuilder)object).length() <= 0) continue;
            stringBuilder2.append((CharSequence)object);
        }
        ArrayList arrayList2 = new ArrayList();
        List<ReportColumn> list2 = this.targetTable.getColumns();
        for (Object object22 : list2) {
            if (this.referenceTable.findColumn(((ReportColumn)object22).getColumn().getColumnName()) != null) continue;
            arrayList2.add(object22);
        }
        object3 = tableIdentifier.getTableName();
        object22 = tableIdentifier2.getTableName();
        bl = false;
        bl = ((String)object3).charAt(0) == '\"' || ((String)object22).charAt(0) == '\"' ? !((String)(object3 = SqlUtil.removeObjectQuotes((String)object3))).equals(object22 = SqlUtil.removeObjectQuotes((String)object22)) : !((String)object3).equalsIgnoreCase((String)object22);
        object = this.getMissingConstraints();
        List<TableConstraint> list3 = this.getModifiedConstraints();
        List<TableConstraint> list4 = this.getConstraintsToDelete();
        List<ForeignKeyDefinition> list5 = this.getMissingForeignKeys();
        List<ForeignKeyDefinition> list6 = this.getFKsToDelete();
        List<TriggerDefinition> list7 = this.referenceTable.getTriggers();
        List<TriggerDefinition> list8 = this.targetTable.getTriggers();
        boolean bl2 = false;
        TriggerListDiff triggerListDiff = null;
        if (CollectionUtil.isNonEmpty(list7) || CollectionUtil.isNonEmpty(list8)) {
            triggerListDiff = new TriggerListDiff(list7, list8);
            bl2 = triggerListDiff.hasChanges();
        }
        boolean bl3 = list5.isEmpty() && list6.isEmpty();
        boolean bl4 = object.isEmpty() && list3.isEmpty() && list4.isEmpty();
        List<String> list9 = this.referenceTable.getPrimaryKeyColumns();
        List<String> list10 = this.targetTable.getPrimaryKeyColumns();
        StringBuilder stringBuilder4 = this.getIndexDiff();
        StringBuilder stringBuilder5 = this.getGrantDiff();
        boolean bl5 = stringBuilder5 != null && stringBuilder5.length() > 0;
        boolean bl6 = stringBuilder4 != null && stringBuilder4.length() > 0;
        String string = this.referenceTable.getTable().getSourceOptions().getTypeModifier();
        String string2 = this.targetTable.getTable().getSourceOptions().getTypeModifier();
        boolean bl7 = StringUtil.equalStringOrEmpty(string, string2, false);
        String string3 = this.referenceTable.getTable().getTablespace();
        String string4 = this.targetTable.getTable().getTablespace();
        boolean bl8 = StringUtil.equalStringOrEmpty(string3, string4, false);
        boolean bl9 = this.optionsAreDifferent();
        if (stringBuilder2.length() == 0 && !bl && arrayList.isEmpty() && arrayList2.isEmpty() && list9.equals(list10) && bl4 && bl3 && !bl6 && !bl5 && !bl2 && !bl9 && bl7 && bl8) {
            return stringBuilder;
        }
        this.writer.appendOpenTag(stringBuilder, this.indent, TAG_MODIFY_TABLE, "name", SqlUtil.removeObjectQuotes(tableIdentifier2.getTableName()));
        stringBuilder.append('\n');
        this.targetTable.appendTableNameXml(stringBuilder, stringBuilder3);
        stringBuilder.append('\n');
        if (bl) {
            this.writer.appendOpenTag(stringBuilder, stringBuilder3, TAG_RENAME_TABLE);
            stringBuilder.append('\n');
            stringBuilder3.append("  ");
            this.writer.appendTag(stringBuilder, stringBuilder3, "table-name", SqlUtil.removeObjectQuotes(this.referenceTable.getTable().getTableName()));
            StringUtil.removeFromEnd(stringBuilder3, 2);
            this.writer.appendCloseTag(stringBuilder, stringBuilder3, TAG_RENAME_TABLE);
        }
        TableDiff.appendAddColumns(this.writer, stringBuilder, arrayList, this.indent);
        TableDiff.appendRemoveColumns(this.writer, stringBuilder, arrayList2, this.indent);
        String string5 = null;
        String[] stringArray = new String[]{"name"};
        String[] stringArray2 = new String[1];
        List<String> list11 = null;
        if (list9.isEmpty() && list10.size() > 0) {
            stringArray2[0] = this.targetTable.getPrimaryKeyName();
            string5 = TAG_REMOVE_PK;
            list11 = this.targetTable.getPrimaryKeyColumns();
        } else if (list9.size() > 0 && list10.isEmpty()) {
            stringArray2[0] = this.referenceTable.getPrimaryKeyName();
            string5 = TAG_ADD_PK;
            list11 = this.referenceTable.getPrimaryKeyColumns();
        } else if (!list9.equals(list10)) {
            stringArray2[0] = this.targetTable.getPrimaryKeyName();
            string5 = TAG_MODIFY_PK;
            list11 = this.referenceTable.getPrimaryKeyColumns();
        }
        if (CollectionUtil.isNonEmpty(list11)) {
            this.writer.appendOpenTag(stringBuilder, stringBuilder3, string5, stringArray, stringArray2);
            stringBuilder.append('\n');
            stringBuilder3.append("  ");
            for (String string6 : list11) {
                this.writer.appendTag(stringBuilder, stringBuilder3, "column-name", SqlUtil.removeObjectQuotes(string6));
            }
            StringUtil.removeFromEnd(stringBuilder3, 2);
            this.writer.appendCloseTag(stringBuilder, stringBuilder3, string5);
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        if (!bl4) {
            this.writer.appendOpenTag(stringBuilder, stringBuilder3, "table-constraints");
            stringBuilder.append('\n');
            StringBuilder stringBuilder6 = new StringBuilder(stringBuilder3).append("  ");
            this.writeConstraints(list4, stringBuilder, "drop-constraint", stringBuilder6);
            this.writeConstraints((List<TableConstraint>)object, stringBuilder, "add-constraint", stringBuilder6);
            this.writeConstraints(list3, stringBuilder, "modify-constraint", stringBuilder6);
            this.writer.appendCloseTag(stringBuilder, stringBuilder3, "table-constraints");
        }
        if (!bl3) {
            this.writeFKs(list6, stringBuilder, "drop-foreign-keys", stringBuilder3);
            this.writeFKs(list5, stringBuilder, "add-foreign-keys", stringBuilder3);
        }
        if (!bl7) {
            this.writer.appendTag(stringBuilder, stringBuilder3, "table-type", this.referenceTable.getTable().getSourceOptions().getTypeModifier());
        }
        if (!bl8) {
            this.writer.appendTag(stringBuilder, stringBuilder3, "tablespace", this.referenceTable.getTable().getTablespace());
        }
        if (bl6) {
            stringBuilder.append((CharSequence)stringBuilder4);
        }
        if (bl2 && triggerListDiff != null) {
            triggerListDiff.writeXml(stringBuilder3, stringBuilder);
        }
        if (bl5) {
            stringBuilder.append((CharSequence)stringBuilder5);
        }
        this.writeOptionsDiff(stringBuilder, stringBuilder3);
        this.writer.appendCloseTag(stringBuilder, this.indent, TAG_MODIFY_TABLE);
        return stringBuilder;
    }

    private void writeOptionsDiff(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        List<ObjectOption> list = this.referenceTable.getDbmsOptions();
        List<ObjectOption> list2 = this.targetTable.getDbmsOptions();
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        boolean bl = true;
        boolean bl2 = false;
        for (ObjectOption objectOption : list) {
            if (list2.contains(objectOption)) continue;
            if (bl) {
                this.writer.appendOpenTag(stringBuilder, stringBuilder2, "add-options");
                stringBuilder.append('\n');
                bl = false;
            }
            bl2 = true;
            stringBuilder.append((CharSequence)objectOption.getXml(stringBuilder3));
        }
        if (bl2) {
            this.writer.appendCloseTag(stringBuilder, stringBuilder2, "add-options");
        }
        bl = true;
        bl2 = false;
        for (ObjectOption objectOption : list2) {
            if (list.contains(objectOption)) continue;
            if (bl) {
                this.writer.appendOpenTag(stringBuilder, stringBuilder2, "remove-options");
                stringBuilder.append('\n');
                bl = false;
            }
            bl2 = true;
            stringBuilder.append((CharSequence)objectOption.getXml(stringBuilder3));
        }
        if (bl2) {
            this.writer.appendCloseTag(stringBuilder, stringBuilder2, "remove-options");
        }
    }

    private boolean optionsAreDifferent() {
        List<ObjectOption> list;
        List<ObjectOption> list2 = this.referenceTable.getDbmsOptions();
        return !list2.equals(list = this.targetTable.getDbmsOptions());
    }

    private ForeignKeyDefinition findFKByDefinition(Collection<ForeignKeyDefinition> collection, ForeignKeyDefinition foreignKeyDefinition) {
        for (ForeignKeyDefinition foreignKeyDefinition2 : collection) {
            if (!foreignKeyDefinition2.isDefinitionEqual(foreignKeyDefinition)) continue;
            return foreignKeyDefinition2;
        }
        return null;
    }

    private void adjustRuleCheck(Collection<ForeignKeyDefinition> collection) {
        for (ForeignKeyDefinition foreignKeyDefinition : collection) {
            foreignKeyDefinition.setCompareFKRules(false);
        }
    }

    private List<ForeignKeyDefinition> getMissingForeignKeys() {
        if (!this.diff.getIncludeForeignKeys()) {
            Collections.emptyList();
        }
        Collection<ForeignKeyDefinition> collection = this.referenceTable.getForeignKeys().values();
        Collection<ForeignKeyDefinition> collection2 = this.targetTable.getForeignKeys().values();
        this.adjustRuleCheck(collection);
        this.adjustRuleCheck(collection2);
        ArrayList<ForeignKeyDefinition> arrayList = new ArrayList<ForeignKeyDefinition>();
        for (ForeignKeyDefinition foreignKeyDefinition : collection) {
            ForeignKeyDefinition foreignKeyDefinition2 = this.findFKByDefinition(collection2, foreignKeyDefinition);
            if (foreignKeyDefinition2 != null) continue;
            arrayList.add(foreignKeyDefinition);
        }
        return arrayList;
    }

    private List<ForeignKeyDefinition> getFKsToDelete() {
        if (!this.diff.getIncludeForeignKeys()) {
            Collections.emptyList();
        }
        Collection<ForeignKeyDefinition> collection = this.referenceTable.getForeignKeys().values();
        Collection<ForeignKeyDefinition> collection2 = this.targetTable.getForeignKeys().values();
        ArrayList<ForeignKeyDefinition> arrayList = new ArrayList<ForeignKeyDefinition>();
        for (ForeignKeyDefinition foreignKeyDefinition : collection2) {
            ForeignKeyDefinition foreignKeyDefinition2 = this.findFKByDefinition(collection, foreignKeyDefinition);
            if (foreignKeyDefinition2 != null) continue;
            arrayList.add(foreignKeyDefinition);
        }
        return arrayList;
    }

    private void writeFKs(List<ForeignKeyDefinition> list, StringBuilder stringBuilder, String string, StringBuilder stringBuilder2) {
        if (list.isEmpty()) {
            return;
        }
        this.writer.appendOpenTag(stringBuilder, stringBuilder2, string);
        stringBuilder.append('\n');
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        StringBuilder stringBuilder4 = new StringBuilder(stringBuilder3);
        stringBuilder4.append("  ");
        for (ForeignKeyDefinition foreignKeyDefinition : list) {
            if (foreignKeyDefinition == null) continue;
            StringBuilder stringBuilder5 = foreignKeyDefinition.getInnerXml(stringBuilder4);
            this.writer.appendOpenTag(stringBuilder, stringBuilder3, "foreign-key");
            stringBuilder.append('\n');
            stringBuilder.append((CharSequence)stringBuilder5);
            this.writer.appendCloseTag(stringBuilder, stringBuilder3, "foreign-key");
        }
        this.writer.appendCloseTag(stringBuilder, stringBuilder2, string);
    }

    private void writeConstraints(List<TableConstraint> list, StringBuilder stringBuilder, String string, StringBuilder stringBuilder2) {
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        this.writer.appendOpenTag(stringBuilder, stringBuilder2, string);
        stringBuilder.append('\n');
        for (TableConstraint tableConstraint : list) {
            if (tableConstraint == null) continue;
            ReportTable.writeConstraint(tableConstraint, this.writer, stringBuilder, stringBuilder3);
        }
        this.writer.appendCloseTag(stringBuilder, stringBuilder2, string);
    }

    private List<TableConstraint> getConstraintsToDelete() {
        List<TableConstraint> list = this.targetTable.getTableConstraints();
        List<TableConstraint> list2 = this.referenceTable.getTableConstraints();
        return this.processDeltas(list, list2);
    }

    private List<TableConstraint> getMissingConstraints() {
        List<TableConstraint> list = this.targetTable.getTableConstraints();
        List<TableConstraint> list2 = this.referenceTable.getTableConstraints();
        return this.processDeltas(list2, list);
    }

    private List<TableConstraint> processDeltas(List<TableConstraint> list, List<TableConstraint> list2) {
        if (list == null) {
            return Collections.emptyList();
        }
        List<TableConstraint> list3 = CollectionUtil.arrayList();
        for (TableConstraint tableConstraint : list) {
            if (tableConstraint == null) continue;
            if (this.checkConstraintNames) {
                if (this.findByName(list2, tableConstraint)) continue;
                list3.add(tableConstraint);
                continue;
            }
            if (this.findByExpression(list2, tableConstraint)) continue;
            list3.add(tableConstraint);
        }
        return list3;
    }

    private boolean findByExpression(List<TableConstraint> list, TableConstraint tableConstraint) {
        if (tableConstraint == null) {
            return false;
        }
        if (list == null) {
            return false;
        }
        for (TableConstraint tableConstraint2 : list) {
            if (!tableConstraint2.expressionIsEqual(tableConstraint)) continue;
            return true;
        }
        return false;
    }

    private boolean findByName(List<TableConstraint> list, TableConstraint tableConstraint) {
        if (tableConstraint == null) {
            return false;
        }
        if (list == null) {
            return false;
        }
        for (TableConstraint tableConstraint2 : list) {
            if (!StringUtil.equalStringIgnoreCase(tableConstraint2.getConstraintName(), tableConstraint.getConstraintName())) continue;
            return true;
        }
        return false;
    }

    private List<TableConstraint> getModifiedConstraints() {
        if (!this.checkConstraintNames) {
            return Collections.emptyList();
        }
        List<TableConstraint> list = this.targetTable.getTableConstraints();
        if (list == null) {
            return Collections.emptyList();
        }
        List<TableConstraint> list2 = this.referenceTable.getTableConstraints();
        if (list2 == null) {
            return Collections.emptyList();
        }
        List<TableConstraint> list3 = CollectionUtil.arrayList();
        for (TableConstraint tableConstraint : list2) {
            if (!this.isModified(list, tableConstraint)) continue;
            list3.add(tableConstraint);
        }
        return list3;
    }

    private boolean isModified(List<TableConstraint> list, TableConstraint tableConstraint) {
        if (tableConstraint == null) {
            return false;
        }
        if (list == null) {
            return false;
        }
        for (TableConstraint tableConstraint2 : list) {
            if (!StringUtil.equalStringIgnoreCase(tableConstraint.getConstraintName(), tableConstraint2.getConstraintName()) || tableConstraint.expressionIsEqual(tableConstraint2)) continue;
            return true;
        }
        return false;
    }

    public static void appendAddColumns(TagWriter tagWriter, StringBuilder stringBuilder, List<ReportColumn> list, StringBuilder stringBuilder2) {
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        tagWriter.appendOpenTag(stringBuilder, stringBuilder3, TAG_ADD_COLUMN);
        stringBuilder.append('\n');
        stringBuilder3.append("  ");
        for (ReportColumn reportColumn : list) {
            reportColumn.appendXml(stringBuilder, stringBuilder3, true);
        }
        StringUtil.removeFromEnd(stringBuilder3, 2);
        tagWriter.appendCloseTag(stringBuilder, stringBuilder3, TAG_ADD_COLUMN);
    }

    public static void appendRemoveColumns(TagWriter tagWriter, StringBuilder stringBuilder, List<ReportColumn> list, StringBuilder stringBuilder2) {
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
        stringBuilder3.append("  ");
        for (ReportColumn reportColumn : list) {
            tagWriter.appendEmptyTag(stringBuilder, stringBuilder3, TAG_REMOVE_COLUMN, "name", SqlUtil.removeObjectQuotes(reportColumn.getColumn().getColumnName()));
            stringBuilder.append('\n');
        }
    }

    private StringBuilder getGrantDiff() {
        if (!this.diff.getIncludeTableGrants()) {
            return null;
        }
        ReportTableGrants reportTableGrants = this.referenceTable.getGrants();
        ReportTableGrants reportTableGrants2 = this.targetTable.getGrants();
        if (reportTableGrants == null && reportTableGrants2 == null) {
            return null;
        }
        TableGrantDiff tableGrantDiff = new TableGrantDiff(reportTableGrants, reportTableGrants2);
        StringBuilder stringBuilder = tableGrantDiff.getMigrateTargetXml(this.writer, this.indent);
        return stringBuilder;
    }

    private StringBuilder getIndexDiff() {
        if (!this.diff.getIncludeIndex()) {
            return null;
        }
        Collection<IndexDefinition> collection = this.referenceTable.getIndexList();
        Collection<IndexDefinition> collection2 = this.targetTable.getIndexList();
        if (collection == null && collection2 == null) {
            return null;
        }
        IndexDiff indexDiff = new IndexDiff(collection, collection2);
        indexDiff.setIndent(this.indent);
        StringBuilder stringBuilder = indexDiff.getMigrateTargetXml();
        return stringBuilder;
    }

    public void setIndent(String string) {
        this.indent = string == null ? null : new StringBuilder(string);
    }

    public void setIndent(StringBuilder stringBuilder) {
        this.indent = stringBuilder;
    }
}

