/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.exporter;

public enum ExportType {
    SQL_INSERT("SQL"),
    SQL_UPDATE("SQL Update"),
    SQL_DELETE_INSERT("SQL Delete/Insert"),
    SQL_DELETE("SQL Delete"),
    SQL_MERGE("SQL MERGE"),
    SQL_INSERT_IGNORE("SQL Insert/Ignore"),
    HTML("HTML"),
    TEXT("Text"),
    XML("XML"),
    ODS("OpenDocument Spreadsheet"),
    XLS("XLS"),
    XLSM("XLSM"),
    XLSX("XLSX"),
    JSON("JSON");

    private final String display;

    private ExportType(String string2) {
        this.display = string2;
    }

    public String toString() {
        return this.display;
    }

    public static ExportType getExportType(String string) {
        if (string.equalsIgnoreCase("txt")) {
            return TEXT;
        }
        if (string.equalsIgnoreCase("sql")) {
            return SQL_INSERT;
        }
        if (string.equalsIgnoreCase("sqlinsert")) {
            return SQL_INSERT;
        }
        if (string.equalsIgnoreCase("sqlinsertignore")) {
            return SQL_INSERT_IGNORE;
        }
        if (string.equalsIgnoreCase("sqlupdate")) {
            return SQL_UPDATE;
        }
        if (string.equalsIgnoreCase("sqldeleteinsert")) {
            return SQL_DELETE_INSERT;
        }
        if (string.equalsIgnoreCase("sqldelete")) {
            return SQL_DELETE;
        }
        if (string.equalsIgnoreCase("sqlmerge")) {
            return SQL_MERGE;
        }
        if (string.equalsIgnoreCase("merge")) {
            return SQL_MERGE;
        }
        try {
            return ExportType.valueOf(string.toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ExportType getTypeFromCode(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("1")) {
            return SQL_INSERT;
        }
        if (string.equals("2")) {
            return TEXT;
        }
        if (string.equals("3")) {
            return XML;
        }
        if (string.equals("4")) {
            return HTML;
        }
        if (string.equals("5")) {
            return ODS;
        }
        if (string.equals("6")) {
            return XLS;
        }
        if (string.equals("7")) {
            return XLSM;
        }
        if (string.equals("8")) {
            return XLSX;
        }
        if (string.equals("9")) {
            return JSON;
        }
        return null;
    }

    public boolean isSqlType() {
        return this == SQL_INSERT || this == SQL_UPDATE || this == SQL_DELETE_INSERT || this == SQL_DELETE || this == SQL_INSERT_IGNORE;
    }

    public String getDefaultFileExtension() {
        switch (this) {
            case SQL_INSERT: 
            case SQL_UPDATE: 
            case SQL_DELETE_INSERT: 
            case SQL_DELETE: 
            case SQL_INSERT_IGNORE: {
                return ".sql";
            }
            case TEXT: {
                return ".txt";
            }
            case XML: {
                return ".xml";
            }
            case HTML: {
                return ".html";
            }
            case ODS: {
                return ".ods";
            }
            case XLSX: {
                return ".xlsx";
            }
            case XLSM: {
                return ".xml";
            }
            case XLS: {
                return ".xls";
            }
            case JSON: {
                return ".json";
            }
        }
        return null;
    }

    public String getCode() {
        switch (this) {
            case SQL_INSERT: 
            case SQL_UPDATE: 
            case SQL_DELETE_INSERT: 
            case SQL_DELETE: 
            case SQL_INSERT_IGNORE: {
                return "1";
            }
            case TEXT: {
                return "2";
            }
            case XML: {
                return "3";
            }
            case HTML: {
                return "4";
            }
            case ODS: {
                return "5";
            }
            case XLS: {
                return "6";
            }
            case XLSM: {
                return "7";
            }
            case XLSX: {
                return "8";
            }
            case JSON: {
                return "9";
            }
        }
        return null;
    }
}

