/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.greenplum;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.ObjectSourceOptions;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.greenplum.GreenplumTableSourceBuilder;
import workbench.db.greenplum.GreenplumUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CharacterRange;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbStringTokenizer;

public class GreenplumExternalTableReader {
    public static final String EXT_TABLE_TYPE = "EXTERNAL TABLE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableIdentifier> getExternalTables(WbConnection wbConnection, String string, String string2) {
        if (wbConnection == null) {
            return Collections.emptyList();
        }
        ArrayList<TableIdentifier> arrayList = new ArrayList<TableIdentifier>();
        CallerInfo callerInfo = new CallerInfo(){};
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append("select s.nspname as schemaname, \n       c.relname as tablename \nfrom pg_exttable t\n  join pg_class c on c.oid = t.reloid\n  join pg_namespace s on s.oid = c.relnamespace");
        boolean bl = false;
        if (StringUtil.isNonBlank(string)) {
            stringBuilder.append("\nWHERE ");
            SqlUtil.appendExpression(stringBuilder, "s.nspname", string, wbConnection);
            bl = true;
        }
        if (StringUtil.isNonBlank(string2)) {
            if (bl) {
                stringBuilder.append("\n  AND ");
            } else {
                stringBuilder.append("\nWHERE ");
            }
            SqlUtil.appendExpression(stringBuilder, "c.relname", string2, wbConnection);
        }
        if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logDebug(callerInfo, "Retrieving external tables using:\n" + stringBuilder);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        try {
            savepoint = wbConnection.setSavepoint();
            statement = wbConnection.getSqlConnection().createStatement();
            resultSet = statement.executeQuery(stringBuilder.toString());
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                TableIdentifier tableIdentifier = new TableIdentifier(string3, string4);
                tableIdentifier.setType(EXT_TABLE_TYPE);
                arrayList.add(tableIdentifier);
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logWarning(callerInfo, "Error retrieving external tables using:\n" + stringBuilder, exception);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTableOptions(WbConnection wbConnection, TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        CallerInfo callerInfo = new CallerInfo(){};
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        String string = null;
        string = JdbcUtils.hasMinimumServerVersion(wbConnection, "5.0") ? "select t.urilocation, t.execlocation, t.fmttype, t.fmtopts, t.command, \n       t.rejectlimit, t.rejectlimittype, t.encoding, t.writable, \n       p.attrnums \nfrom pg_exttable t\n  join pg_class c on c.oid = t.reloid\n  join pg_namespace s on s.oid = c.relnamespace\n  left join pg_catalog.gp_distribution_policy p on p.localoid = c.oid \n where c.relname = ? \n   and s.nspname = ?" : "select t.location as urilocation, null::text[] as execlocation, t.fmttype, t.fmtopts, t.command, \n       t.rejectlimit, t.rejectlimittype, t.encoding, t.writable \n       p.attrnums \nfrom pg_exttable t \n  join pg_class c on c.oid = t.reloid\n  join pg_namespace s on s.oid = c.relnamespace  left join pg_catalog.gp_distribution_policy p on p.localoid = c.oid \n where c.relname = ? \n   and s.nspname = ?";
        if (Settings.getInstance().getDebugMetadataSql()) {
            LogMgr.logDebug(callerInfo, "Retrieving external tables definition using :\n" + SqlUtil.replaceParameters(string, tableIdentifier.getTableName(), tableIdentifier.getSchema()));
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Savepoint savepoint = null;
        String string2 = "";
        try {
            savepoint = wbConnection.setSavepoint();
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawTableName());
            preparedStatement.setString(2, tableIdentifier.getRawSchema());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string3;
                String[] stringArray = GreenplumUtil.parseStringArray(resultSet.getString("urilocation"));
                String[] stringArray2 = GreenplumUtil.parseStringArray(resultSet.getString("execlocation"));
                String string4 = resultSet.getString("fmttype");
                String string5 = resultSet.getString("fmtopts");
                String string6 = resultSet.getString("command");
                int n = resultSet.getInt("rejectlimit");
                if (resultSet.wasNull()) {
                    n = -1;
                }
                String string7 = resultSet.getString("rejectlimittype");
                String string8 = resultSet.getString("encoding");
                boolean bl = resultSet.getBoolean("writable");
                String string9 = this.arrayToString(stringArray, true);
                String string10 = resultSet.getString("attrnums");
                int[] nArray = GreenplumUtil.parseIntArray(string10);
                if (StringUtil.isNonBlank(string6) || this.hasHTTPLocations(stringArray)) {
                    tableIdentifier.setType("EXTERNAL WEB TABLE");
                }
                if (!string9.isEmpty()) {
                    string2 = string2 + "LOCATION (\n  " + string9 + "\n)";
                }
                if (StringUtil.isNonBlank(string6)) {
                    string2 = string2 + "EXECUTE '" + string6 + "' " + this.decodeExeclocations(stringArray2);
                }
                if (string4 != null) {
                    string2 = string2 + "\nFORMAT '";
                    switch (string4) {
                        case "t": {
                            string2 = string2 + "TEXT";
                            break;
                        }
                        case "c": {
                            string2 = string2 + "CSV";
                            break;
                        }
                        case "a": {
                            string2 = string2 + "AVRO";
                            break;
                        }
                        case "p": {
                            string2 = string2 + "PARQUET";
                            break;
                        }
                        case "b": {
                            string2 = string2 + "CUSTOM";
                            string5 = this.parseCustomOptions(string5);
                            break;
                        }
                    }
                    string2 = string2 + "'";
                    if (StringUtil.isNonBlank(string5)) {
                        string2 = string2 + " (\n  " + string5 + "\n)";
                    }
                }
                if (bl) {
                    objectSourceOptions.setTypeModifier("WRITABLE");
                }
                if (StringUtil.isNonBlank(string8)) {
                    string2 = StringUtil.isNumber(string8) ? string2 + "\nENCODING " + string8 : string2 + "\nENCODING '" + string8 + "'";
                }
                if (n > 0) {
                    string2 = string2 + "\nSEGMENT REJECT LIMIT " + n;
                }
                if ("r".equals(string7)) {
                    string2 = string2 + " ROWS";
                }
                if (bl && StringUtil.isNonBlank(string3 = GreenplumTableSourceBuilder.getDistribution(nArray, list))) {
                    string2 = string2 + "\n" + string3;
                }
            }
            wbConnection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                wbConnection.rollback(savepoint);
                LogMgr.logWarning(callerInfo, "Error retrieving external table definition using:\n" + SqlUtil.replaceParameters(string, tableIdentifier.getTableName(), tableIdentifier.getSchema()), exception);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        objectSourceOptions.appendTableOptionSQL(string2);
    }

    private boolean hasHTTPLocations(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        int n = 0;
        for (String string : stringArray) {
            if (string == null || !string.toLowerCase().startsWith("http")) continue;
            ++n;
        }
        return n == stringArray.length;
    }

    private String parseCustomOptions(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        WbStringTokenizer wbStringTokenizer = new WbStringTokenizer(string, " ", true, "'", true);
        int n = 0;
        while (wbStringTokenizer.hasMoreTokens()) {
            String string3 = wbStringTokenizer.nextToken();
            if (string3 == null) continue;
            if ((n + 1) % 2 == 0) {
                String string4 = StringUtil.escapeText(string3, CharacterRange.RANGE_CONTROL);
                if (!string3.equals(string4)) {
                    string4 = "E" + string4;
                }
                string2 = string2 + '=';
                string2 = string2 + string4;
            } else {
                if (n > 0) {
                    string2 = string2 + ",\n  ";
                }
                string2 = string2 + string3;
            }
            ++n;
        }
        return string2;
    }

    private String decodeExeclocations(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        String string = "";
        block8: for (String string2 : stringArray) {
            if (StringUtil.isBlank(string2)) continue;
            switch (string2) {
                case "ALL_SEGMENTS": {
                    string = string + "ON ALL ";
                    continue block8;
                }
                case "MASTER_ONLY": {
                    string = string + "ON MASTER ";
                    continue block8;
                }
                default: {
                    string = string + string2;
                }
            }
        }
        return string;
    }

    private String arrayToString(String[] stringArray, boolean bl) {
        String string = "";
        if (stringArray == null) {
            return "";
        }
        int n = 0;
        for (String string2 : stringArray) {
            if (StringUtil.isBlank(string2)) continue;
            if (n > 0) {
                string = string + ",\n  ";
            }
            if (bl) {
                string = string + '\'';
            }
            string = string + string2;
            if (bl) {
                string = string + '\'';
            }
            ++n;
        }
        return string;
    }
}

