/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.greenplum;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DependencyNode;
import workbench.db.DropType;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.ObjectSourceOptions;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.greenplum.GreenplumExternalTableReader;
import workbench.db.greenplum.GreenplumUtil;
import workbench.db.postgres.PostgresRuleReader;
import workbench.db.postgres.PostgresTableSourceBuilder;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class GreenplumTableSourceBuilder
extends PostgresTableSourceBuilder {
    public GreenplumTableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public CharSequence getCreateTable(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2, List<DependencyNode> list3, DropType dropType, boolean bl, boolean bl2, boolean bl3) {
        return super.baseCreateTable(tableIdentifier, list, list2, list3, dropType, bl, bl2, bl3);
    }

    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        if (objectSourceOptions.isInitialized()) {
            return;
        }
        PostgresRuleReader postgresRuleReader = new PostgresRuleReader();
        CharSequence charSequence = postgresRuleReader.getTableRuleSource(this.dbConnection, tableIdentifier);
        if (charSequence != null) {
            objectSourceOptions.setAdditionalSql(charSequence.toString());
        }
        if (tableIdentifier.getType().equals("EXTERNAL TABLE")) {
            GreenplumExternalTableReader greenplumExternalTableReader = new GreenplumExternalTableReader();
            greenplumExternalTableReader.readTableOptions(this.dbConnection, tableIdentifier, list);
        } else {
            this.retrieveTableOptions(tableIdentifier, list);
        }
        objectSourceOptions.setInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        StringBuilder stringBuilder = new StringBuilder();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        CallerInfo callerInfo = new CallerInfo(){};
        String string = "select ct.relstorage, \n       ct.relkind, \n       array_to_string(ct.reloptions, ', ') as options, \n       own.rolname as owner, \n       p.attrnums, \n       (exists (select * from pg_partition pt where pt.parrelid = ct.oid)) as is_partitioned \nfrom pg_catalog.pg_class ct \n  join pg_catalog.pg_namespace cns on ct.relnamespace = cns.oid \n   join pg_catalog.pg_roles own on ct.relowner = own.oid \n   left join pg_catalog.gp_distribution_policy p on p.localoid = ct.oid \n where cns.nspname = ? \n   and ct.relname = ?";
        boolean bl = false;
        Savepoint savepoint = null;
        try {
            savepoint = this.dbConnection.setSavepoint();
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getRawSchema());
            preparedStatement.setString(2, tableIdentifier.getRawTableName());
            if (Settings.getInstance().getDebugMetadataSql()) {
                LogMgr.logDebug(callerInfo, "Retrieving table options using:\n" + SqlUtil.replaceParameters(string, tableIdentifier.getSchema(), tableIdentifier.getTableName()));
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                String string2 = resultSet.getString("relstorage");
                String string3 = resultSet.getString("relkind");
                String string4 = resultSet.getString("options");
                String string5 = resultSet.getString("owner");
                bl = resultSet.getBoolean("is_partitioned");
                String string6 = resultSet.getString("attrnums");
                int[] nArray = GreenplumUtil.parseIntArray(string6);
                tableIdentifier.setOwner(string5);
                if ("u".equals(string2)) {
                    objectSourceOptions.setTypeModifier("TEMPORARY");
                }
                if (StringUtil.isNonEmpty(string4)) {
                    this.setConfigSettings(string4, objectSourceOptions);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\n');
                    }
                    stringBuilder.append("WITH (");
                    stringBuilder.append(string4);
                    stringBuilder.append(")");
                }
                if (!tableIdentifier.getType().startsWith("EXTERNAL")) {
                    stringBuilder.append(GreenplumTableSourceBuilder.getDistribution(nArray, list));
                }
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logError(callerInfo, "Error retrieving table options using:\n" + SqlUtil.replaceParameters(string, tableIdentifier.getSchema(), tableIdentifier.getTableName()), sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        objectSourceOptions.appendTableOptionSQL(stringBuilder.toString());
        if (bl) {
            tableIdentifier.setIsPartitioned(true);
            this.handlePartitions(tableIdentifier);
        }
    }

    public static String getDistribution(int[] nArray, List<ColumnIdentifier> list) {
        if (nArray == null) {
            return "";
        }
        if (nArray.length == 0) {
            return "DISTRIBUTED RANDOMLY";
        }
        String string = "DISTRIBUTED BY (";
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n <= 0) continue;
            String string2 = list.get(n - 1).getColumnName();
            if (i > 0) {
                string = string + ", ";
            }
            string = string + string2;
        }
        return string + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handlePartitions(TableIdentifier tableIdentifier) {
        String string = null;
        String string2 = "select pg_get_partition_def('" + tableIdentifier.getFullyQualifiedName(this.dbConnection) + "'::regclass, true, false)";
        Savepoint savepoint = null;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            savepoint = this.dbConnection.setSavepoint();
            statement = this.dbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
            this.dbConnection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                this.dbConnection.rollback(savepoint);
                LogMgr.logError(new CallerInfo(){}, "Error retrieving table options using: \n" + string2, sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
        String string3 = objectSourceOptions.getTableOption();
        string3 = string3 == null ? string : string3 + "\n" + string;
        objectSourceOptions.setTableOption(string3);
    }

    @Override
    public String getAdditionalTableInfo(TableIdentifier tableIdentifier, List<ColumnIdentifier> list, List<IndexDefinition> list2) {
        String string = tableIdentifier.getSchemaToUse(this.dbConnection);
        CharSequence charSequence = this.getEnumInformation(list, string);
        CharSequence charSequence2 = this.getDomainInformation(list, string);
        CharSequence charSequence3 = this.getColumnSequenceInformation(tableIdentifier, list);
        CharSequence charSequence4 = null;
        if (!tableIdentifier.isPartitioned()) {
            charSequence4 = this.getChildTables(tableIdentifier);
        }
        String string2 = this.getOwnerSql(tableIdentifier);
        if (StringUtil.allEmpty(charSequence, charSequence2, charSequence3, charSequence4, string2)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        if (charSequence != null) {
            stringBuilder.append(charSequence);
        }
        if (charSequence2 != null) {
            stringBuilder.append(charSequence2);
        }
        if (charSequence3 != null) {
            stringBuilder.append(charSequence3);
        }
        if (charSequence4 != null) {
            stringBuilder.append(charSequence4);
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

