/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.h2database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Set;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class H2ColumnEnhancer
implements ColumnDefinitionEnhancer {
    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        this.updateComputedColumns(tableDefinition, wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComputedColumns(TableDefinition tableDefinition, WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = tableDefinition.getTable().getTableName();
        String string2 = tableDefinition.getTable().getSchema();
        String string3 = "select column_name \nfrom information_schema.columns \nwhere table_name = ? \nand table_schema = ? \nand is_computed = true \n";
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        LogMgr.logMetadataSql(new CallerInfo(){}, "computed columns", string3, string, string2);
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                set.add(string4);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "computed columns", string3, string, string2);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
            String string5;
            if (!set.contains(columnIdentifier.getColumnName()) || !StringUtil.isNonBlank(string5 = columnIdentifier.getDefaultValue())) continue;
            if (!string5.startsWith("AS")) {
                string5 = "AS " + string5;
            }
            columnIdentifier.setDefaultValue(null);
            columnIdentifier.setComputedColumnExpression(string5);
        }
    }
}

