/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.h2database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DropType;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class H2TableSourceBuilder
extends TableSourceBuilder {
    public H2TableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public String getTableSource(TableIdentifier tableIdentifier, DropType dropType, boolean bl, boolean bl2) throws SQLException {
        String string;
        if ("TABLE LINK".equals(tableIdentifier.getType()) && (string = this.getLinkedTableSource(tableIdentifier, dropType != DropType.none)) != null) {
            return string;
        }
        return super.getTableSource(tableIdentifier, dropType, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLinkedTableSource(TableIdentifier tableIdentifier, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = "SELECT sql FROM information_schema.tables  WHERE table_schema = ?    AND table_name = ?    AND table_type = 'TABLE LINK'";
        StringBuilder stringBuilder = new StringBuilder(100);
        LogMgr.logMetadataSql(new CallerInfo(){}, "linked table source", string, new Object[0]);
        if (bl) {
            stringBuilder.append("DROP TABLE ");
            stringBuilder.append(tableIdentifier.getTableExpression(this.dbConnection));
            stringBuilder.append(";\n\n");
        }
        try {
            preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
            preparedStatement.setString(1, tableIdentifier.getSchema());
            preparedStatement.setString(2, tableIdentifier.getTableName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (StringUtil.isNonEmpty(string2)) {
                    string2 = string2.replace("/*--hide--*/", "");
                }
                stringBuilder.append(string2.trim());
                stringBuilder.append(";\n");
            }
        }
        catch (SQLException sQLException) {
            String string3;
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "linked table source", string, new Object[0]);
                string3 = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return string3;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            if (tableIdentifier.getSourceOptions().isInitialized()) {
                return;
            }
            preparedStatement = null;
            resultSet = null;
            String string = "select storage_type, \n       (select value from information_schema.settings where name = 'DEFAULT_TABLE_TYPE') as default_type \nfrom information_schema.tables \nwhere table_name = ? \nand table_schema = ?";
            boolean bl = Settings.getInstance().getBoolProperty("workbench.db.h2.table_type.show_always", false);
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
                preparedStatement.setString(1, tableIdentifier.getTableName());
                preparedStatement.setString(2, tableIdentifier.getSchema());
                LogMgr.logMetadataSql(new CallerInfo(){}, "table options", string, tableIdentifier.getTableName(), tableIdentifier.getSchema());
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                string3 = "0".equals(string3) ? "CACHED" : "MEMORY";
                if (!bl && string3.equals(string2)) break block5;
                tableIdentifier.getSourceOptions().setTypeModifier(string2);
            }
            catch (SQLException sQLException) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "table options", string, tableIdentifier.getTableName(), tableIdentifier.getSchema());
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        tableIdentifier.getSourceOptions().setInitialized();
    }
}

