/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hana;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import workbench.db.ColumnDefinitionEnhancer;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.StringUtil;

public class HanaColumnEnhancer
implements ColumnDefinitionEnhancer {
    @Override
    public void updateColumnDefinition(TableDefinition tableDefinition, WbConnection wbConnection) {
        if (wbConnection.getDbSettings().getBoolProperty("tabledefinition.usejdbc", false)) {
            this.updateComputedColumns(tableDefinition, wbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComputedColumns(TableDefinition tableDefinition, WbConnection wbConnection) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = tableDefinition.getTable().getRawTableName();
        String string2 = tableDefinition.getTable().getRawSchema();
        String string3 = "select column_name, \n       generation_type \nfrom sys.table_columns \nwhere table_name = ? \nand schema_name = ? \nand generation_type is not null";
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        try {
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                String object = resultSet.getString(2);
                if (!StringUtil.isNonEmpty(object)) continue;
                hashMap.put(string4, "GENERATED " + object);
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving computed columns", exception);
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
            String string4 = (String)hashMap.get(columnIdentifier.getColumnName());
            if (!StringUtil.isNonBlank(string4)) continue;
            columnIdentifier.setDefaultValue(null);
            columnIdentifier.setComputedColumnExpression(string4);
            columnIdentifier.setIsAutoincrement(true);
        }
    }
}

