/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.hsqldb;

import workbench.db.AbstractConstraintReader;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.TableDefinition;
import workbench.db.WbConnection;
import workbench.util.StringUtil;

public class HsqlConstraintReader
extends AbstractConstraintReader {
    private String sql = "select chk.constraint_name, chk.check_clause \nfrom information_schema.system_check_constraints chk  join  information_schema.system_table_constraints cons on chk.constraint_name = cons.constraint_name  \nwhere cons.constraint_type = 'CHECK' \nand cons.table_name = ?; \n";

    public HsqlConstraintReader(WbConnection wbConnection) {
        super(wbConnection.getDbId());
        if (JdbcUtils.hasMinimumServerVersion(wbConnection, "1.9")) {
            this.sql = this.sql.replace("system_check_constraints", "check_constraints");
            this.sql = this.sql.replace("system_table_constraints", "table_constraints");
        }
    }

    @Override
    public String getColumnConstraintSql() {
        return null;
    }

    @Override
    public String getTableConstraintSql() {
        return this.sql;
    }

    @Override
    public boolean isSystemConstraintName(String string) {
        if (StringUtil.isBlank(string)) {
            return false;
        }
        return string.startsWith("SYS_");
    }

    @Override
    protected boolean shouldIncludeTableConstraint(String string, String string2, TableDefinition tableDefinition) {
        if (string2 == null) {
            return false;
        }
        if (!string2.toUpperCase().endsWith("IS NOT NULL")) {
            return true;
        }
        int n = string2.indexOf(32);
        if (n < 0) {
            return true;
        }
        String string3 = string2.substring(0, n);
        int n2 = string3.lastIndexOf(46);
        if (n2 < 0) {
            return true;
        }
        ColumnIdentifier columnIdentifier = this.findColumn(tableDefinition, string3 = string3.substring(n2 + 1));
        return columnIdentifier == null || columnIdentifier.isNullable() || !this.isSystemConstraintName(string);
    }

    private ColumnIdentifier findColumn(TableDefinition tableDefinition, String string) {
        for (ColumnIdentifier columnIdentifier : tableDefinition.getColumns()) {
            if (!columnIdentifier.getColumnName().equalsIgnoreCase(string)) continue;
            return columnIdentifier;
        }
        return null;
    }
}

