/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListEnhancer;
import workbench.db.ObjectListExtender;
import workbench.db.WbConnection;
import workbench.db.ibm.DB2ObjectType;
import workbench.db.ibm.Db2DataTypeMapper;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class DB2TypeReader
implements ObjectListExtender,
ObjectListEnhancer {
    @Override
    public boolean isDerivedType() {
        return false;
    }

    @Override
    public void updateObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
    }

    @Override
    public boolean extendObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (!DbMetadata.typeIncluded("TYPE", stringArray)) {
            return false;
        }
        List<DB2ObjectType> list = this.getTypes(wbConnection, string2, string3);
        if (list.isEmpty()) {
            return false;
        }
        for (DB2ObjectType dB2ObjectType : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, null);
            dataStore.setValue(n, 3, (Object)dB2ObjectType.getSchema());
            dataStore.setValue(n, 0, (Object)dB2ObjectType.getObjectName());
            dataStore.setValue(n, 1, (Object)dB2ObjectType.getObjectType());
            dataStore.setValue(n, 4, (Object)dB2ObjectType.getComment());
            dataStore.getRow(n).setUserObject(dB2ObjectType);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DB2ObjectType> getTypes(WbConnection wbConnection, String string, String string2) {
        ArrayList<DB2ObjectType> arrayList = new ArrayList<DB2ObjectType>();
        String string3 = "select typeschema,  \n       typename,   \n       remarks,   \n       sourcename, \n       metatype, \n       length,  \n       array_length,  \n       scale   \nfrom syscat.datatypes  \nwhere ownertype = 'U' ";
        if (StringUtil.isNonBlank(string)) {
            string3 = string.indexOf(37) > -1 ? string3 + " AND typeschema LIKE '" + string + "' " : string3 + " AND typeschema = '" + string + "' ";
        }
        if (StringUtil.isNonBlank(string2)) {
            string3 = string2.indexOf(37) > -1 ? string3 + " AND typename LIKE '" + string2 + "' " : string3 + " AND typename = '" + string2 + "' ";
        }
        string3 = string3 + " ORDER BY typeschema, typename ";
        LogMgr.logMetadataSql(new CallerInfo(){}, "types", string3, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        Db2DataTypeMapper db2DataTypeMapper = new Db2DataTypeMapper();
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                String string4 = resultSet.getString("typeschema");
                String string5 = resultSet.getString("typename");
                String string6 = resultSet.getString("REMARKS");
                String string7 = resultSet.getString("METATYPE");
                String string8 = resultSet.getString("SOURCENAME");
                int n = resultSet.getInt("length");
                int n2 = resultSet.getInt("scale");
                int n3 = resultSet.getInt("array_length");
                DB2ObjectType dB2ObjectType = new DB2ObjectType(string4, string5);
                dB2ObjectType.setComment(string6);
                dB2ObjectType.setMetaType(string7);
                if (dB2ObjectType.getMetaType() != DB2ObjectType.MetaType.structured) {
                    int n4 = db2DataTypeMapper.getJDBCTypeName(string8);
                    dB2ObjectType.setBaseType(db2DataTypeMapper.getDisplayType(string8, n4, n, n2));
                    dB2ObjectType.setArrayLength(n3);
                }
                arrayList.add(dB2ObjectType);
            }
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "types", string3, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }

    @Override
    public List<String> supportedTypes() {
        return CollectionUtil.arrayList("TYPE");
    }

    @Override
    public boolean handlesType(String string) {
        return "TYPE".equalsIgnoreCase(string);
    }

    @Override
    public boolean handlesType(String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string : stringArray) {
            if (!this.handlesType(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataStore getObjectDetails(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject == null) {
            return null;
        }
        if (!this.handlesType(dbObject.getObjectType())) {
            return null;
        }
        DB2ObjectType dB2ObjectType = this.getObjectDefinition(wbConnection, dbObject);
        if (dB2ObjectType == null) {
            return null;
        }
        String[] stringArray = new String[]{"ATTRIBUTE", "DATA_TYPE"};
        int[] nArray = new int[]{12, 12};
        int[] nArray2 = new int[]{30, 30};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        List<ColumnIdentifier> list = dB2ObjectType.getAttributes();
        if (CollectionUtil.isNonEmpty(list)) {
            for (ColumnIdentifier columnIdentifier : list) {
                int n = dataStore.addRow();
                dataStore.setValue(n, 0, (Object)columnIdentifier.getColumnName());
                dataStore.setValue(n, 1, (Object)columnIdentifier.getDbmsType());
            }
        }
        return dataStore;
    }

    @Override
    public DB2ObjectType getObjectDefinition(WbConnection wbConnection, DbObject dbObject) {
        List<DB2ObjectType> list = this.getTypes(wbConnection, dbObject.getSchema(), dbObject.getObjectName());
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        DB2ObjectType dB2ObjectType = list.get(0);
        List<ColumnIdentifier> list2 = this.getAttributes(wbConnection, dB2ObjectType);
        dB2ObjectType.setAttributes(list2);
        return dB2ObjectType;
    }

    @Override
    public String getObjectSource(WbConnection wbConnection, DbObject dbObject) {
        DB2ObjectType dB2ObjectType = this.getObjectDefinition(wbConnection, dbObject);
        if (dB2ObjectType == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(50 + dB2ObjectType.getNumberOfAttributes() * 50);
        stringBuilder.append("CREATE TYPE ");
        stringBuilder.append(dB2ObjectType.getObjectName());
        DB2ObjectType.MetaType metaType = dB2ObjectType.getMetaType();
        switch (metaType) {
            case cursor: {
                stringBuilder.append(" AS CURSOR;");
                break;
            }
            case distinct: {
                stringBuilder.append(" AS ");
                stringBuilder.append(dB2ObjectType.getBaseType());
                if (!dB2ObjectType.getBaseType().endsWith("LOB")) {
                    stringBuilder.append(" WITH COMPARISONS");
                }
                stringBuilder.append(';');
                break;
            }
            case array: {
                stringBuilder.append(" AS ");
                stringBuilder.append(dB2ObjectType.getBaseType());
                stringBuilder.append(" ARRAY[");
                stringBuilder.append(dB2ObjectType.getArrayLength());
                stringBuilder.append("]");
                stringBuilder.append(';');
                break;
            }
            default: {
                if (metaType == DB2ObjectType.MetaType.row) {
                    stringBuilder.append(" AS ROW \n(\n");
                } else {
                    stringBuilder.append(" AS\n(\n");
                }
                List<ColumnIdentifier> list = dB2ObjectType.getAttributes();
                int n = ColumnIdentifier.getMaxNameLength(list);
                for (int i = 0; i < list.size(); ++i) {
                    stringBuilder.append("  ");
                    stringBuilder.append(StringUtil.padRight(list.get(i).getColumnName(), n + 2));
                    stringBuilder.append(list.get(i).getDbmsType());
                    if (i >= list.size() - 1) continue;
                    stringBuilder.append(",\n");
                }
                stringBuilder.append("\n);\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean hasColumns() {
        return true;
    }

    @Override
    public List<ColumnIdentifier> getColumns(WbConnection wbConnection, DbObject dbObject) {
        if (dbObject instanceof DB2ObjectType) {
            return this.getAttributes(wbConnection, (DB2ObjectType)dbObject);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnIdentifier> getAttributes(WbConnection wbConnection, DB2ObjectType dB2ObjectType) {
        if (dB2ObjectType == null) {
            return null;
        }
        String string = null;
        string = dB2ObjectType.getMetaType() == DB2ObjectType.MetaType.row ? "select fieldname,  \n       fieldtypename, \n       length, \n       scale  \nfrom syscat.rowfields \n" : "select attr_name,  \n       attr_typename, \n       length, \n       scale  \nfrom syscat.attributes  \n";
        string = string + " WHERE typename = '" + dB2ObjectType.getObjectName() + "' \n";
        string = string + " AND typeschema = '" + dB2ObjectType.getSchema() + "' \n";
        string = string + " ORDER BY ordinal";
        LogMgr.logMetadataSql(new CallerInfo(){}, "type attributes", string, new Object[0]);
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(dB2ObjectType.getNumberOfAttributes());
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string);
            Db2DataTypeMapper db2DataTypeMapper = new Db2DataTypeMapper();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                int n = resultSet.getInt(3);
                int n2 = resultSet.getInt(4);
                int n3 = db2DataTypeMapper.getJDBCTypeName(string3);
                ColumnIdentifier columnIdentifier = new ColumnIdentifier(string2, n3);
                String string4 = db2DataTypeMapper.getDisplayType(string3, n3, n, n2);
                columnIdentifier.setDbmsType(string4);
                arrayList.add(columnIdentifier);
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "type attributes", string, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return arrayList;
    }
}

