/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.storage.ColumnData;
import workbench.storage.MergeGenerator;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.storage.RowDataContainer;
import workbench.storage.SqlLiteralFormatter;

public class Db2MergeGenerator
implements MergeGenerator {
    private SqlLiteralFormatter formatter = new SqlLiteralFormatter("ansi");

    @Override
    public String generateMergeStart(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(100);
        this.generateStart(stringBuilder, rowDataContainer, false);
        return stringBuilder.toString();
    }

    @Override
    public String addRow(ResultInfo resultInfo, RowData rowData, long l) {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (l > 0L) {
            stringBuilder.append(",\n    ");
        }
        stringBuilder.append('(');
        this.appendValues(stringBuilder, resultInfo, rowData);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String generateMergeEnd(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(rowDataContainer.getRowCount());
        this.appendJoin(stringBuilder, rowDataContainer);
        this.appendUpdate(stringBuilder, rowDataContainer);
        this.appendInsert(stringBuilder, rowDataContainer);
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    @Override
    public String generateMerge(RowDataContainer rowDataContainer) {
        StringBuilder stringBuilder = new StringBuilder(rowDataContainer.getRowCount());
        this.generateStart(stringBuilder, rowDataContainer, true);
        this.appendJoin(stringBuilder, rowDataContainer);
        this.appendUpdate(stringBuilder, rowDataContainer);
        this.appendInsert(stringBuilder, rowDataContainer);
        return stringBuilder.toString();
    }

    private void generateStart(StringBuilder stringBuilder, RowDataContainer rowDataContainer, boolean bl) {
        TableIdentifier tableIdentifier = rowDataContainer.getUpdateTable();
        stringBuilder.append("MERGE INTO ");
        stringBuilder.append(tableIdentifier.getTableExpression(rowDataContainer.getOriginalConnection()));
        stringBuilder.append(" ut\nUSING TABLE (\n  VALUES\n    ");
        if (bl) {
            ResultInfo resultInfo = rowDataContainer.getResultInfo();
            for (int i = 0; i < rowDataContainer.getRowCount(); ++i) {
                if (i > 0) {
                    stringBuilder.append(",\n    ");
                }
                stringBuilder.append('(');
                this.appendValues(stringBuilder, resultInfo, rowDataContainer.getRow(i));
                stringBuilder.append(')');
            }
        }
    }

    private void appendJoin(StringBuilder stringBuilder, RowDataContainer rowDataContainer) {
        int n;
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        stringBuilder.append("\n) md(");
        for (n = 0; n < resultInfo.getColumnCount(); ++n) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(resultInfo.getColumnName(n));
        }
        stringBuilder.append(") ON (");
        n = 0;
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            ColumnIdentifier columnIdentifier = resultInfo.getColumn(i);
            if (!columnIdentifier.isPkColumn()) continue;
            if (n > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append("ut.");
            stringBuilder.append(resultInfo.getColumnName(i));
            stringBuilder.append(" = md.");
            stringBuilder.append(resultInfo.getColumnName(i));
            ++n;
        }
        stringBuilder.append(")");
    }

    private void appendValues(StringBuilder stringBuilder, ResultInfo resultInfo, RowData rowData) {
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            ColumnData columnData = new ColumnData(rowData.getValue(i), resultInfo.getColumn(i));
            stringBuilder.append(this.formatter.getDefaultLiteral(columnData));
        }
    }

    private void appendUpdate(StringBuilder stringBuilder, RowDataContainer rowDataContainer) {
        stringBuilder.append("\nWHEN MATCHED THEN UPDATE");
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        int n = 0;
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            ColumnIdentifier columnIdentifier = resultInfo.getColumn(i);
            if (columnIdentifier.isPkColumn()) continue;
            if (n == 0) {
                stringBuilder.append("\n     SET ");
            }
            if (n > 0) {
                stringBuilder.append(",\n         ");
            }
            stringBuilder.append(resultInfo.getColumnName(i));
            stringBuilder.append(" = md.");
            stringBuilder.append(resultInfo.getColumnName(i));
            ++n;
        }
    }

    private void appendInsert(StringBuilder stringBuilder, RowDataContainer rowDataContainer) {
        stringBuilder.append("\nWHEN NOT MATCHED THEN\n  INSERT (");
        ResultInfo resultInfo = rowDataContainer.getResultInfo();
        StringBuilder stringBuilder2 = new StringBuilder(resultInfo.getColumnCount() * 10);
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
                stringBuilder2.append(", ");
            }
            stringBuilder.append(resultInfo.getColumnName(i));
            stringBuilder2.append("md.");
            stringBuilder2.append(resultInfo.getColumnName(i));
        }
        stringBuilder.append(")\n");
        stringBuilder.append("  VALUES (");
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append(");");
    }
}

