/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.DbSearchPath;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class Db2SearchPath
implements DbSearchPath {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSearchPath(WbConnection wbConnection, String string) {
        Object object;
        if (wbConnection == null) {
            return Collections.emptyList();
        }
        if (string != null) {
            return Collections.singletonList(wbConnection.getMetadata().adjustSchemaNameCase(string));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        Statement statement = null;
        String string2 = this.getSQL(wbConnection);
        LogMgr.logDebug(new CallerInfo(){}, "Query to retrieve search path: " + string2);
        try {
            statement = wbConnection.createStatementForQuery();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (!StringUtil.isNonBlank((CharSequence)object)) continue;
                arrayList.add(((String)object).trim());
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not read search path", sQLException);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        object = this.parseResult(arrayList);
        LogMgr.logDebug(new CallerInfo(){}, "Using path: " + object.toString());
        return object;
    }

    private String getSQL(WbConnection wbConnection) {
        String string = Settings.getInstance().getProperty("workbench.db." + wbConnection.getDbId() + "searchpath.sql", null);
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder(50);
            stringBuilder.append("select current_path from SYSIBM");
            stringBuilder.append(wbConnection.getMetadata().getSchemaSeparator());
            stringBuilder.append("SYSDUMMY1");
            string = stringBuilder.toString();
        }
        return string;
    }

    List<String> parseResult(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            if (string.charAt(0) == '*') continue;
            arrayList.addAll(StringUtil.stringToList(string, ",", true, true, false, false));
        }
        return arrayList;
    }

    @Override
    public boolean isRealSearchPath() {
        return true;
    }
}

