/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import workbench.db.DBID;
import workbench.db.JdbcUtils;
import workbench.db.SynonymReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.SqlUtil;

public class Db2SynonymReader
implements SynonymReader {
    @Override
    public List<TableIdentifier> getSynonymList(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        return Collections.emptyList();
    }

    @Override
    public String getSynonymTypeName() {
        return "ALIAS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableIdentifier getSynonymTable(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        String string4 = "";
        DBID dBID = DBID.fromConnection(wbConnection);
        switch (dBID) {
            case DB2_ISERIES: {
                string4 = "SELECT base_table_schema, base_table_name \nFROM qsys2" + wbConnection.getMetadata().getCatalogSeparator() + "systables \nWHERE table_type = 'A' \n  AND table_name = ? \n  AND table_schema = ?";
                break;
            }
            case DB2_ZOS: {
                string4 = "SELECT tbcreator, tbname \nFROM sysibm.syssynonyms \nWHERE name = ? \n  AND creator = ?";
                break;
            }
            default: {
                string4 = "SELECT base_tabschema, base_tabname \nFROM syscat.tables \nWHERE type = 'A' \n  and tabname = ? \n  and tabschema = ?";
            }
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "synonyms", string4, string3, string2);
        PreparedStatement preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string5 = null;
        String string6 = null;
        TableIdentifier tableIdentifier = null;
        try {
            if (resultSet.next()) {
                string6 = resultSet.getString(1);
                string5 = resultSet.getString(2);
                if (string5 != null) {
                    tableIdentifier = new TableIdentifier(null, string6, string5, false);
                    tableIdentifier.setNeverAdjustCase(true);
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logMetadataError(new CallerInfo(){}, exception, "synonyms", string4, string3, string2);
        }
        finally {
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        return tableIdentifier;
    }

    @Override
    public String getSynonymSource(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        TableIdentifier tableIdentifier = this.getSynonymTable(wbConnection, string, string2, string3);
        StringBuilder stringBuilder = new StringBuilder(0);
        String string4 = Settings.getInstance().getInternalEditorLineEnding();
        stringBuilder.append("CREATE OR REPLACE ALIAS ");
        stringBuilder.append(SqlUtil.buildExpression(wbConnection, null, string2, string3));
        stringBuilder.append(string4 + "   FOR ");
        stringBuilder.append(tableIdentifier.getTableExpression());
        stringBuilder.append(';');
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    @Override
    public boolean supportsReplace(WbConnection wbConnection) {
        return true;
    }
}

