/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ibm;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcUtils;
import workbench.db.ObjectSourceOptions;
import workbench.db.TableIdentifier;
import workbench.db.TableSourceBuilder;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class Db2TableSourceBuilder
extends TableSourceBuilder {
    private boolean checkHistoryTable;

    public Db2TableSourceBuilder(WbConnection wbConnection) {
        super(wbConnection);
        this.checkHistoryTable = JdbcUtils.hasMinimumServerVersion(wbConnection, "10.1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTableOptions(TableIdentifier tableIdentifier, List<ColumnIdentifier> list) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block7: {
            if (!this.checkHistoryTable) {
                return;
            }
            if (tableIdentifier == null) {
                return;
            }
            if (tableIdentifier.getSourceOptions().isInitialized()) {
                return;
            }
            String string = "select periodname, \n       begincolname, \n       endcolname, \n       historytabschema, \n       historytabname \n from syscat.periods \nwhere tabschema = ? \n  and tabname = ? ";
            preparedStatement = null;
            resultSet = null;
            String string2 = tableIdentifier.getTableName();
            String string3 = tableIdentifier.getSchema();
            LogMgr.logMetadataSql(new CallerInfo(){}, "table options", string, string3, string2);
            try {
                preparedStatement = this.dbConnection.getSqlConnection().prepareStatement(string);
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block7;
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                String string7 = resultSet.getString(4);
                String string8 = resultSet.getString(5);
                TableIdentifier tableIdentifier2 = new TableIdentifier(string7, string8);
                ObjectSourceOptions objectSourceOptions = tableIdentifier.getSourceOptions();
                String string9 = "PERIOD " + string4 + " (" + string5 + ", " + string6 + ")";
                objectSourceOptions.setInlineOption(string9);
                String string10 = "ALTER TABLE " + tableIdentifier.getTableExpression(this.dbConnection) + "\n  ADD VERSIONING USE HISTORY TABLE " + tableIdentifier2.getTableExpression(this.dbConnection) + ";\n";
                objectSourceOptions.setAdditionalSql(string10);
            }
            catch (Exception exception) {
                try {
                    LogMgr.logMetadataError(new CallerInfo(){}, exception, "table options", string, string3, string2);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, preparedStatement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, preparedStatement);
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        tableIdentifier.getSourceOptions().setInitialized();
    }
}

