/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.Writer;
import workbench.db.TableIdentifier;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class BadfileWriter {
    private WbFile badFile;
    private int badRows = 0;
    private String encoding = null;

    public BadfileWriter(String string, TableIdentifier tableIdentifier, String string2) {
        WbFile wbFile = new WbFile(string);
        if (wbFile.isDirectory()) {
            String string3 = StringUtil.makeFilename(tableIdentifier.getTableName()) + ".bad";
            this.badFile = new WbFile(string, string3);
        } else {
            this.badFile = wbFile;
        }
        this.encoding = string2;
        this.badFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recordRejected(String string) {
        Writer writer = null;
        try {
            writer = EncodingUtil.createWriter(this.badFile, this.encoding, true);
            writer.write(string);
            writer.write(StringUtil.LINE_TERMINATOR);
            ++this.badRows;
        }
        catch (Exception exception) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not write record", exception);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(writer);
                throw throwable;
            }
            FileUtil.closeQuietely(writer);
        }
        FileUtil.closeQuietely(writer);
    }

    public synchronized int getRows() {
        return this.badRows;
    }

    public CharSequence getMessage() {
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(this.badRows);
        stringBuilder.append(' ');
        stringBuilder.append(ResourceMgr.getString("MsgCopyNumRowsRejected") + "\n");
        stringBuilder.append(ResourceMgr.getFormattedString("MsgCopyBadFile", this.badFile.getFullPath()));
        return stringBuilder;
    }
}

