/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObjectFinder;
import workbench.db.TableIdentifier;
import workbench.db.exporter.BlobMode;
import workbench.db.importer.AbstractXmlDataFileParser;
import workbench.db.importer.ImportFileColumn;
import workbench.db.importer.ParsingConverterException;
import workbench.db.importer.ParsingInterruptedException;
import workbench.db.importer.TablenameResolver;
import workbench.db.importer.XmlTableDefinitionParser;
import workbench.db.importer.XmlTableNameResolver;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.MessageBuffer;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class WbXmlDataFileParser
extends AbstractXmlDataFileParser {
    private String tableNameFromFile;
    private ColumnIdentifier[] columns;
    private boolean verboseFormat = true;
    private boolean formatKnown = false;
    private boolean ignoreCurrentRow;
    private int currentColIndex = 0;
    private int realColIndex = 0;
    private long columnLongValue = 0L;
    private String columnDataFile = null;
    private boolean isNull = false;
    private StringBuilder chars;
    private String rowTag = "row-data";
    private String columnTag = "column-data";
    private DefaultHandler handler = new SaxHandler();

    public WbXmlDataFileParser() {
    }

    public WbXmlDataFileParser(File file) {
        super(file);
    }

    @Override
    protected TablenameResolver getTableNameResolver() {
        return new XmlTableNameResolver(this.getEncoding());
    }

    @Override
    public void setColumns(List<ColumnIdentifier> list) throws SQLException {
        super.setColumns(list);
        this.checkImportColumns();
    }

    public void checkTargetColumns(TableIdentifier tableIdentifier) throws SQLException {
        if (this.connection == null) {
            return;
        }
        if (this.columns == null) {
            return;
        }
        if (tableIdentifier == null) {
            return;
        }
        DbObjectFinder dbObjectFinder = new DbObjectFinder(this.connection);
        if (!dbObjectFinder.tableExists(tableIdentifier)) {
            if (this.receiver.getCreateTarget()) {
                LogMgr.logInfo(new CallerInfo(){}, "Table " + tableIdentifier.getTableExpression(this.connection) + " not found, but receiver will create it. Skipping column check...");
                return;
            }
            String string = ResourceMgr.getFormattedString("ErrTargetTableNotFound", tableIdentifier.getTableName());
            this.messages.append(string);
            this.messages.appendNewLine();
            throw new SQLException("Table " + tableIdentifier.getTableExpression(this.connection) + " not found!");
        }
        List<ColumnIdentifier> list = this.connection.getMetadata().getTableColumns(tableIdentifier);
        List<ImportFileColumn> list2 = ImportFileColumn.createList();
        for (int i = 0; i < this.columns.length; ++i) {
            Object object;
            int n = list.indexOf(this.columns[i]);
            if (n != -1) {
                this.columns[i] = object = list.get(n);
                list2.add(new ImportFileColumn((ColumnIdentifier)object));
                continue;
            }
            object = this.columns[i] != null ? this.columns[i].getColumnName() : "n/a";
            String string = ResourceMgr.getFormattedString("ErrImportColumnNotFound", object, this.getSourceFilename(), tableIdentifier.getTableExpression());
            this.messages.append(string);
            this.messages.appendNewLine();
            if (this.abortOnError) {
                this.hasErrors = true;
                throw new SQLException("Column " + (String)object + " not found in target table");
            }
            this.hasWarnings = true;
            LogMgr.logWarning(new CallerInfo(){}, string);
        }
        if (list2.size() != this.columns.length) {
            this.importColumns = list2;
        }
    }

    private void checkImportColumns() throws SQLException {
        if (this.importColumns == null) {
            return;
        }
        this.missingColumns.clear();
        try {
            if (this.columns == null) {
                this.readXmlTableDefinition();
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error reading table definition from XML file", throwable);
            this.hasErrors = true;
            throw new SQLException("Could not read table definition from XML file");
        }
        Iterator iterator = this.importColumns.iterator();
        while (iterator.hasNext()) {
            ColumnIdentifier columnIdentifier = ((ImportFileColumn)iterator.next()).getColumn();
            if (this.containsColumn(columnIdentifier)) continue;
            if (this.ignoreMissingColumns || !this.abortOnError) {
                String string = ResourceMgr.getFormattedString("ErrImportColumnIgnored", columnIdentifier.getColumnName(), this.getSourceFilename(), this.tableName);
                LogMgr.logWarning(new CallerInfo(){}, "Ignoring table column " + columnIdentifier.getColumnName() + " because it is not present in the input file");
                this.hasWarnings = true;
                if (!this.ignoreMissingColumns) {
                    this.hasErrors = true;
                }
                this.messages.append(string);
                iterator.remove();
                continue;
            }
            this.missingColumns.add(columnIdentifier.getColumnName());
        }
        if (this.missingColumns.size() > 0) {
            this.hasErrors = true;
            throw new SQLException("The columns " + this.missingColumns + " from the table " + this.tableName + " are not present in input file!");
        }
    }

    private boolean containsColumn(ColumnIdentifier columnIdentifier) {
        if (this.columns == null) {
            return false;
        }
        for (ColumnIdentifier columnIdentifier2 : this.columns) {
            if (!columnIdentifier2.equals(columnIdentifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ColumnIdentifier> getColumnsFromFile() {
        try {
            if (this.columns == null) {
                this.readXmlTableDefinition();
            }
        }
        catch (IOException | SAXException exception) {
            return Collections.emptyList();
        }
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(this.columns.length);
        arrayList.addAll(Arrays.asList(this.columns));
        return arrayList;
    }

    private void detectBlobEncoding() {
        try {
            this.fileHandler.setMainFile(this.inputFile, this.getEncoding());
            XmlTableDefinitionParser xmlTableDefinitionParser = new XmlTableDefinitionParser(this.fileHandler);
            String string = xmlTableDefinitionParser.getBlobEncoding();
            if (StringUtil.isNonBlank(string)) {
                this.setDefaultBlobMode(BlobMode.getMode(string));
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not detect XML tag format. Assuming 'verbose'", exception);
            this.setUseVerboseFormat(true);
        }
    }

    @Override
    public String getEncoding() {
        return StringUtil.isEmptyString(this.encoding) ? "UTF-8" : this.encoding;
    }

    private void detectTagFormat() {
        try {
            this.fileHandler.setMainFile(this.inputFile, this.getEncoding());
            XmlTableDefinitionParser xmlTableDefinitionParser = new XmlTableDefinitionParser(this.fileHandler);
            this.detectTagFormat(xmlTableDefinitionParser);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not detect XML tag format. Assuming 'verbose'", exception);
            this.setUseVerboseFormat(true);
        }
    }

    private void detectTagFormat(XmlTableDefinitionParser xmlTableDefinitionParser) {
        String string = xmlTableDefinitionParser.getTagFormat();
        if (string != null) {
            if ("long".equals(string)) {
                this.setUseVerboseFormat(true);
            } else if ("short".equals(string)) {
                this.setUseVerboseFormat(false);
            }
        }
    }

    private void readXmlTableDefinition() throws IOException, SAXException {
        this.fileHandler.setMainFile(this.inputFile, this.getEncoding());
        XmlTableDefinitionParser xmlTableDefinitionParser = new XmlTableDefinitionParser(this.fileHandler);
        this.columns = xmlTableDefinitionParser.getColumns();
        this.tableNameFromFile = xmlTableDefinitionParser.getTableName();
        this.detectTagFormat(xmlTableDefinitionParser);
    }

    @Override
    protected void processOneFile() throws Exception {
        if (this.columns == null) {
            this.readXmlTableDefinition();
        }
        if (!this.formatKnown) {
            this.detectTagFormat();
        }
        this.detectBlobEncoding();
        this.fileHandler.setMainFile(this.inputFile, this.getEncoding());
        this.blobDecoder.setBaseDir(this.inputFile.getParentFile());
        if (!this.sharedMessages) {
            this.messages = new MessageBuffer();
        }
        this.sendTableDefinition();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.fileHandler.getMainFileReader();
            InputSource inputSource = new InputSource(bufferedReader);
            this.saxParser.parse(inputSource, this.handler);
            this.filesProcessed.add(this.inputFile);
            this.receiver.tableImportFinished();
        }
        catch (ParsingInterruptedException parsingInterruptedException) {
            if (this.regularStop) {
                this.receiver.tableImportFinished();
            } else {
                this.hasErrors = true;
            }
        }
        catch (ParsingConverterException parsingConverterException) {
            this.receiver.tableImportError();
            this.hasErrors = true;
            throw parsingConverterException;
        }
        catch (Exception exception) {
            String string = "Error during parsing of data row: " + this.currentRowNumber + ", column: " + this.currentColIndex + ", current data: " + (this.chars == null ? "<n/a>" : "[" + this.chars.toString() + "]") + ", message: " + ExceptionUtil.getDisplay(exception);
            LogMgr.logWarning(new CallerInfo(){}, string);
            this.hasErrors = true;
            this.messages.append(string);
            this.messages.appendNewLine();
            this.receiver.tableImportError();
            throw exception;
        }
        finally {
            FileUtil.closeQuietely(bufferedReader);
        }
    }

    @Override
    protected void resetForFile() {
        super.resetForFile();
        this.tableNameFromFile = null;
        this.ignoreCurrentRow = false;
        this.currentColIndex = 0;
        this.realColIndex = 0;
        this.columnLongValue = 0L;
        this.isNull = false;
        this.chars = null;
        this.columns = null;
        this.importColumns = null;
    }

    @Override
    protected void clearRowData() {
        super.clearRowData();
        this.currentColIndex = 0;
        this.realColIndex = 0;
    }

    private void buildColumnData() throws ParsingConverterException {
        if (this.importColumns != null && this.getColumnIndex(this.columns[this.currentColIndex].getColumnName()) < 0) {
            return;
        }
        this.currentRow[this.realColIndex] = null;
        if (!this.receiver.shouldProcessNextRow()) {
            return;
        }
        if (this.isNull) {
            ++this.realColIndex;
            return;
        }
        int n = this.columns[this.realColIndex].getDataType();
        String string = this.chars.toString();
        if (this.trimValues && !SqlUtil.isBlobType(n)) {
            string = string.trim();
        }
        if (this.valueModifier != null) {
            string = this.valueModifier.modifyValue(this.columns[this.realColIndex], string);
        }
        try {
            if (SqlUtil.isCharacterType(n)) {
                if (this.columnDataFile == null) {
                    this.currentRow[this.realColIndex] = string;
                } else {
                    String string2 = this.inputFile.getParent();
                    this.currentRow[this.realColIndex] = new File(string2, this.columnDataFile);
                }
            } else if (SqlUtil.isBlobType(n)) {
                this.currentRow[this.realColIndex] = this.columnDataFile != null ? this.blobDecoder.decodeBlob(this.columnDataFile, this.getDefaultBlobMode()) : this.blobDecoder.decodeBlob(string, this.getDefaultBlobMode());
            } else if (SqlUtil.isDateType(n)) {
                Date date = new Date(this.columnLongValue);
                this.currentRow[this.realColIndex] = n == 93 ? new Timestamp(date.getTime()) : date;
            } else {
                this.currentRow[this.realColIndex] = this.converter.convertValue(string, n);
            }
        }
        catch (Exception exception) {
            String string3 = ResourceMgr.getString("ErrConvertError");
            string3 = StringUtil.replace(string3, "%type%", SqlUtil.getTypeName(this.columns[this.realColIndex].getDataType()));
            string3 = StringUtil.replace(string3, "%column%", this.columns[this.realColIndex].getColumnName());
            string3 = StringUtil.replace(string3, "%error%", exception.getMessage());
            string3 = StringUtil.replace(string3, "%value%", string);
            string3 = StringUtil.replace(string3, "%row%", Integer.toString(this.currentRowNumber));
            this.messages.append(string3);
            this.messages.appendNewLine();
            if (this.abortOnError) {
                LogMgr.logError(new CallerInfo(){}, string3, exception);
                this.hasErrors = true;
                throw new ParsingConverterException();
            }
            this.messages.append(ResourceMgr.getString("ErrConvertWarning"));
            this.hasWarnings = true;
            LogMgr.logWarning(new CallerInfo(){}, string3, null);
        }
        ++this.realColIndex;
    }

    @Override
    protected String getTablename() {
        return this.tableName == null ? this.tableNameFromFile : this.tableName;
    }

    private void sendTableDefinition() throws SQLException {
        try {
            TableIdentifier tableIdentifier = this.createTargetTableId();
            this.checkTargetColumns(tableIdentifier);
            if (this.importColumns == null) {
                this.receiver.setTargetTable(tableIdentifier, Arrays.asList(this.columns), this.inputFile);
                this.currentRow = new Object[this.columns.length];
            } else {
                ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
                for (ColumnIdentifier columnIdentifier : this.columns) {
                    if (this.getColumnIndex(columnIdentifier.getColumnName()) <= -1) continue;
                    arrayList.add(columnIdentifier);
                }
                this.receiver.setTargetTable(tableIdentifier, arrayList, this.inputFile);
                this.currentRow = new Object[arrayList.size()];
            }
        }
        catch (SQLException sQLException) {
            this.currentRow = null;
            this.hasErrors = true;
            throw sQLException;
        }
    }

    private void setUseVerboseFormat(boolean bl) {
        this.formatKnown = true;
        this.verboseFormat = bl;
        if (this.verboseFormat) {
            this.rowTag = "row-data";
            this.columnTag = "column-data";
        } else {
            this.rowTag = "rd";
            this.columnTag = "cd";
        }
    }

    private class SaxHandler
    extends DefaultHandler {
        private SaxHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            Thread.yield();
            if (WbXmlDataFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            Thread.yield();
            if (WbXmlDataFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Thread.yield();
            if (WbXmlDataFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
            if (string3.equals(WbXmlDataFileParser.this.rowTag)) {
                WbXmlDataFileParser.this.clearRowData();
                WbXmlDataFileParser.this.chars = null;
            } else if (string3.equals(WbXmlDataFileParser.this.columnTag)) {
                WbXmlDataFileParser.this.chars = new StringBuilder();
                String string4 = attributes.getValue("longValue");
                if (string4 != null) {
                    try {
                        WbXmlDataFileParser.this.columnLongValue = Long.parseLong(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LogMgr.logError(new CallerInfo(){}, "Error converting longvalue", numberFormatException);
                    }
                }
                string4 = attributes.getValue("null");
                WbXmlDataFileParser.this.isNull = "true".equals(string4);
                WbXmlDataFileParser.this.columnDataFile = attributes.getValue("dataFile");
            } else {
                WbXmlDataFileParser.this.chars = null;
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (WbXmlDataFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
            if (string3.equals(WbXmlDataFileParser.this.rowTag)) {
                block9: {
                    if (!WbXmlDataFileParser.this.receiver.shouldProcessNextRow()) {
                        WbXmlDataFileParser.this.receiver.nextRowSkipped();
                    } else if (!WbXmlDataFileParser.this.ignoreCurrentRow) {
                        try {
                            WbXmlDataFileParser.this.sendRowData();
                        }
                        catch (Exception exception) {
                            if (!WbXmlDataFileParser.this.abortOnError) break block9;
                            throw new ParsingInterruptedException();
                        }
                    }
                }
                WbXmlDataFileParser.this.ignoreCurrentRow = false;
                ++WbXmlDataFileParser.this.currentRowNumber;
            } else if (string3.equals(WbXmlDataFileParser.this.columnTag)) {
                WbXmlDataFileParser.this.buildColumnData();
                WbXmlDataFileParser.this.currentColIndex++;
            }
            WbXmlDataFileParser.this.chars = null;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            Thread.yield();
            if (WbXmlDataFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
            if (WbXmlDataFileParser.this.chars != null) {
                WbXmlDataFileParser.this.chars.append(cArray, n, n2);
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            Thread.yield();
            if (WbXmlDataFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            Thread.yield();
            if (WbXmlDataFileParser.this.cancelImport) {
                throw new ParsingInterruptedException();
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXParseException {
            String string = "XML Parse error in line=" + sAXParseException.getLineNumber() + ",data-row=" + WbXmlDataFileParser.this.currentRowNumber;
            LogMgr.logError(new CallerInfo(){}, string, sAXParseException);
            WbXmlDataFileParser.this.ignoreCurrentRow = true;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            String string = "Fatal XML parse error in line=" + sAXParseException.getLineNumber() + ",data-row=" + WbXmlDataFileParser.this.currentRowNumber + "\nRest of file will be ignored!";
            LogMgr.logError(new CallerInfo(){}, string, sAXParseException);
            WbXmlDataFileParser.this.ignoreCurrentRow = true;
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXParseException {
            WbXmlDataFileParser.this.messages.append(ExceptionUtil.getDisplay(sAXParseException));
            WbXmlDataFileParser.this.messages.appendNewLine();
            if (WbXmlDataFileParser.this.cancelImport) {
                throw sAXParseException;
            }
        }
    }
}

