/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.importer;

import java.io.BufferedReader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import workbench.db.ColumnIdentifier;
import workbench.db.importer.ImportFileHandler;
import workbench.db.importer.ParsingEndedException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class XmlTableDefinitionParser
extends DefaultHandler {
    private int currentColIndex;
    private ColumnIdentifier[] columnList;
    private String tableName;
    private ImportFileHandler fileHandler;
    private StringBuilder chars;
    private String tagFormat;
    private String blobEncoding;

    public XmlTableDefinitionParser(ImportFileHandler importFileHandler) throws IOException, SAXException {
        this.fileHandler = importFileHandler;
        this.parseTableStructure();
    }

    public ColumnIdentifier[] getColumns() {
        return this.columnList;
    }

    public String getBlobEncoding() {
        return this.blobEncoding;
    }

    public String getTagFormat() {
        return this.tagFormat;
    }

    public String getTableName() {
        return this.tableName;
    }

    private void parseTableStructure() throws IOException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        BufferedReader bufferedReader = null;
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            bufferedReader = this.fileHandler.getMainFileReader();
            InputSource inputSource = new InputSource(bufferedReader);
            sAXParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (ParserConfigurationException | ParsingEndedException exception) {
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (SAXException sAXException) {
            LogMgr.logError(new CallerInfo(){}, "Error reading table structure", sAXException);
            this.columnList = null;
            this.tableName = null;
            throw sAXException;
        }
        finally {
            FileUtil.closeQuietely(this.fileHandler);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.chars = new StringBuilder();
        if (string3.equals("column-def")) {
            this.columnList[this.currentColIndex] = new ColumnIdentifier();
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("wb-tag-format")) {
            this.tagFormat = this.chars.toString();
        } else if (string3.equals("wb-blob-encoding")) {
            this.blobEncoding = this.chars.toString();
        } else if (string3.equals("column-count")) {
            try {
                int n = StringUtil.getIntValue(this.chars.toString(), -1);
                this.columnList = new ColumnIdentifier[n];
                this.currentColIndex = 0;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Incorrec value for column-count: " + this.chars, exception);
                throw new SAXException("Invalid column count", exception);
            }
        } else if (string3.equals("column-def")) {
            ++this.currentColIndex;
        } else if (string3.equals("table-name")) {
            this.tableName = this.chars.toString();
        } else if (string3.equals("column-name")) {
            this.columnList[this.currentColIndex].setColumnName(this.chars.toString());
        } else if (string3.equals("java-sql-type")) {
            try {
                int n = Integer.parseInt(this.chars.toString());
                this.columnList[this.currentColIndex].setDataType(n);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not read columnn type!", exception);
                throw new SAXException("Could not read columnn type", exception);
            }
        } else if (string3.equals("dbms-data-type")) {
            try {
                this.columnList[this.currentColIndex].setDbmsType(this.chars.toString());
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not read dbms columnn type!", exception);
                throw new SAXException("Could not read dbms columnn type", exception);
            }
        } else if (string3.equals("java-class")) {
            try {
                this.columnList[this.currentColIndex].setColumnClassName(this.chars.toString());
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not read columnn class name!", exception);
                throw new SAXException("Could not read columnn name", exception);
            }
        } else if (string3.equals("table-def")) {
            throw new ParsingEndedException();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.chars != null) {
            this.chars.append(cArray, n, n2);
        }
    }
}

