/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.ingres;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class IngresSequenceReader
implements SequenceReader {
    private WbConnection dbConn;
    private final String SELECT_SEQUENCE_DEF = "SELECT SEQ_NAME,  \n       SEQ_OWNER, \n       MIN_VALUE,  \n       MAX_VALUE,  \n       INCREMENT_VALUE,  \n       CYCLE_FLAG,  \n       ORDER_FLAG,  \n       CACHE_SIZE  \nFROM   iisequences \n";

    public IngresSequenceReader(WbConnection wbConnection) {
        this.dbConn = wbConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SequenceDefinition> getSequences(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("SELECT SEQ_NAME,  \n       SEQ_OWNER, \n       MIN_VALUE,  \n       MAX_VALUE,  \n       INCREMENT_VALUE,  \n       CYCLE_FLAG,  \n       ORDER_FLAG,  \n       CACHE_SIZE  \nFROM   iisequences \n");
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        if (StringUtil.isNonBlank(string2)) {
            bl = true;
            n = 1;
            stringBuilder.append(" WHERE seq_owner = ?");
        }
        if (StringUtil.isNonBlank(string3)) {
            if (bl) {
                stringBuilder.append(" AND ");
                n2 = 2;
            } else {
                stringBuilder.append(" WHERE ");
                n2 = 1;
            }
            if (string3.indexOf(37) > 0) {
                stringBuilder.append(" seq_name LIKE ? ");
                SqlUtil.appendEscapeClause(stringBuilder, this.dbConn, string3);
                string3 = SqlUtil.escapeUnderscore(string3, this.dbConn);
            } else {
                stringBuilder.append(" seq_name = ? ");
            }
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        ArrayList<SequenceDefinition> arrayList = new ArrayList<SequenceDefinition>();
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequences", stringBuilder, new Object[0]);
        try {
            preparedStatement = this.dbConn.getSqlConnection().prepareStatement(stringBuilder.toString());
            if (n != -1) {
                preparedStatement.setString(n, string2.trim());
            }
            if (n2 != -1) {
                preparedStatement.setString(n2, string3.trim());
            }
            resultSet = preparedStatement.executeQuery();
            DataStore dataStore = new DataStore(resultSet);
            dataStore.setTrimCharData(true);
            dataStore.initData(resultSet);
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                arrayList.add(this.createDefinition(dataStore, i, dataStore.getValueAsString(i, 1), dataStore.getValueAsString(i, 0)));
            }
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, throwable, "sequences", stringBuilder, new Object[0]);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable2;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return arrayList;
    }

    @Override
    public SequenceDefinition getSequenceDefinition(String string, String string2, String string3) {
        DataStore dataStore = this.getRawSequenceDefinition(string, string2, string3);
        if (dataStore == null || dataStore.getRowCount() == 0) {
            return null;
        }
        return this.createDefinition(dataStore, 0, string2, string3);
    }

    private SequenceDefinition createDefinition(DataStore dataStore, int n, String string, String string2) {
        SequenceDefinition sequenceDefinition = new SequenceDefinition(string.trim(), string2.trim());
        sequenceDefinition.setSequenceProperty("min_value", dataStore.getValue(n, "MIN_VALUE"));
        sequenceDefinition.setSequenceProperty("max_value", dataStore.getValue(n, "MAX_VALUE"));
        sequenceDefinition.setSequenceProperty("increment", dataStore.getValue(n, "INCREMENT_VALUE"));
        sequenceDefinition.setSequenceProperty("cycle", dataStore.getValue(n, "CYCLE_FLAG"));
        sequenceDefinition.setSequenceProperty("ordered", dataStore.getValue(n, "ORDER_FLAG"));
        sequenceDefinition.setSequenceProperty("cache", dataStore.getValue(n, "CACHE_SIZE"));
        sequenceDefinition.setSource(this.buildSource(sequenceDefinition));
        return sequenceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStore getRawSequenceDefinition(String string, String string2, String string3) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        String string4 = "SELECT SEQ_NAME,  \n       SEQ_OWNER, \n       MIN_VALUE,  \n       MAX_VALUE,  \n       INCREMENT_VALUE,  \n       CYCLE_FLAG,  \n       ORDER_FLAG,  \n       CACHE_SIZE  \nFROM   iisequences \n WHERE seq_owner = ? AND seq_name = ?";
        LogMgr.logMetadataSql(new CallerInfo(){}, "sequence definition", string4, string2, string3);
        try {
            preparedStatement = this.dbConn.getSqlConnection().prepareStatement(string4);
            preparedStatement.setString(1, string2.trim());
            preparedStatement.setString(2, string3.trim());
            resultSet = preparedStatement.executeQuery();
            dataStore = new DataStore(resultSet);
            dataStore.setTrimCharData(true);
            dataStore.initData(resultSet);
        }
        catch (Throwable throwable) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, throwable, "sequence definition", string4, string2, string3);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable2;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    @Override
    public void readSequenceSource(SequenceDefinition sequenceDefinition) {
        if (sequenceDefinition == null) {
            return;
        }
        String string = this.getSequenceSource(null, sequenceDefinition.getSequenceOwner(), sequenceDefinition.getSequenceName());
        sequenceDefinition.setSource(string);
    }

    private String buildSource(SequenceDefinition sequenceDefinition) {
        StringBuilder stringBuilder = new StringBuilder(100);
        Number number = (Number)sequenceDefinition.getSequenceProperty("min_value");
        Number number2 = (Number)sequenceDefinition.getSequenceProperty("max_value");
        String string = sequenceDefinition.getSequenceProperty("increment").toString();
        String string2 = sequenceDefinition.getSequenceProperty("cycle").toString();
        String string3 = sequenceDefinition.getSequenceProperty("ordered").toString();
        Number number3 = (Number)sequenceDefinition.getSequenceProperty("cache");
        stringBuilder.append("CREATE SEQUENCE ");
        stringBuilder.append(sequenceDefinition.getSequenceName());
        stringBuilder.append("\n       INCREMENT BY ");
        stringBuilder.append(string);
        if (number.intValue() == 0) {
            stringBuilder.append("\n       NO MINVALUE");
        } else {
            stringBuilder.append("\n       MINVALUE ");
            stringBuilder.append(number);
        }
        if (number2.intValue() < Integer.MAX_VALUE) {
            stringBuilder.append("\n       MAXVALUE ");
            stringBuilder.append(number2);
        } else {
            stringBuilder.append("\n       NO MAXVALUE");
        }
        if (number3.intValue() > 0) {
            stringBuilder.append("\n       CACHE ");
            stringBuilder.append(number3);
        } else {
            stringBuilder.append("\n       NO CACHE");
        }
        stringBuilder.append("\n       ");
        stringBuilder.append(string2.equals("Y") ? "CYCLE" : "NO CYCLE");
        stringBuilder.append("\n       ");
        stringBuilder.append(string3.equals("Y") ? "ORDER" : "NO ORDER");
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public String getSequenceSource(String string, String string2, String string3) {
        SequenceDefinition sequenceDefinition = this.getSequenceDefinition(string, string2, string3);
        if (sequenceDefinition == null) {
            return null;
        }
        return sequenceDefinition.getSource().toString();
    }

    @Override
    public String getSequenceTypeName() {
        return "SEQUENCE";
    }
}

