/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.mssql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import workbench.db.ConstraintDefinition;
import workbench.db.IndexDefinition;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.UniqueConstraintReader;
import workbench.db.WbConnection;
import workbench.db.mssql.SqlServerUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;

public class SqlServerUniqueConstraintReader
implements UniqueConstraintReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readUniqueConstraints(TableIdentifier tableIdentifier, List<IndexDefinition> list, WbConnection wbConnection) {
        String string;
        String string2;
        if (!SqlServerUtil.isSqlServer2005(wbConnection)) {
            return;
        }
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        if (wbConnection == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("select ind.name as indname, sch.name as indschema, cons.name as consname \nfrom sys.indexes ind with (nolock) \n  join sys.objects obj with (nolock) on ind.object_id = obj.object_id \n  join sys.schemas sch with (nolock) on sch.schema_id = obj.schema_id \n  join sys.key_constraints cons with (nolock) on ind.object_id = cons.parent_object_id and ind.index_id = cons.unique_index_id \nwhere is_unique = 1  \nand is_unique_constraint = 1 \nand (");
        boolean bl = true;
        int n = 0;
        for (IndexDefinition object2 : list) {
            if (!object2.isUnique() || object2.isPrimaryKeyIndex()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(" OR ");
            }
            ++n;
            string2 = wbConnection.getMetadata().removeQuotes(object2.getSchema());
            string = wbConnection.getMetadata().removeQuotes(object2.getObjectName());
            stringBuilder.append(" (sch.name = '");
            stringBuilder.append(string2);
            stringBuilder.append("' AND ind.name = '");
            stringBuilder.append(string);
            stringBuilder.append("') ");
        }
        stringBuilder.append(')');
        if (n == 0) {
            return;
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "unique constraints", stringBuilder, new Object[0]);
        Object object3 = null;
        ResultSet resultSet = null;
        try {
            object3 = wbConnection.createStatement();
            ResultSet resultSet2 = object3.executeQuery(stringBuilder.toString());
            while (resultSet2.next()) {
                string2 = resultSet2.getString(1);
                string = resultSet2.getString(2);
                String string3 = resultSet2.getString(3);
                IndexDefinition indexDefinition = IndexDefinition.findIndex(list, string2, string);
                if (indexDefinition == null) continue;
                ConstraintDefinition constraintDefinition = ConstraintDefinition.createUniqueConstraint(string3);
                indexDefinition.setUniqueConstraint(constraintDefinition);
            }
            JdbcUtils.closeAll(resultSet2, (Statement)object3);
        }
        catch (SQLException sQLException) {
            LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "unique constraints", stringBuilder, new Object[0]);
        }
        finally {
            JdbcUtils.closeAll(resultSet, (Statement)object3);
        }
    }
}

