/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.objectcache;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import workbench.db.ConnectionProfile;
import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.db.objectcache.DbObjectCache;
import workbench.db.objectcache.ObjectCache;
import workbench.db.objectcache.ObjectCachePersistence;
import workbench.db.objectcache.ObjectCacheStorage;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.util.CollectionUtil;

public class DbObjectCacheFactory
implements PropertyChangeListener {
    public static final long CACHE_VERSION_UID = 1L;
    private final Object lock = new Object();
    private final Map<String, ObjectCache> caches = new HashMap<String, ObjectCache>();
    private final Map<String, Set<String>> refCounter = new HashMap<String, Set<String>>();

    public static DbObjectCacheFactory getInstance() {
        return LazyInstanceHolder.instance;
    }

    private DbObjectCacheFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache(ObjectCache objectCache, WbConnection wbConnection) {
        if (objectCache == null || wbConnection == null) {
            return;
        }
        if (this.useLocalCacheStorage(wbConnection)) {
            Object object = this.lock;
            synchronized (object) {
                ObjectCachePersistence objectCachePersistence = new ObjectCachePersistence();
                objectCachePersistence.loadFromLocalFile(objectCache, wbConnection);
            }
        }
    }

    private void saveCache(ObjectCache objectCache, WbConnection wbConnection) {
        if (this.useLocalCacheStorage(wbConnection)) {
            long l = System.currentTimeMillis();
            ObjectCachePersistence objectCachePersistence = new ObjectCachePersistence();
            objectCachePersistence.saveToLocalFile(objectCache, wbConnection);
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, "Saving cache for " + wbConnection.toString() + " took " + l2 + "ms");
        }
    }

    private boolean useLocalCacheStorage(WbConnection wbConnection) {
        if (wbConnection == null) {
            return false;
        }
        ObjectCacheStorage objectCacheStorage = GuiSettings.getLocalStorageForObjectCache();
        switch (objectCacheStorage) {
            case always: {
                return true;
            }
            case never: {
                return false;
            }
            case profile: {
                ConnectionProfile connectionProfile = wbConnection.getProfile();
                if (connectionProfile == null) break;
                return connectionProfile.getStoreCacheLocally();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCache(WbConnection wbConnection) {
        if (wbConnection == null) {
            return;
        }
        String string = this.makeKey(wbConnection);
        Object object = this.lock;
        synchronized (object) {
            ObjectCache objectCache = this.caches.get(string);
            if (objectCache == null) {
                return;
            }
            this.saveCache(objectCache, wbConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbObjectCache getCache(WbConnection wbConnection) {
        if (wbConnection == null) {
            return null;
        }
        String string = this.makeKey(wbConnection);
        Object object = this.lock;
        synchronized (object) {
            ObjectCache objectCache = this.caches.get(string);
            if (objectCache == null) {
                LogMgr.logDebug(new CallerInfo(){}, "Creating new cache for: " + wbConnection.toString());
                objectCache = new ObjectCache(wbConnection);
                this.caches.put(string, objectCache);
            }
            DbObjectCache dbObjectCache = new DbObjectCache(objectCache, wbConnection);
            wbConnection.addChangeListener(this);
            boolean bl = this.isCacheInUse(string);
            if (!bl) {
                this.loadCache(objectCache, wbConnection);
            }
            this.increaseRefCount(string, wbConnection.getId());
            return dbObjectCache;
        }
    }

    private int decreaseRefCount(String string, String string2) {
        Set<String> set = this.refCounter.get(string);
        if (set == null) {
            return 0;
        }
        set.remove(string2);
        return set.size();
    }

    private void increaseRefCount(String string, String string2) {
        Set<String> set = this.refCounter.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.refCounter.put(string, set);
        }
        set.add(string2);
    }

    private boolean isCacheInUse(String string) {
        Set<String> set = this.refCounter.get(string);
        return CollectionUtil.isNonEmpty(set);
    }

    private String makeKey(WbConnection wbConnection) {
        return wbConnection.getProfile().getLoginUser() + "@" + wbConnection.getProfile().getUrl();
    }

    private boolean clearOnClose(WbConnection wbConnection) {
        if (wbConnection == null) {
            return true;
        }
        DbSettings dbSettings = wbConnection.getDbSettings();
        if (dbSettings == null) {
            return true;
        }
        return dbSettings.clearCacheOnReconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && "closed".equals(propertyChangeEvent.getNewValue())) {
            WbConnection wbConnection = (WbConnection)propertyChangeEvent.getSource();
            if (wbConnection == null) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                String string = this.makeKey(wbConnection);
                boolean bl = this.clearOnClose(wbConnection);
                ObjectCache objectCache = this.caches.get(string);
                int n = this.decreaseRefCount(string, wbConnection.getId());
                LogMgr.logDebug(new CallerInfo(){}, "Connection " + wbConnection.toString() + " was closed. Reference count for this cache is: " + n);
                if (objectCache != null && (n <= 0 || bl)) {
                    this.saveCache(objectCache, wbConnection);
                    objectCache.clear();
                    this.caches.remove(string);
                    LogMgr.logDebug(new CallerInfo(){}, "Removed cache for " + wbConnection.toString());
                }
                wbConnection.removeChangeListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            for (ObjectCache objectCache : this.caches.values()) {
                objectCache.clear();
            }
            this.caches.clear();
        }
    }

    private static class LazyInstanceHolder {
        protected static final DbObjectCacheFactory instance = new DbObjectCacheFactory();

        private LazyInstanceHolder() {
        }
    }
}

