/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.objectcache;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import workbench.db.ColumnIdentifier;
import workbench.db.ConnectionProfile;
import workbench.db.DependencyNode;
import workbench.db.IndexDefinition;
import workbench.db.PkDefinition;
import workbench.db.ProcedureDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.objectcache.Namespace;
import workbench.db.objectcache.ObjectCache;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.util.DurationNumber;
import workbench.util.WbFile;

class ObjectCachePersistence {
    private static final String OBJECTS_ENTRY = "objects.dat";
    private static final String SCHEMAS_ENTRY = "schemas.dat";
    private static final String NAMESPACES_ENTRY = "namespaces.dat";
    private static final String REFERENCING_TABLES_ENTRY = "referencing_tables.data";
    private static final String REFERENCED_TABLES_ENTRY = "referenced_tables.data";
    private static final String PROCEDURES_ENTRY = "procedures.data";
    private static final String SYNONYMS_ENTRY = "synonyms.data";
    private static final String INDEX_ENTRY = "index.data";
    private static final String PK_ENTRY = "pk.data";

    ObjectCachePersistence() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void loadFromLocalFile(ObjectCache objectCache, WbConnection wbConnection) {
        block22: {
            if (wbConnection == null || objectCache == null) {
                return;
            }
            WbFile wbFile = this.getCacheFile(wbConnection);
            if (wbFile == null || !wbFile.exists() || wbFile.length() == 0L) {
                return;
            }
            String string = GuiSettings.getLocalStorageMaxAge();
            DurationNumber durationNumber = new DurationNumber();
            long l = durationNumber.parseDefinition(string);
            long l2 = System.currentTimeMillis() - wbFile.lastModified();
            if (l2 >= l || l2 < 0L) {
                LogMgr.logInfo(new CallerInfo(){}, "Cache file " + wbFile.getFullPath() + " was discarded because it is too old (max. age=" + string + ").");
                wbFile.delete();
                return;
            }
            ZipFile zipFile = null;
            Map map = null;
            Collection collection = null;
            Map map2 = null;
            Map map3 = null;
            Map map4 = null;
            Map map5 = null;
            Map map6 = null;
            Map map7 = null;
            zipFile = new ZipFile(wbFile);
            ZipEntry zipEntry = zipFile.getEntry(OBJECTS_ENTRY);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            map = (Map)objectInputStream.readObject();
            zipEntry = zipFile.getEntry(NAMESPACES_ENTRY);
            inputStream = zipFile.getInputStream(zipEntry);
            objectInputStream = new ObjectInputStream(inputStream);
            collection = (Collection)objectInputStream.readObject();
            zipEntry = zipFile.getEntry(REFERENCED_TABLES_ENTRY);
            if (zipEntry != null) {
                inputStream = zipFile.getInputStream(zipEntry);
                objectInputStream = new ObjectInputStream(inputStream);
                map2 = (Map)objectInputStream.readObject();
            }
            if ((zipEntry = zipFile.getEntry(REFERENCING_TABLES_ENTRY)) != null) {
                inputStream = zipFile.getInputStream(zipEntry);
                objectInputStream = new ObjectInputStream(inputStream);
                map3 = (Map)objectInputStream.readObject();
            }
            if ((zipEntry = zipFile.getEntry(PROCEDURES_ENTRY)) != null) {
                inputStream = zipFile.getInputStream(zipEntry);
                objectInputStream = new ObjectInputStream(inputStream);
                map4 = (Map)objectInputStream.readObject();
            }
            if ((zipEntry = zipFile.getEntry(SYNONYMS_ENTRY)) != null) {
                inputStream = zipFile.getInputStream(zipEntry);
                objectInputStream = new ObjectInputStream(inputStream);
                map5 = (Map)objectInputStream.readObject();
            }
            if ((zipEntry = zipFile.getEntry(INDEX_ENTRY)) != null) {
                inputStream = zipFile.getInputStream(zipEntry);
                objectInputStream = new ObjectInputStream(inputStream);
                map6 = (Map)objectInputStream.readObject();
            }
            if ((zipEntry = zipFile.getEntry(PK_ENTRY)) != null) {
                inputStream = zipFile.getInputStream(zipEntry);
                objectInputStream = new ObjectInputStream(inputStream);
                map7 = (Map)objectInputStream.readObject();
            }
            objectCache.initExternally(map, collection, map2, map3, map4, map5, map6, map7);
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                break block22;
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not close local storage file", throwable);
            }
            break block22;
            catch (Throwable throwable) {
                try {
                    LogMgr.logError(new CallerInfo(){}, "Could not read local storage", throwable);
                    wbFile.delete();
                }
                catch (Throwable throwable2) {
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        LogMgr.logError(new /* invalid duplicate definition of identical inner class */, "Could not close local storage file", throwable3);
                    }
                    throw throwable2;
                }
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (Throwable throwable4) {
                    LogMgr.logError(new /* invalid duplicate definition of identical inner class */, "Could not close local storage file", throwable4);
                }
            }
        }
    }

    void deleteCacheFile(String string, String string2) {
        WbFile wbFile = this.getCacheFile(string, string2);
        try {
            if (wbFile.delete()) {
                LogMgr.logInfo(new CallerInfo(){}, "Deleted local storage file: " + wbFile.getFullPath());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void saveToLocalFile(ObjectCache objectCache, WbConnection wbConnection) {
        WbFile wbFile;
        block11: {
            if (wbConnection == null || objectCache == null) {
                return;
            }
            wbFile = this.getCacheFile(wbConnection);
            FileOutputStream fileOutputStream = null;
            ZipOutputStream zipOutputStream = null;
            fileOutputStream = new FileOutputStream(wbFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            zipOutputStream.setLevel(9);
            Map<TableIdentifier, List<ColumnIdentifier>> map = objectCache.getObjects();
            this.writeObject(zipOutputStream, OBJECTS_ENTRY, map);
            Collection<Namespace> collection = objectCache.getNamespacesInCache();
            this.writeObject(zipOutputStream, NAMESPACES_ENTRY, collection);
            Map<TableIdentifier, List<DependencyNode>> map2 = objectCache.getReferencedTables();
            this.writeObject(zipOutputStream, REFERENCED_TABLES_ENTRY, map2);
            Map<TableIdentifier, List<DependencyNode>> map3 = objectCache.getReferencingTables();
            this.writeObject(zipOutputStream, REFERENCING_TABLES_ENTRY, map3);
            Map<String, List<ProcedureDefinition>> map4 = objectCache.getProcedures();
            this.writeObject(zipOutputStream, PROCEDURES_ENTRY, map4);
            Map<TableIdentifier, TableIdentifier> map5 = objectCache.getSynonyms();
            this.writeObject(zipOutputStream, SYNONYMS_ENTRY, map5);
            Map<TableIdentifier, List<IndexDefinition>> map6 = objectCache.getIndexes();
            this.writeObject(zipOutputStream, INDEX_ENTRY, map6);
            Map<TableIdentifier, PkDefinition> map7 = objectCache.getPKMap();
            this.writeObject(zipOutputStream, PK_ENTRY, map7);
            try {
                zipOutputStream.close();
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not close ZIP archive", exception);
                wbFile.delete();
            }
            break block11;
            catch (Exception exception) {
                try {
                    LogMgr.logError(new CallerInfo(){}, "Could not write cache file", exception);
                    wbFile.delete();
                }
                catch (Throwable throwable) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (Exception exception2) {
                        LogMgr.logError(new /* invalid duplicate definition of identical inner class */, "Could not close ZIP archive", exception2);
                        wbFile.delete();
                    }
                    throw throwable;
                }
                try {
                    zipOutputStream.close();
                }
                catch (Exception exception3) {
                    LogMgr.logError(new /* invalid duplicate definition of identical inner class */, "Could not close ZIP archive", exception3);
                    wbFile.delete();
                }
            }
        }
        LogMgr.logDebug(new CallerInfo(){}, "Current object cache written to: " + wbFile.getFullPath());
    }

    private void writeObject(ZipOutputStream zipOutputStream, String string, Object object) throws IOException {
        try {
            zipOutputStream.putNextEntry(new ZipEntry(string));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(zipOutputStream);
            objectOutputStream.writeObject(object);
            zipOutputStream.closeEntry();
        }
        catch (InvalidClassException | NotSerializableException objectStreamException) {
            LogMgr.logError(new CallerInfo(){}, "Could not write cache entry: " + string, objectStreamException);
        }
    }

    private WbFile getCacheFile(WbConnection wbConnection) {
        return this.getCacheFile(wbConnection.getUrl(), wbConnection.getDisplayUser());
    }

    private WbFile getCacheFile(String string, String string2) {
        String string3 = ConnectionProfile.makeFilename(string, string2);
        WbFile wbFile = new WbFile(Settings.getInstance().getConfigDir());
        String string4 = Settings.getInstance().getProperty("workbench.gui.completioncache.localstorage.cachedir", ".cache");
        WbFile wbFile2 = new WbFile(string4);
        WbFile wbFile3 = null;
        wbFile3 = wbFile2.isAbsolute() ? wbFile2 : new WbFile(wbFile, string4);
        if (!wbFile3.exists()) {
            if (wbFile3.mkdirs()) {
                LogMgr.logInfo(new CallerInfo(){}, "Created cache directory for local cache storage: " + wbFile3.getFullPath());
            } else {
                LogMgr.logWarning(new CallerInfo(){}, "Could not create cache directory \"" + wbFile3.getFullPath() + "\". Using config directory: " + wbFile.getFullPath());
                wbFile3 = wbFile;
            }
        }
        return new WbFile(wbFile3, string3 + ".wbcache");
    }
}

