/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.FormatFileWriter;
import workbench.db.exporter.RowDataConverter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.ResultInfo;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.SqlUtil;
import workbench.util.WbFile;

public class OracleControlFileWriter
implements FormatFileWriter {
    private boolean useFullFilepath;
    private final Map<String, String> encodingMap = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);

    public OracleControlFileWriter() {
        this.encodingMap.put("UTF8", "AL32UTF8");
        this.encodingMap.put("UTF-8", "AL32UTF8");
        this.encodingMap.put("ISO-8859-1", "WE8ISO8859P1");
        this.encodingMap.put("ISO-8859-15", "WE8ISO8859P15");
        this.encodingMap.put("ISO-8859-10", "NE8ISO8859P10");
        this.encodingMap.put("ISO-8859-5", "CL8ISO8859P5");
        this.encodingMap.put("ISO-8859-5", "CL8ISO8859P5");
        this.encodingMap.put("windows-1250", "EE8MSWIN1250");
        this.encodingMap.put("windows-1253", "EL8MSWIN1253");
        this.encodingMap.put("ISO-2022-JP", "ISO2022-JP");
        this.encodingMap.put("ISO-2022-CN", "ISO2022-CN");
        this.encodingMap.put("ISO-2022-KR", "ISO2022-KR");
        this.encodingMap.put("UTF-16BE", "AL16UTF16");
        List<String> list = Settings.getInstance().getListProperty("workbench.db.oracle.encodingmap", false, null);
        for (String string : list) {
            String[] stringArray = string.split(":");
            if (stringArray.length != 2) continue;
            this.encodingMap.put(stringArray[0], stringArray[1]);
        }
    }

    @Override
    public void setUseFullFilepath(boolean bl) {
        this.useFullFilepath = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFormatFile(DataExporter dataExporter, RowDataConverter rowDataConverter) {
        ResultInfo resultInfo = rowDataConverter.getResultInfo();
        WbFile wbFile = dataExporter.getOutputFile();
        String string = wbFile.getParent();
        String string2 = wbFile.getFileName();
        File file = new File(string, string2 + ".ctl");
        PrintWriter printWriter = null;
        try {
            String string3;
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("-- Please review these options to fit your needs");
            if (dataExporter.getExportHeaders()) {
                printWriter.println("OPTIONS (skip=1, direct=true, rows=10000, silent=(feedback) )");
            } else {
                printWriter.println("OPTIONS (direct=true, rows=10000, silent=(feedback) )");
            }
            printWriter.println("-- The specified characterset might not be correct, please check the Oracle documentation");
            printWriter.print("LOAD DATA CHARACTERSET '");
            printWriter.println(this.convertJavaCharsetToOracle(dataExporter.getEncoding()) + "'");
            printWriter.println("INFILE '" + (this.useFullFilepath ? wbFile.getFullPath() : wbFile.getName()) + "'");
            printWriter.println("-- to replace the data in the table use TRUNCATE instead of APPEND");
            printWriter.println("APPEND");
            printWriter.print("INTO TABLE ");
            String string4 = dataExporter.getTableNameToUse();
            printWriter.println(string4);
            printWriter.print("FIELDS TERMINATED BY '");
            printWriter.print(this.convertDelimiter(dataExporter.getTextDelimiter()));
            printWriter.println("' TRAILING NULLCOLS");
            printWriter.println("(");
            int n = resultInfo.getColumnCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = resultInfo.getColumnName(i).length();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            ++n2;
            String string5 = dataExporter.getTimestampFormat();
            if (string5 == null) {
                string5 = Settings.getInstance().getDefaultTimestampFormat();
            }
            String string6 = this.convertJavaDateFormatToOracle(string5);
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = dataExporter.getWriteClobAsFile();
            for (int i = 0; i < n; ++i) {
                int n4;
                string3 = resultInfo.getColumnName(i);
                int n5 = resultInfo.getColumnType(i);
                String string7 = resultInfo.getDbmsTypeName(i);
                printWriter.print("  ");
                if (SqlUtil.isBlobType(n5) || bl && SqlUtil.isClobType(n5, string7, dataExporter.getConnection().getDbSettings())) {
                    arrayList.add(string3);
                    printWriter.print("lob_file_" + string3.toLowerCase() + " FILLER");
                } else {
                    printWriter.print(string3);
                }
                if (SqlUtil.isDateType(n5)) {
                    for (n4 = string3.length(); n4 < n2; ++n4) {
                        printWriter.print(" ");
                    }
                    printWriter.print("DATE");
                    if (string5 != null) {
                        printWriter.print(" \"");
                        printWriter.print(string6);
                        printWriter.print("\"");
                    }
                } else if (SqlUtil.isNumberType(n5) && i == n - 1) {
                    for (n4 = string3.length(); n4 < n2; ++n4) {
                        printWriter.print(" ");
                    }
                    printWriter.print("TERMINATED BY WHITESPACE");
                }
                if (i < n - 1 || arrayList.size() > 0) {
                    printWriter.print(",");
                }
                printWriter.println();
            }
            if (arrayList.size() > 0) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string3 = (String)iterator.next();
                    printWriter.print("  ");
                    printWriter.print(string3);
                    printWriter.print(" LOBFILE(lob_file_" + string3.toLowerCase() + ") TERMINATED BY EOF");
                    if (iterator.hasNext()) {
                        printWriter.print(",");
                    }
                    printWriter.println();
                }
            }
            printWriter.print(")");
        }
        catch (IOException iOException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Error opening outputfile", iOException);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(printWriter);
                throw throwable;
            }
            FileUtil.closeQuietely(printWriter);
        }
        FileUtil.closeQuietely(printWriter);
    }

    private String convertDelimiter(String string) {
        string = string.replace("\t", "\\t");
        string = string.replace("\r", "\\r");
        string = string.replace("\n", "\\n");
        return string;
    }

    private String convertJavaCharsetToOracle(String string) {
        if (string == null) {
            return Settings.getInstance().getDefaultFileEncoding();
        }
        String string2 = this.encodingMap.get(string = EncodingUtil.cleanupEncoding(string));
        if (string2 != null) {
            return string2;
        }
        return string.toUpperCase();
    }

    private String convertJavaDateFormatToOracle(String string) {
        String string2 = string.replace("HH", "HH24");
        string2 = string2.replace("hh", "HH12");
        string2 = string2.replace("mm", "MI");
        string2 = string2.replace("yy", "YY");
        string2 = string2.replace("dd", "DD");
        string2 = string2.replace("ss", "SS");
        return string2;
    }
}

