/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import workbench.db.ErrorInformationReader;
import workbench.db.JdbcUtils;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.ErrorDescriptor;
import workbench.util.CollectionUtil;
import workbench.util.SqlParsingUtil;
import workbench.util.StringUtil;

public class OracleErrorInformationReader
implements ErrorInformationReader {
    private WbConnection connection;
    private Set<String> validTypes = CollectionUtil.caseInsensitiveSet("VIEW", "PROCEDURE", "FUNCTION", "PACKAGE", "PACKAGE BODY", "TRIGGER", "TYPE", "TYPE BODY", "LIBRARY", "JAVA SOURCE", "JAVA CLASS", "DIMENSION");

    public OracleErrorInformationReader(WbConnection wbConnection) {
        this.connection = wbConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorDescriptor getErrorInfo(String string, String string2, String string3, String string4, boolean bl) {
        if (StringUtil.isEmptyString(string3)) {
            return null;
        }
        if (string4 != null && !this.validTypes.contains(string4)) {
            return null;
        }
        String string5 = "-- SQL Workbench \nSELECT line, position, text, name, type \nFROM all_errors \nWHERE owner = ? \n";
        int n = -1;
        int n2 = -1;
        if (string4 != null) {
            string5 = string5 + " and type = ? \n";
            n = 2;
        }
        if (string3 != null) {
            string5 = string5 + "  and name = ? \n";
            n2 = n == -1 ? 2 : 3;
        }
        string5 = string5 + " ORDER BY type, name, line, position";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        StringBuilder stringBuilder = new StringBuilder(250);
        ErrorDescriptor errorDescriptor = null;
        TableIdentifier tableIdentifier = new TableIdentifier(string3);
        tableIdentifier.adjustCase(this.connection);
        String string6 = string2 == null ? tableIdentifier.getRawSchema() : string2;
        String string7 = tableIdentifier.getRawTableName();
        String string8 = string4 == null ? null : string4.toUpperCase().trim();
        try {
            if (string6 == null) {
                string6 = this.connection.getMetadata().getCurrentSchema();
            }
            preparedStatement = this.connection.getSqlConnection().prepareStatement(string5);
            preparedStatement.setString(1, string6);
            if (n > -1) {
                preparedStatement.setString(n, string8);
            }
            if (n2 > -1) {
                preparedStatement.setString(n2, string7);
            }
            LogMgr.logMetadataSql(new CallerInfo(){}, "error information", string5, string6, string8, string7);
            resultSet = preparedStatement.executeQuery();
            int n3 = 0;
            String string9 = null;
            boolean bl2 = true;
            int n4 = 15;
            String string10 = StringUtil.padRight("", n4);
            while (resultSet.next()) {
                String string11;
                if (n3 == 0) {
                    errorDescriptor = new ErrorDescriptor();
                } else {
                    stringBuilder.append("\n");
                }
                int n5 = resultSet.getInt(1);
                int n6 = resultSet.getInt(2);
                String string12 = resultSet.getString(3);
                String string13 = resultSet.getString(4);
                String string14 = resultSet.getString(5);
                if (bl2 && !string12.contains("PL/SQL: SQL Statement ignored")) {
                    bl2 = false;
                    errorDescriptor.setErrorPosition(n5 - 1, n6 - 1);
                    errorDescriptor.setInStatementOffset(this.getRealStart(string14, string));
                }
                if (bl && (string9 == null || !string9.equals(string13))) {
                    string11 = ResourceMgr.getFormattedString("ErrForObject", string14, string13);
                    String string15 = StringUtil.padRight("", string11.length(), '-');
                    stringBuilder.append(string11);
                    stringBuilder.append('\n');
                    stringBuilder.append(string15);
                    stringBuilder.append("\n");
                    string9 = string13;
                }
                string11 = ResourceMgr.getFormattedString("ErrAtLinePos", n5, n6);
                string11 = StringUtil.padRight(string11, n4);
                stringBuilder.append(string11);
                string12 = string12.trim().replace("\n\n", "\n");
                string12 = string12.replaceAll("((\r\n)|(\n\r)|\r|\n)", "\n" + string10);
                stringBuilder.append(string12);
                ++n3;
            }
        }
        catch (SQLException sQLException) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "error information", string5, string6, string8, string7);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        if (errorDescriptor != null) {
            errorDescriptor.setErrorMessage(stringBuilder.toString());
        }
        return errorDescriptor;
    }

    private int getRealStart(String string, String string2) {
        if (string2 == null) {
            return 0;
        }
        if (!"trigger".equalsIgnoreCase(string)) {
            return 0;
        }
        SqlParsingUtil sqlParsingUtil = SqlParsingUtil.getInstance(this.connection);
        int n = sqlParsingUtil.getKeywordPosition("BEGIN", (CharSequence)string2);
        if (n > 0) {
            return n;
        }
        return 0;
    }
}

