/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import workbench.db.JdbcUtils;
import workbench.db.SynonymReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.DbmsMetadata;
import workbench.db.oracle.OracleUtils;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;

public class OracleSynonymReader
implements SynonymReader {
    @Override
    public List<TableIdentifier> getSynonymList(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableIdentifier getSynonymTable(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        TableIdentifier tableIdentifier;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block7: {
            boolean bl = wbConnection.getDbSettings().getBoolProperty("synonym.target.retrieve.comments", false);
            if (bl) {
                bl = OracleUtils.getRemarksReporting(wbConnection);
            }
            String string4 = "-- SQL Workbench \nSELECT s.synonym_name, s.table_owner, s.table_name, s.db_link, o.object_type, s.owner";
            if (bl) {
                string4 = string4 + ", case     when o.owner IN ('PUBLIC','SYS','SYSTEM') then null     else (select tc.comments from all_tab_comments tc where tc.table_name = o.object_name AND tc.owner = o.owner AND rownum <= 1)   end as comments ";
            }
            string4 = string4 + "\nFROM all_synonyms s \n  LEFT JOIN all_objects o ON s.table_name = o.object_name AND s.table_owner = o.owner  \n";
            string4 = string4 + "WHERE ((s.synonym_name = ? AND s.owner = ?)  \n    OR (s.synonym_name = ? AND s.owner = 'PUBLIC'))  \nORDER BY decode(s.owner, 'PUBLIC',9,1)";
            if (string2 == null) {
                string2 = wbConnection.getCurrentUser();
            }
            LogMgr.logMetadataSql(new CallerInfo(){}, "synonym table", string4, string3, string2, string3);
            preparedStatement = null;
            resultSet = null;
            tableIdentifier = null;
            try {
                preparedStatement = wbConnection.getSqlConnection().prepareStatement(string4);
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block7;
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                String string7 = resultSet.getString(4);
                String string8 = resultSet.getString(5);
                if (string7 != null) {
                    string6 = string6 + "@" + string7;
                }
                tableIdentifier = new TableIdentifier(null, string5, string6, false);
                tableIdentifier.setNeverAdjustCase(true);
                tableIdentifier.setType(string8);
                if (bl) {
                    String string9 = resultSet.getString(6);
                    tableIdentifier.setComment(string9);
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return tableIdentifier;
    }

    @Override
    public String getSynonymSource(WbConnection wbConnection, String string, String string2, String string3) throws SQLException {
        if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.synonym)) {
            try {
                return DbmsMetadata.getDDL(wbConnection, "SYNONYM", string3, string2);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        TableIdentifier tableIdentifier = this.getSynonymTable(wbConnection, string, string2, string3);
        StringBuilder stringBuilder = new StringBuilder(200);
        String string4 = Settings.getInstance().getInternalEditorLineEnding();
        if (this.supportsReplace(wbConnection)) {
            stringBuilder.append("CREATE OR REPLACE SYNONYM ");
        } else {
            stringBuilder.append("CREATE SYNONYM ");
        }
        TableIdentifier tableIdentifier2 = new TableIdentifier(string2, string3);
        stringBuilder.append(tableIdentifier2.getTableExpression(wbConnection));
        stringBuilder.append(string4 + "   FOR ");
        stringBuilder.append(tableIdentifier.getTableExpression(wbConnection));
        stringBuilder.append(';');
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    @Override
    public boolean supportsReplace(WbConnection wbConnection) {
        return JdbcUtils.hasMinimumServerVersion(wbConnection, "10.0");
    }
}

