/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.oracle;

import java.sql.SQLException;
import workbench.db.DefaultViewReader;
import workbench.db.DropType;
import workbench.db.NoConfigException;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.oracle.DbmsMetadata;
import workbench.db.oracle.OracleMViewReader;
import workbench.db.oracle.OracleUtils;

public class OracleViewReader
extends DefaultViewReader {
    public OracleViewReader(WbConnection wbConnection) {
        super(wbConnection);
    }

    @Override
    public CharSequence getExtendedViewSource(TableDefinition tableDefinition, DropType dropType, boolean bl) throws SQLException {
        String string = tableDefinition.getTable().getType();
        if ("MATERIALIZED VIEW".equals(string)) {
            OracleMViewReader oracleMViewReader = new OracleMViewReader();
            CharSequence charSequence = oracleMViewReader.getMViewSource(this.connection, tableDefinition, null, dropType, true);
            return charSequence;
        }
        return super.getExtendedViewSource(tableDefinition, dropType, bl);
    }

    @Override
    public CharSequence getViewSource(TableIdentifier tableIdentifier) throws NoConfigException {
        if ("MATERIALIZED VIEW".equalsIgnoreCase(tableIdentifier.getType())) {
            OracleMViewReader oracleMViewReader = new OracleMViewReader();
            CharSequence charSequence = oracleMViewReader.getMViewSource(this.connection, new TableDefinition(tableIdentifier), null, DropType.none, false);
            return charSequence;
        }
        if (OracleUtils.getUseOracleDBMSMeta(OracleUtils.DbmsMetadataTypes.view)) {
            try {
                return DbmsMetadata.getDDL(this.connection, "VIEW", tableIdentifier.getRawTableName(), tableIdentifier.getRawSchema());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return super.getViewSource(tableIdentifier);
    }
}

