/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.util.HashMap;
import java.util.Map;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class HstoreSupport {
    public static String getDisplay(Map<String, String> map) {
        return HstoreSupport.toString(map, false);
    }

    public static String getLiteral(Map<String, String> map) {
        return HstoreSupport.toString(map, true);
    }

    private static String toString(Map<String, String> map, boolean bl) {
        if (CollectionUtil.isEmpty(map)) {
            return "";
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(map.size() * 20);
        if (bl) {
            stringBuilder.append('\'');
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            HstoreSupport.appendHstoreValue(stringBuilder, entry.getKey(), bl);
            stringBuilder.append("=>");
            HstoreSupport.appendHstoreValue(stringBuilder, entry.getValue(), bl);
            ++n;
        }
        if (bl) {
            stringBuilder.append("'::hstore");
        }
        return stringBuilder.toString();
    }

    private static void appendHstoreValue(StringBuilder stringBuilder, String string, boolean bl) {
        if (string == null) {
            stringBuilder.append("NULL");
            return;
        }
        stringBuilder.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl && c == '\'') {
                stringBuilder.append('\'');
            } else if (c == '\"' || c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
    }

    public static Map<String, String> parseLiteral(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if ((string = StringUtil.trimToNull(string)) == null) {
            return null;
        }
        int n = string.length();
        if (n < 4) {
            return hashMap;
        }
        if (string.toLowerCase().endsWith("::hstore")) {
            string = string.substring(0, string.indexOf("::"));
        }
        n = string.length();
        if (string.indexOf("=>") < 0) {
            return hashMap;
        }
        if (string.charAt(0) == '\'' && string.charAt(n - 1) == '\'') {
            string = string.substring(1, n - 1);
        }
        n = string.length();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 1;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"' && n5 != 92) {
                if (bl) {
                    n4 = i;
                } else {
                    n3 = i + 1;
                    bl2 = true;
                }
            }
            if (c == '\"' && n5 != 92) {
                boolean bl3 = bl = !bl;
            }
            if (n2 == 1 && c == '>' && n5 == 61 && !bl) {
                string2 = string.substring(n3, n4 == -1 ? i - 1 : n4);
                n2 = 2;
                n3 = i + 1;
                n4 = -1;
                bl2 = false;
            } else if (!bl && c == ',' && n2 == 2 || i == n - 1) {
                int n6 = n4;
                if (n6 < 0) {
                    int n7 = n6 = i == n - 1 ? n : i;
                }
                if ("null".equalsIgnoreCase(string3 = string.substring(n3, n6)) && !bl2) {
                    string3 = null;
                }
                n2 = 1;
                hashMap.put(HstoreSupport.unescape(string2), HstoreSupport.unescape(string3));
                bl2 = false;
                n4 = 0;
                string3 = null;
                string2 = null;
            }
            n5 = c;
        }
        return hashMap;
    }

    private static String unescape(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

