/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.ProcedureDefinition;
import workbench.db.postgres.PGArg;
import workbench.db.postgres.PGType;
import workbench.db.postgres.PGTypeLookup;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class PGProcName
implements Comparable<PGProcName> {
    private List<PGArg> arguments;
    private String procName;

    public PGProcName(ProcedureDefinition procedureDefinition, PGTypeLookup pGTypeLookup) {
        this.procName = procedureDefinition.getProcedureName();
        List<ColumnIdentifier> list = procedureDefinition.getParameters(null);
        if (CollectionUtil.isNonEmpty(list)) {
            this.arguments = new ArrayList<PGArg>(list.size());
            for (ColumnIdentifier columnIdentifier : list) {
                String string = columnIdentifier.getArgumentMode();
                PGType pGType = pGTypeLookup.getEntryByType(columnIdentifier.getDbmsType());
                if (pGType == null) {
                    pGType = new PGType(columnIdentifier.getDbmsType(), -1L);
                }
                PGArg pGArg = new PGArg(pGType, string);
                this.arguments.add(pGArg);
            }
        } else {
            this.initFromDisplayName(procedureDefinition.getDisplayName(), pGTypeLookup);
        }
    }

    public PGProcName(String string, PGTypeLookup pGTypeLookup) {
        this.initFromDisplayName(string, pGTypeLookup);
    }

    private void initFromDisplayName(String string, PGTypeLookup pGTypeLookup) {
        int n = string.indexOf(40);
        if (n > -1) {
            this.procName = string.substring(0, n);
            String string2 = string.substring(n + 1, string.indexOf(41));
            String[] stringArray = string2.split(",");
            this.arguments = new ArrayList<PGArg>();
            for (String string3 : stringArray) {
                PGType pGType = pGTypeLookup.getEntryByType(string3.trim());
                if (pGType == null) continue;
                PGArg pGArg = new PGArg(pGType, "in");
                this.arguments.add(pGArg);
            }
        } else {
            this.procName = string;
            this.arguments = Collections.emptyList();
        }
    }

    public PGProcName(String string, String string2, String string3, PGTypeLookup pGTypeLookup) {
        this.procName = string;
        if (StringUtil.isNonBlank(string2)) {
            this.arguments = this.getTypesFromOid(string2, string3, pGTypeLookup);
        }
    }

    private List<PGArg> getTypesFromOid(String string, String string2, PGTypeLookup pGTypeLookup) {
        String[] stringArray = string.split(";");
        String[] stringArray2 = string2.split(";");
        ArrayList<PGArg> arrayList = new ArrayList<PGArg>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Long l;
            PGType pGType;
            String string3;
            String string4 = stringArray[i];
            String string5 = string3 = i < stringArray2.length ? stringArray2[i] : null;
            if ("t".equals(string3) || (pGType = pGTypeLookup.getTypeFromOID(l = Long.valueOf(string4.trim()))) == null) continue;
            PGArg pGArg = new PGArg(pGType, string3);
            arrayList.add(pGArg);
        }
        return arrayList;
    }

    public String getInputOIDs() {
        if (this.arguments == null || this.arguments.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.arguments.size() * 4);
        int n = 0;
        for (PGArg pGArg : this.arguments) {
            if (pGArg.argMode != PGArg.ArgMode.in && pGArg.argMode != PGArg.ArgMode.inout) continue;
            if (n > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Long.toString(pGArg.argType.getOid()));
            ++n;
        }
        return stringBuilder.toString();
    }

    public String getOIDs() {
        if (this.arguments == null || this.arguments.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.arguments.size() * 4);
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Long.toString(this.arguments.get((int)i).argType.getOid()));
        }
        return stringBuilder.toString();
    }

    List<PGArg> getArguments() {
        return this.arguments;
    }

    @Override
    public int compareTo(PGProcName pGProcName) {
        return this.getFormattedName().compareTo(pGProcName.getFormattedName());
    }

    public String getName() {
        return this.procName;
    }

    public String getSignature() {
        if (this.arguments == null || this.arguments.isEmpty()) {
            return this.procName + "()";
        }
        StringBuilder stringBuilder = new StringBuilder(this.procName.length() + this.arguments.size() * 10);
        stringBuilder.append(this.procName);
        stringBuilder.append('(');
        int n = 0;
        for (PGArg pGArg : this.arguments) {
            if (pGArg.argMode != PGArg.ArgMode.in && pGArg.argMode != PGArg.ArgMode.inout) continue;
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(pGArg.argType.getTypeName());
            ++n;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String getFormattedName() {
        if (this.arguments == null || this.arguments.isEmpty()) {
            return this.procName + "()";
        }
        StringBuilder stringBuilder = new StringBuilder(this.procName.length() + this.arguments.size() * 10);
        stringBuilder.append(this.procName);
        stringBuilder.append('(');
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.arguments.get((int)i).argType.getTypeName());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getFormattedName();
    }

    public boolean equals(Object object) {
        if (object instanceof PGProcName) {
            PGProcName pGProcName = (PGProcName)object;
            String string = this.getFormattedName();
            String string2 = pGProcName.getFormattedName();
            return string.equals(string2);
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 79 * n + (this.arguments != null ? this.arguments.hashCode() : 0);
        n = 79 * n + (this.procName != null ? this.procName.hashCode() : 0);
        return n;
    }
}

