/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.io.Serializable;
import workbench.db.BaseObjectType;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class PgRangeType
extends BaseObjectType
implements Serializable {
    public static final String RANGE_TYPE_NAME = "RANGE TYPE";
    private String dataType;

    public PgRangeType(String string, String string2) {
        super(string, string2);
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    @Override
    public String getObjectType() {
        return RANGE_TYPE_NAME;
    }

    @Override
    public String getObjectExpression(WbConnection wbConnection) {
        return SqlUtil.buildExpression(wbConnection, this);
    }

    @Override
    public String toString() {
        return this.getObjectName();
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        String string = "DROP TYPE %name%";
        if (wbConnection != null) {
            string = wbConnection.getDbSettings().getDropDDL("TYPE", bl);
        } else if (bl) {
            string = string + " CASCADE";
        }
        string = string.replace("%name%", this.getFullyQualifiedName(wbConnection));
        return string;
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public boolean isComparableWith(DbObject dbObject) {
        return dbObject instanceof PgRangeType;
    }

    @Override
    public boolean isEqualTo(DbObject dbObject) {
        if (dbObject instanceof PgRangeType) {
            String string = dbObject.getObjectName();
            String string2 = dbObject.getSchema();
            String string3 = ((PgRangeType)dbObject).dataType;
            return StringUtil.equalString(this.getObjectName(), string) && StringUtil.equalString(this.getSchema(), string2) && StringUtil.equalString(this.dataType, string3);
        }
        return false;
    }
}

