/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.sql.SQLException;
import workbench.db.TableIdentifier;
import workbench.db.TablePartition;
import workbench.db.WbConnection;
import workbench.db.postgres.PostgresPartitionReader;

public class PostgresPartition
extends TablePartition {
    private String subPartitionDefinition;
    private TableIdentifier parentPartition;
    private final TableIdentifier baseTable;

    public PostgresPartition(TableIdentifier tableIdentifier, String string, String string2) {
        this.baseTable = tableIdentifier;
        this.setName(string2);
        this.setSchema(string);
    }

    public String getSubPartitionDefinition() {
        return this.subPartitionDefinition;
    }

    public void setSubPartitionDefinition(String string) {
        this.subPartitionDefinition = string;
    }

    @Override
    public CharSequence getSource(WbConnection wbConnection) throws SQLException {
        return PostgresPartitionReader.generatePartitionDDL(this, this.baseTable.getTableExpression(wbConnection), wbConnection);
    }

    @Override
    public String getObjectNameForDrop(WbConnection wbConnection) {
        return this.getFullyQualifiedName(wbConnection);
    }

    @Override
    public String getDropStatement(WbConnection wbConnection, boolean bl) {
        TableIdentifier tableIdentifier = new TableIdentifier(null, this.getSchema(), this.getObjectName());
        return tableIdentifier.getDropStatement(wbConnection, bl);
    }

    @Override
    public boolean supportsGetSource() {
        return true;
    }

    @Override
    public boolean isSubPartition() {
        return this.parentPartition != null;
    }

    public TableIdentifier getParentTable() {
        return this.parentPartition;
    }

    public void setParentTable(TableIdentifier tableIdentifier) {
        this.parentPartition = tableIdentifier;
    }
}

