/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.postgres;

import java.lang.reflect.Method;
import java.sql.Connection;
import workbench.db.DefaultTransactionChecker;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;

public class PostgresTransactionChecker
extends DefaultTransactionChecker {
    private boolean usePgTransactionState = Settings.getInstance().getBoolProperty("workbench.db.postgresql.transactioncheck.driver", true);

    public PostgresTransactionChecker(String string) {
        super(string);
    }

    @Override
    public boolean hasUncommittedChanges(WbConnection wbConnection) {
        Boolean bl;
        if (wbConnection.isClosed()) {
            return false;
        }
        if (wbConnection.getAutoCommit()) {
            return false;
        }
        if (this.usePgTransactionState && (bl = this.isStateOpen(wbConnection)) != null) {
            return bl;
        }
        return super.hasUncommittedChanges(wbConnection);
    }

    private Boolean isStateOpen(WbConnection wbConnection) {
        try {
            long l = System.currentTimeMillis();
            Connection connection = wbConnection.getSqlConnection();
            Method method = connection.getClass().getMethod("getTransactionState", new Class[0]);
            Object object = method.invoke((Object)connection, new Object[0]);
            if (object == null) {
                return null;
            }
            long l2 = System.currentTimeMillis() - l;
            LogMgr.logDebug(new CallerInfo(){}, "Calling PGConnection.getTransactionState() took: " + l2 + "ms");
            return object.toString().equalsIgnoreCase("open");
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Could not read TransactionState from PgConnection", throwable);
            this.usePgTransactionState = false;
            return null;
        }
    }
}

