/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.progress;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TreeMap;
import workbench.db.DBID;
import workbench.db.JdbcUtils;
import workbench.db.ObjectListEnhancer;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.StringUtil;

public class OpenEdgeObjectListEnhancer
implements ObjectListEnhancer {
    @Override
    public void updateObjectList(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3, String[] stringArray) {
        if (Settings.getInstance().getBoolProperty("workbench.db." + DBID.OPENEDGE.getId() + ".remarks.object.retrieve", false)) {
            this.updateObjectRemarks(wbConnection, dataStore, string, string2, string3);
        }
    }

    protected void updateObjectRemarks(WbConnection wbConnection, DataStore dataStore, String string, String string2, String string3) {
        if (dataStore == null) {
            return;
        }
        if (dataStore.getRowCount() == 0) {
            return;
        }
        String string4 = null;
        if (dataStore.getRowCount() == 1) {
            string4 = dataStore.getValueAsString(0, 0);
        }
        Map<String, String> map = this.readRemarks(wbConnection, string2, string4);
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string5 = dataStore.getValueAsString(i, 0);
            String string6 = dataStore.getValueAsString(i, 3);
            String string7 = map.get(string6 + "." + string5);
            if (string7 == null) continue;
            dataStore.setValue(i, 4, (Object)string7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> readRemarks(WbConnection wbConnection, String string, String string2) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        if (string == null) {
            string = wbConnection.getMetadata().getCurrentSchema();
        }
        int n = -1;
        int n2 = -1;
        String string3 = "select owner, tbl, description \nfrom sysprogress.systables_full \nwhere description is not null \n  and description <> '' \n  and tbltype = 'T' \n";
        if (string != null) {
            n = 1;
            string3 = string3 + "and owner = ? \n";
        }
        if (string2 != null) {
            n2 = n == -1 ? 1 : 2;
            string3 = string3 + " and tbl = ? ";
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
        long l = System.currentTimeMillis();
        try {
            LogMgr.logMetadataSql(new CallerInfo(){}, "table remarks", string3, string, string2);
            preparedStatement = wbConnection.getSqlConnection().prepareStatement(string3);
            if (n > 0) {
                preparedStatement.setString(n, string);
            }
            if (n2 > 0) {
                preparedStatement.setString(n2, string2);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                String string5 = resultSet.getString(2);
                String string6 = resultSet.getString(3);
                if (string5 == null || !StringUtil.isNonEmpty(string6)) continue;
                treeMap.put(string4 + "." + string5.trim(), string6);
            }
            JdbcUtils.closeResult(resultSet);
        }
        catch (Exception exception) {
            try {
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "table remarks", string3, string, string2);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        long l2 = System.currentTimeMillis() - l;
        LogMgr.logDebug(new CallerInfo(){}, "Retrieving table remarks took: " + l2 + "ms");
        return treeMap;
    }
}

