/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.redshift;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import workbench.db.ColumnIdentifier;
import workbench.db.JdbcProcedureReader;
import workbench.db.JdbcUtils;
import workbench.db.NoConfigException;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.db.postgres.PGProcName;
import workbench.db.postgres.PGType;
import workbench.db.postgres.PGTypeLookup;
import workbench.db.postgres.PostgresUtil;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.ExceptionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class RedshiftUDFReader
extends JdbcProcedureReader {
    private Map<String, Integer> pgType2Java;
    private PGTypeLookup pgTypes;
    private boolean useJDBC = false;

    public RedshiftUDFReader(WbConnection wbConnection) {
        super(wbConnection);
        try {
            this.useSavepoint = wbConnection.supportsSavepoints();
        }
        catch (Throwable throwable) {
            this.useSavepoint = false;
        }
        this.useJDBC = PostgresUtil.isRedshift(wbConnection);
    }

    @Override
    public void clearCache() {
        if (this.pgTypes != null) {
            this.pgTypes.clear();
            this.pgTypes = null;
        }
    }

    private Map<String, Integer> getJavaTypeMapping() {
        if (this.pgType2Java == null) {
            this.pgType2Java = new HashMap<String, Integer>();
            this.pgType2Java.put("int2", 5);
            this.pgType2Java.put("int4", 4);
            this.pgType2Java.put("integer", 4);
            this.pgType2Java.put("oid", -5);
            this.pgType2Java.put("int8", -5);
            this.pgType2Java.put("money", 8);
            this.pgType2Java.put("numeric", 2);
            this.pgType2Java.put("float4", 7);
            this.pgType2Java.put("float8", 8);
            this.pgType2Java.put("char", 1);
            this.pgType2Java.put("bpchar", 1);
            this.pgType2Java.put("varchar", 12);
            this.pgType2Java.put("text", 12);
            this.pgType2Java.put("name", 12);
            this.pgType2Java.put("bytea", -2);
            this.pgType2Java.put("bool", -7);
            this.pgType2Java.put("bit", -7);
            this.pgType2Java.put("date", 91);
            this.pgType2Java.put("time", 92);
            this.pgType2Java.put("timetz", 92);
            this.pgType2Java.put("timestamp", 93);
            this.pgType2Java.put("timestamptz", 2014);
        }
        return Collections.unmodifiableMap(this.pgType2Java);
    }

    private Integer getJavaType(String string) {
        Integer n = this.getJavaTypeMapping().get(string);
        if (n == null) {
            return 1111;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PGTypeLookup getTypeLookup() {
        block7: {
            if (this.pgTypes != null) break block7;
            HashMap<Long, PGType> hashMap = new HashMap(300);
            Statement statement = null;
            ResultSet resultSet = null;
            Savepoint savepoint = null;
            String string = "select t.oid, format_type(t.oid, null), t.typtype, ns.nspname as schema_name \nfrom pg_type t \n  join pg_namespace ns on ns.oid = t.typnamespace";
            LogMgr.logMetadataSql(new CallerInfo(){}, "type information", string, new Object[0]);
            try {
                if (this.useSavepoint) {
                    savepoint = this.connection.setSavepoint();
                }
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    String string2 = resultSet.getString(2);
                    String string3 = resultSet.getString(3);
                    String string4 = resultSet.getString(4);
                    if (string2.equals("character varying")) {
                        string2 = "varchar";
                    }
                    string2 = this.getFQName(string3, string4, StringUtil.trimQuotes(string2));
                    PGType pGType = new PGType(string2, l);
                    hashMap.put(l, pGType);
                }
                this.connection.releaseSavepoint(savepoint);
            }
            catch (SQLException sQLException) {
                try {
                    this.connection.rollback(savepoint);
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "type information", string, new Object[0]);
                    hashMap = Collections.emptyMap();
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
            JdbcUtils.closeAll(resultSet, statement);
            this.pgTypes = new PGTypeLookup(hashMap);
        }
        return this.pgTypes;
    }

    private String getFQName(String string, String string2, String string3) {
        if ("c".equals(string)) {
            if (string3.indexOf(46) > -1) {
                return string3;
            }
            if (!string3.startsWith(string2)) {
                return string2 + "." + string3;
            }
        }
        return string3;
    }

    private String getTypeNameFromOid(long l) {
        PGType pGType = this.getTypeLookup().getTypeFromOID(l);
        return pGType.getTypeName();
    }

    @Override
    public DataStore getProcedures(String string, String string2, String string3) throws SQLException {
        DataStore dataStore = super.getProcedures(string, string3, string3);
        DataStore dataStore2 = this.buildProcedureListDataStore(this.connection.getMetadata(), true);
        if ("*".equals(string2) || "%".equals(string2)) {
            string2 = null;
        }
        String string4 = null;
        if ("*".equals(string3) || "%".equals(string3)) {
            string4 = null;
        } else if (StringUtil.isNonBlank(string3)) {
            PGProcName pGProcName = new PGProcName(string3, this.getTypeLookup());
            string4 = pGProcName.getName();
        }
        for (int i = 0; i < dataStore.getRowCount(); ++i) {
            String string5 = (String)dataStore.getRow(i).getValue(5);
            String string6 = (String)dataStore.getRow(i).getValue(2);
            String string7 = (String)dataStore.getRow(i).getValue(3);
            String string8 = (String)dataStore.getRow(i).getValue(0);
            String string9 = i > 0 ? (String)dataStore.getRow(i - 1).getValue(0) : "";
            Integer n = (Integer)dataStore.getRow(i).getValue(1);
            String string10 = (String)dataStore.getRow(i).getValue(4);
            ProcedureDefinition procedureDefinition = (ProcedureDefinition)dataStore.getRow(i).getUserObject();
            if (string4 != null && !string5.contains(string4) || string2 != null && !string7.equalsIgnoreCase(string2) || !string.equals(string6) || string9.equals(string8)) continue;
            int n2 = dataStore2.addRow();
            dataStore2.setValue(n2, 5, (Object)string5);
            dataStore2.setValue(n2, 2, (Object)string6);
            dataStore2.setValue(n2, 3, (Object)string7);
            dataStore2.setValue(n2, 0, (Object)string8);
            dataStore2.setValue(n2, 1, (Object)n);
            dataStore2.setValue(n2, 4, (Object)string10);
            dataStore2.getRow(n2).setUserObject(procedureDefinition);
        }
        return dataStore2;
    }

    public ProcedureDefinition createDefinition(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string5 == null) {
            string5 = string4.replaceAll("[0-9]+", "i");
        }
        PGProcName pGProcName = new PGProcName(string2, string4, string5, this.getTypeLookup());
        ProcedureDefinition procedureDefinition = new ProcedureDefinition(null, string, string2, 2);
        List<String> list = StringUtil.stringToList(string3, ";", true, true);
        List<String> list2 = StringUtil.stringToList(string4, ";", true, true);
        List<String> list3 = StringUtil.stringToList(string5, ";", true, true);
        List<ColumnIdentifier> list4 = this.convertToColumns(list, list2, list3);
        procedureDefinition.setParameters(list4);
        procedureDefinition.setDisplayName(pGProcName.getFormattedName());
        procedureDefinition.setInternalIdentifier(string6);
        return procedureDefinition;
    }

    @Override
    public DataStore getProcedureColumns(ProcedureDefinition procedureDefinition) throws SQLException {
        if (!this.useJDBC && Settings.getInstance().getBoolProperty("workbench.db.postgresql.fixproctypes", true) && JdbcUtils.hasMinimumServerVersion(this.connection, "8.4")) {
            PGProcName pGProcName = new PGProcName(procedureDefinition, this.getTypeLookup());
            return this.getColumns(procedureDefinition.getCatalog(), procedureDefinition.getSchema(), pGProcName);
        }
        return super.getProcedureColumns(procedureDefinition.getCatalog(), procedureDefinition.getSchema(), procedureDefinition.getProcedureName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readProcedureSource(ProcedureDefinition procedureDefinition, String string, String string2) throws NoConfigException {
        Statement statement;
        ResultSet resultSet;
        StringBuilder stringBuilder;
        block7: {
            PGProcName pGProcName = new PGProcName(procedureDefinition, this.getTypeLookup());
            String string3 = "SELECT DDL \n FROM ( WITH arguments \n AS \n (SELECT oid, \n        i, \n        arg_name[i] AS argument_name, \n        arg_types[i -1] argument_type \n FROM (SELECT generate_series(1,arg_count) AS i, \n              arg_name, \n              arg_types, \n              oid \n       FROM (SELECT oid, \n                    proargnames arg_name, \n                    proargtypes arg_types, \n                    pronargs arg_count \n             FROM pg_proc \n             WHERE proowner != 1) t) t)  \n      SELECT schemaname,udfname,udfoid,seq,trim (ddl) ddl  \n      FROM (SELECT n.nspname AS schemaname, \n                   p.proname AS udfname, \n                   p.oid AS udfoid, \n                   1000 AS seq, \n                   ('CREATE FUNCTION ' || QUOTE_IDENT(p.proname) || ' \\(')::VARCHAR (MAX) AS ddl  \n      FROM pg_proc p \n   LEFT JOIN pg_namespace n ON n.oid = p.pronamespace \n WHERE p.proowner != 1 \n UNION ALL \n SELECT n.nspname AS schemaname, \n        p.proname AS udfname, \n        p.oid AS udfoid, \n        2000 + nvl(i,0) AS seq, \n        CASE \n          WHEN i = 1 THEN NVL (argument_name,'') || ' ' || format_type (argument_type,NULL) \n          ELSE ',' || NVL (argument_name,'') || ' ' || format_type (argument_type,NULL) \n        END AS ddl \n FROM pg_proc p \n   LEFT JOIN pg_namespace n ON n.oid = p.pronamespace \n   LEFT JOIN arguments a ON a.oid = p.oid \n WHERE p.proowner != 1 \n UNION ALL \n SELECT n.nspname AS schemaname, \n        p.proname AS udfname, \n        p.oid AS udfoid, \n        3000 AS seq, \n        '\\)\\n' AS ddl \n FROM pg_proc p \n   LEFT JOIN pg_namespace n ON n.oid = p.pronamespace \n WHERE p.proowner != 1 \n UNION ALL \n SELECT n.nspname AS schemaname, \n        p.proname AS udfname, \n        p.oid AS udfoid, \n        4000 AS seq, \n        '  RETURNS ' || pg_catalog.format_type(p.prorettype,NULL) || '\\n'AS ddl \n FROM pg_proc p \n   LEFT JOIN pg_namespace n ON n.oid = p.pronamespace \n WHERE p.proowner != 1 \n UNION ALL \n SELECT n.nspname AS schemaname, \n        p.proname AS udfname, \n        p.oid AS udfoid, \n        5000 AS seq, \n        CASE \n          WHEN p.provolatile = 'v' THEN 'VOLATILE\\n' \n          WHEN p.provolatile = 's' THEN 'STABLE\\n' \n          WHEN p.provolatile = 'i' THEN 'IMMUTABLE\\n' \n          ELSE '' \n        END AS ddl \n FROM pg_proc p \n   LEFT JOIN pg_namespace n ON n.oid = p.pronamespace \n WHERE p.proowner != 1 \n UNION ALL \n SELECT n.nspname AS schemaname, \n        p.proname AS udfname, \n        p.oid AS udfoid, \n        6000 AS seq, \n        'AS $$' AS ddl \n FROM pg_proc p \n   LEFT JOIN pg_namespace n ON n.oid = p.pronamespace \n WHERE p.proowner != 1 \n UNION ALL \n SELECT n.nspname AS schemaname, \n        p.proname AS udfname, \n        p.oid AS udfoid, \n        7000 AS seq, \n        p.prosrc AS DDL \n FROM pg_proc p \n   LEFT JOIN pg_namespace n ON n.oid = p.pronamespace \n WHERE p.proowner != 1 \n UNION ALL \n SELECT n.nspname AS schemaname, \n        p.proname AS udfname, \n        p.oid AS udfoid, \n        8000 AS seq, \n        '$$ LANGUAGE ' + lang.lanname || '\\n;\\n\\n' AS ddl \n FROM pg_proc p \n   LEFT JOIN pg_namespace n ON n.oid = p.pronamespace \n   LEFT JOIN (SELECT oid, lanname FROM pg_language) lang ON p.prolang = lang.oid \n WHERE p.proowner != 1)) \n";
            string3 = string3 + "WHERE udfname = '" + pGProcName.getName() + "' \n";
            if (StringUtil.isNonBlank(procedureDefinition.getSchema())) {
                string3 = string3 + "  AND schemaname = '" + procedureDefinition.getSchema() + "' \n";
            }
            string3 = string3 + "  ORDER BY udfoid, seq \n";
            LogMgr.logMetadataSql(new CallerInfo(){}, "procedure source", string3, new Object[0]);
            stringBuilder = new StringBuilder(500);
            resultSet = null;
            Savepoint savepoint = null;
            statement = null;
            try {
                if (this.useSavepoint) {
                    savepoint = this.connection.setSavepoint();
                }
                statement = this.connection.createStatementForQuery();
                resultSet = statement.executeQuery(string3);
                while (resultSet.next()) {
                    stringBuilder.append(resultSet.getString(1));
                }
                this.connection.releaseSavepoint(savepoint);
                if (!StringUtil.isNonBlank(procedureDefinition.getComment())) break block7;
                stringBuilder.append("\nCOMMENT ON FUNCTION ");
                stringBuilder.append(pGProcName.getFormattedName());
                stringBuilder.append(" IS '");
                stringBuilder.append(SqlUtil.escapeQuotes(procedureDefinition.getComment()));
                stringBuilder.append("'\n;\n");
            }
            catch (SQLException sQLException) {
                try {
                    stringBuilder = new StringBuilder(ExceptionUtil.getDisplay(sQLException));
                    this.connection.rollback(savepoint);
                    LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "procedure source", string3, new Object[0]);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeAll(resultSet, statement);
                    throw throwable;
                }
                JdbcUtils.closeAll(resultSet, statement);
            }
        }
        JdbcUtils.closeAll(resultSet, statement);
        procedureDefinition.setSource(stringBuilder);
    }

    private CharSequence buildParameterList(String string, String string2, String string3) {
        List<String> list = StringUtil.stringToList(string, ";", true, true);
        List<String> list2 = StringUtil.stringToList(string2, ";", true, true);
        List<String> list3 = StringUtil.stringToList(string3, ";", true, true);
        List<ColumnIdentifier> list4 = this.convertToColumns(list, list2, list3);
        StringBuilder stringBuilder = new StringBuilder(list4.size() * 10);
        stringBuilder.append('(');
        int n = 0;
        for (ColumnIdentifier columnIdentifier : list4) {
            String string4 = columnIdentifier.getArgumentMode();
            if ("RETURN".equals(string4)) continue;
            if (n > 0) {
                stringBuilder.append(", ");
            }
            String string5 = columnIdentifier.getColumnName();
            String string6 = columnIdentifier.getDbmsType();
            stringBuilder.append(string5);
            stringBuilder.append(' ');
            stringBuilder.append(string6);
            ++n;
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder getAggregateSource(PGProcName pGProcName, String string) {
        String string2 = "SELECT a.aggtransfn, a.aggfinalfn, format_type(a.aggtranstype, null) as stype, a.agginitval, op.oprname ";
        String string3 = " FROM pg_proc p \n  JOIN pg_namespace n ON p.pronamespace = n.oid \n  JOIN pg_aggregate a ON a.aggfnoid = p.oid \n  LEFT JOIN pg_operator op ON op.oid = a.aggsortop ";
        boolean bl = JdbcUtils.hasMinimumServerVersion(this.connection, "8.1");
        if (bl) {
            string2 = string2 + ", a.aggsortop ";
        }
        boolean bl2 = JdbcUtils.hasMinimumServerVersion(this.connection, "9.6");
        string2 = string2 + ", " + (bl2 ? "p.proparallel" : "null as proparallel");
        String string4 = string2 + "\n" + string3;
        string4 = string4 + " WHERE p.proname = '" + pGProcName.getName() + "' ";
        if (StringUtil.isNonBlank(string)) {
            string4 = string4 + " and n.nspname = '" + string + "' ";
        }
        LogMgr.logMetadataSql(new CallerInfo(){}, "aggregate source", string4, new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        ResultSet resultSet = null;
        Statement statement = null;
        Savepoint savepoint = null;
        try {
            if (this.useSavepoint) {
                savepoint = this.connection.setSavepoint();
            }
            if ((resultSet = (statement = this.connection.createStatementForQuery()).executeQuery(string4)).next()) {
                String string5;
                String string6;
                String string7;
                stringBuilder.append("CREATE AGGREGATE ");
                stringBuilder.append(pGProcName.getFormattedName());
                stringBuilder.append("\n(\n");
                String string8 = resultSet.getString("aggtransfn");
                stringBuilder.append("  sfunc = ");
                stringBuilder.append(string8);
                String string9 = resultSet.getString("stype");
                stringBuilder.append(",\n  stype = ");
                stringBuilder.append(string9);
                String string10 = resultSet.getString("oprname");
                if (StringUtil.isNonBlank(string10)) {
                    stringBuilder.append(",\n  sortop = ");
                    stringBuilder.append(this.connection.getMetadata().quoteObjectname(string10));
                }
                if (StringUtil.isNonBlank(string7 = resultSet.getString("aggfinalfn")) && !string7.equals("-")) {
                    stringBuilder.append(",\n  finalfunc = ");
                    stringBuilder.append(string7);
                }
                if (StringUtil.isNonBlank(string6 = resultSet.getString("agginitval"))) {
                    stringBuilder.append(",\n  initcond = '");
                    stringBuilder.append(string6);
                    stringBuilder.append('\'');
                }
                if (this.nonDefaultParallel(string5 = resultSet.getString("proparallel"))) {
                    stringBuilder.append(",\n  parallel = ");
                    stringBuilder.append(this.codeToParallelType(string5).toLowerCase());
                }
                stringBuilder.append("\n);\n");
            }
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            try {
                stringBuilder = null;
                this.connection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, sQLException, "aggregate source", string4, new Object[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, statement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, statement);
        }
        JdbcUtils.closeAll(resultSet, statement);
        return stringBuilder;
    }

    private boolean nonDefaultParallel(String string) {
        if (string == null) {
            return false;
        }
        return !string.equals("u");
    }

    private String codeToParallelType(String string) {
        switch (string) {
            case "s": {
                return "SAFE";
            }
            case "r": {
                return "RESTRICTED";
            }
            case "u": {
                return "UNSAFE";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStore getColumns(String string, String string2, PGProcName pGProcName) throws SQLException {
        Object object;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Savepoint savepoint;
        DataStore dataStore;
        String string3;
        block10: {
            string3 = "SELECT format_type(p.prorettype, NULL) as formatted_type, \n       t.typname as pg_type, \n       coalesce(array_to_string(proallargtypes, ';'), array_to_string(proargtypes, ';')) as argtypes, \n       array_to_string(p.proargnames, ';') as argnames, \n       array_to_string(p.proargmodes, ';') as modes, \n       t.typtype \nFROM pg_catalog.pg_proc p \n   JOIN pg_catalog.pg_namespace n ON p.pronamespace = n.oid \n   JOIN pg_catalog.pg_type t ON p.prorettype = t.oid \nWHERE n.nspname = ? \n  AND p.proname = ? \n";
            dataStore = this.createProcColsDataStore();
            savepoint = null;
            preparedStatement = null;
            resultSet = null;
            String string4 = pGProcName.getInputOIDs();
            if (StringUtil.isNonBlank(string4)) {
                string3 = string3 + "  AND p.proargtypes = cast('" + string4 + "' as oidvector)";
            }
            LogMgr.logMetadataSql(new CallerInfo(){}, "procedure columns", string3, string2, pGProcName.getName());
            savepoint = this.connection.setSavepoint();
            preparedStatement = this.connection.getSqlConnection().prepareStatement(string3);
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, pGProcName.getName());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl;
                String string5 = resultSet.getString("formatted_type");
                object = resultSet.getString("pg_type");
                String string6 = resultSet.getString("argtypes");
                String string7 = resultSet.getString("argnames");
                String string8 = resultSet.getString("modes");
                String string9 = resultSet.getString("typtype");
                boolean bl2 = bl = string9.equals("b") || string9.equals("d") || string9.equals("p") && string8 == null;
                if (bl) {
                    int n = dataStore.addRow();
                    dataStore.setValue(n, 0, (Object)"returnValue");
                    dataStore.setValue(n, 1, (Object)"RETURN");
                    dataStore.setValue(n, 3, (Object)this.getJavaType((String)object));
                    dataStore.setValue(n, 2, (Object)StringUtil.trimQuotes(string5));
                }
                List<String> list = StringUtil.stringToList(string7, ";", true, true);
                List<String> list2 = StringUtil.stringToList(string6, ";", true, true);
                if (string8 == null) {
                    string8 = string6.replaceAll("[0-9]+", "i");
                }
                List<String> list3 = StringUtil.stringToList(string8, ";", true, true);
                List<ColumnIdentifier> list4 = this.convertToColumns(list, list2, list3);
                for (ColumnIdentifier columnIdentifier : list4) {
                    int n = dataStore.addRow();
                    dataStore.setValue(n, 1, (Object)columnIdentifier.getArgumentMode());
                    dataStore.setValue(n, 3, (Object)columnIdentifier.getDataType());
                    dataStore.setValue(n, 2, (Object)columnIdentifier.getDbmsType());
                    dataStore.setValue(n, 0, (Object)columnIdentifier.getColumnName());
                }
                break block10;
            }
            LogMgr.logWarning(new CallerInfo(){}, "No columns returned for procedure: " + pGProcName.getName(), null);
            DataStore dataStore2 = super.getProcedureColumns(string, string2, pGProcName.getName(), null);
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return dataStore2;
        }
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (Exception exception) {
            try {
                this.connection.rollback(savepoint);
                LogMgr.logMetadataError(new CallerInfo(){}, exception, "procedure columns", string3, string2, pGProcName.getName());
                object = super.getProcedureColumns(string, string2, pGProcName.getName(), null);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeAll(resultSet, preparedStatement);
                throw throwable;
            }
            JdbcUtils.closeAll(resultSet, preparedStatement);
            return object;
        }
        JdbcUtils.closeAll(resultSet, preparedStatement);
        return dataStore;
    }

    private List<ColumnIdentifier> convertToColumns(List<String> list, List<String> list2, List<String> list3) {
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            int n = StringUtil.getIntValue(list2.get(i), -1);
            String string = this.getTypeNameFromOid(n);
            String string2 = "$" + (i + 1);
            if (list != null && i < list.size()) {
                string2 = list.get(i);
            }
            String string3 = null;
            if (list3 != null && i < list3.size()) {
                string3 = RedshiftUDFReader.pgArgModeToJdbc(list3.get(i));
            }
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(string2);
            columnIdentifier.setDataType(this.getJavaType(string));
            columnIdentifier.setDbmsType(this.getTypeNameFromOid(n));
            columnIdentifier.setArgumentMode(string3);
            arrayList.add(columnIdentifier);
        }
        return arrayList;
    }

    static String pgArgModeToJdbc(String string) {
        if (string == null) {
            return null;
        }
        switch (string) {
            case "i": {
                return "IN";
            }
            case "o": {
                return "OUT";
            }
            case "b": {
                return "INOUT";
            }
            case "v": {
                return "IN";
            }
            case "t": {
                return "RETURN";
            }
        }
        return null;
    }
}

