/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import workbench.db.BaseObjectType;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.DomainIdentifier;
import workbench.db.EnumIdentifier;
import workbench.db.TableConstraint;
import workbench.db.WbConnection;
import workbench.db.report.ReportColumn;
import workbench.db.report.ReportTable;
import workbench.db.report.TagWriter;
import workbench.util.CollectionUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class GenericReportObject {
    public static final String TAG_OBJECT_DEF = "object-def";
    public static final String TAG_OBJECT_NAME = "object-name";
    public static final String TAG_OBJECT_CATALOG = "object-catalog";
    public static final String TAG_OBJECT_SCHEMA = "object-schema";
    public static final String TAG_OBJECT_COMMENT = "object-comment";
    public static final String TAG_OBJECT_TYPE = "object-type";
    public static final String TAG_OBJECT_SOURCE = "object-source";
    public static final String TAG_OBJECT_DETAILS = "object-details";
    public static final String TAG_DOMAIN_TYPE = "domain-datatype";
    public static final String TAG_DOMAIN_NULLABLE = "domain-nullable";
    public static final String TAG_DOMAIN_CONSTRAINT = "domain-constraint";
    public static final String TAG_DOMAIN_DEFVALUE = "domain-defaultvalue";
    public static final String TAG_ENUM_VALUES = "enum-values";
    public static final String TAG_ENUM_VALUE = "enum-value";
    public static final String TAG_TYPE_ATTRS = "attributes";
    private DbObject object;
    private String source;
    private String schemaNameToUse;

    public GenericReportObject(WbConnection wbConnection, DbObject dbObject) {
        this.object = dbObject;
        this.source = wbConnection == null ? null : wbConnection.getMetadata().getObjectSource(dbObject);
    }

    public void setSchemaNameToUse(String string) {
        this.schemaNameToUse = string;
    }

    public void writeXml(Writer writer) throws IOException {
        StringBuilder stringBuilder = this.getXml();
        writer.append(stringBuilder);
    }

    public StringBuilder getXml() {
        return this.getXml(new StringBuilder("  "));
    }

    public StringBuilder getXml(StringBuilder stringBuilder) {
        BaseObjectType baseObjectType;
        List<ColumnIdentifier> list;
        StringBuilder stringBuilder2 = new StringBuilder(500);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[2];
        TagWriter tagWriter = new TagWriter();
        stringArray[0] = "name";
        stringArray2[0] = SqlUtil.removeObjectQuotes(this.object.getObjectName());
        stringArray[1] = TAG_OBJECT_TYPE;
        stringArray2[1] = this.object.getObjectType();
        tagWriter.appendOpenTag(stringBuilder2, stringBuilder, TAG_OBJECT_DEF, stringArray, stringArray2);
        stringBuilder2.append('\n');
        tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_OBJECT_CATALOG, SqlUtil.removeObjectQuotes(this.object.getCatalog()));
        tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_OBJECT_SCHEMA, this.schemaNameToUse == null ? SqlUtil.removeObjectQuotes(this.object.getSchema()) : this.schemaNameToUse);
        tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_OBJECT_NAME, SqlUtil.removeObjectQuotes(this.object.getObjectName()));
        tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_OBJECT_TYPE, SqlUtil.removeObjectQuotes(this.object.getObjectType()));
        tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_OBJECT_COMMENT, this.object.getComment(), true);
        StringBuilder stringBuilder4 = new StringBuilder(stringBuilder3);
        stringBuilder4.append("  ");
        StringBuilder stringBuilder5 = new StringBuilder(stringBuilder4);
        stringBuilder5.append("  ");
        if (this.object instanceof DomainIdentifier) {
            tagWriter.appendOpenTag(stringBuilder2, stringBuilder3, TAG_OBJECT_DETAILS);
            stringBuilder2.append('\n');
            DomainIdentifier domainIdentifier = (DomainIdentifier)this.object;
            if (StringUtil.isNonBlank(domainIdentifier.getCheckConstraint())) {
                tagWriter.appendOpenTag(stringBuilder2, stringBuilder4, TAG_DOMAIN_CONSTRAINT);
                stringBuilder2.append('\n');
                TableConstraint tableConstraint = new TableConstraint(domainIdentifier.getConstraintName(), domainIdentifier.getCheckConstraint());
                ReportTable.writeConstraint(tableConstraint, tagWriter, stringBuilder2, stringBuilder5);
                tagWriter.appendCloseTag(stringBuilder2, stringBuilder4, TAG_DOMAIN_CONSTRAINT);
            }
            tagWriter.appendTag(stringBuilder2, stringBuilder4, TAG_DOMAIN_TYPE, domainIdentifier.getDataType());
            tagWriter.appendTag(stringBuilder2, stringBuilder4, TAG_DOMAIN_NULLABLE, domainIdentifier.isNullable());
            tagWriter.appendTag(stringBuilder2, stringBuilder4, TAG_DOMAIN_DEFVALUE, domainIdentifier.getDefaultValue());
            tagWriter.appendCloseTag(stringBuilder2, stringBuilder3, TAG_OBJECT_DETAILS);
        } else if (this.object instanceof EnumIdentifier) {
            tagWriter.appendOpenTag(stringBuilder2, stringBuilder3, TAG_OBJECT_DETAILS);
            stringBuilder2.append('\n');
            EnumIdentifier enumIdentifier = (EnumIdentifier)this.object;
            tagWriter.appendOpenTag(stringBuilder2, stringBuilder4, TAG_ENUM_VALUES);
            stringBuilder2.append('\n');
            for (String string : enumIdentifier.getValues()) {
                tagWriter.appendTag(stringBuilder2, stringBuilder5, TAG_ENUM_VALUE, string);
            }
            tagWriter.appendCloseTag(stringBuilder2, stringBuilder4, TAG_ENUM_VALUES);
            tagWriter.appendCloseTag(stringBuilder2, stringBuilder3, TAG_OBJECT_DETAILS);
        } else if (this.object instanceof BaseObjectType && CollectionUtil.isNonEmpty(list = (baseObjectType = (BaseObjectType)this.object).getAttributes())) {
            tagWriter.appendOpenTag(stringBuilder2, stringBuilder3, TAG_OBJECT_DETAILS);
            stringBuilder2.append('\n');
            tagWriter.appendOpenTag(stringBuilder2, stringBuilder4, TAG_TYPE_ATTRS);
            stringBuilder2.append('\n');
            for (ColumnIdentifier columnIdentifier : list) {
                ReportColumn reportColumn = new ReportColumn(columnIdentifier);
                reportColumn.appendXml(stringBuilder2, stringBuilder5, true);
            }
            tagWriter.appendCloseTag(stringBuilder2, stringBuilder4, TAG_TYPE_ATTRS);
            tagWriter.appendCloseTag(stringBuilder2, stringBuilder3, TAG_OBJECT_DETAILS);
        }
        if (StringUtil.isNonEmpty(this.source)) {
            tagWriter.appendTag(stringBuilder2, stringBuilder3, TAG_OBJECT_SOURCE, this.source, true);
        }
        tagWriter.appendCloseTag(stringBuilder2, stringBuilder, TAG_OBJECT_DEF);
        return stringBuilder2;
    }
}

