/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import workbench.db.BaseObjectType;
import workbench.db.ColumnIdentifier;
import workbench.db.report.ReportColumn;
import workbench.db.report.TagWriter;
import workbench.util.SqlUtil;

public class ReportObjectType {
    public static final String TAG_TYPE_DEF = "type-def";
    public static final String TAG_TYPE_NAME = "type-name";
    public static final String TAG_TYPE_CATALOG = "type-catalog";
    public static final String TAG_TYPE_SCHEMA = "type-schema";
    public static final String TAG_TYPE_COMMENT = "type-comment";
    private BaseObjectType type;
    private final TagWriter tagWriter = new TagWriter();
    private String schemaToUse;

    public ReportObjectType(BaseObjectType baseObjectType) {
        this.type = baseObjectType;
    }

    public void writeXml(Writer writer) throws IOException {
        StringBuilder stringBuilder = this.getXml();
        writer.append(stringBuilder);
    }

    public BaseObjectType getType() {
        return this.type;
    }

    public void setSchemaToUse(String string) {
        this.schemaToUse = string;
    }

    public StringBuilder getXml() {
        return this.getXml(TAG_TYPE_DEF, new StringBuilder("  "));
    }

    public String toString() {
        return this.type.toString();
    }

    public StringBuilder getXml(String string, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = new StringBuilder(500);
        StringBuilder stringBuilder3 = new StringBuilder(stringBuilder);
        stringBuilder3.append("  ");
        this.tagWriter.appendOpenTag(stringBuilder2, stringBuilder, string, "name", SqlUtil.removeObjectQuotes(this.type.getObjectName()));
        stringBuilder2.append('\n');
        this.appendDefinitionXml(stringBuilder2, stringBuilder3);
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(this.type.getAttributes());
        if (arrayList.size() > 0) {
            Collections.sort(arrayList);
            for (ColumnIdentifier columnIdentifier : arrayList) {
                ReportColumn reportColumn = new ReportColumn(columnIdentifier);
                reportColumn.appendXml(stringBuilder2, stringBuilder3);
            }
        }
        this.tagWriter.appendCloseTag(stringBuilder2, stringBuilder, string);
        stringBuilder2.append('\n');
        return stringBuilder2;
    }

    public void appendDefinitionXml(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_TYPE_CATALOG, SqlUtil.removeObjectQuotes(this.type.getCatalog()));
        this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_TYPE_SCHEMA, this.schemaToUse == null ? SqlUtil.removeObjectQuotes(this.type.getSchema()) : this.schemaToUse);
        this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_TYPE_NAME, SqlUtil.removeObjectQuotes(this.type.getObjectName()));
        this.tagWriter.appendTag(stringBuilder, stringBuilder2, TAG_TYPE_COMMENT, this.type.getComment());
    }
}

