/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import workbench.db.ProcedureDefinition;
import workbench.db.ProcedureReader;
import workbench.db.ReaderFactory;
import workbench.db.WbConnection;
import workbench.db.report.TagWriter;

public class ReportPackage {
    public static final String TAG_PKG_DEF = "package-def";
    public static final String TAG_PKG_NAME = "package-name";
    public static final String TAG_PKG_SCHEMA = "package-schema";
    public static final String TAG_PKG_SOURCE = "package-source";
    private String owner;
    private String name;
    private CharSequence source;
    private StringBuilder indent = new StringBuilder("  ");
    private StringBuilder indent2 = new StringBuilder("    ");
    private String schemaToUse;

    public ReportPackage(ProcedureDefinition procedureDefinition) {
        if (!procedureDefinition.isPackageProcedure()) {
            throw new IllegalArgumentException(procedureDefinition.getProcedureName() + " is not an Oracle package!");
        }
        this.owner = procedureDefinition.getSchema();
        this.name = procedureDefinition.getPackageName();
    }

    public void setSchemaToUse(String string) {
        this.schemaToUse = string;
    }

    private String getSchema() {
        return this.schemaToUse == null ? this.owner : this.schemaToUse;
    }

    public ReportPackage(String string, String string2) {
        this.owner = string;
        this.name = string2;
    }

    public String getPackageName() {
        return this.name;
    }

    public CharSequence getSource() {
        return this.source;
    }

    public void setSource(CharSequence charSequence) {
        this.source = charSequence;
    }

    public void readSource(WbConnection wbConnection) {
        ProcedureReader procedureReader = ReaderFactory.getProcedureReader(wbConnection.getMetadata());
        this.source = procedureReader.getPackageSource(null, this.owner, this.name);
    }

    public void setIndent(StringBuilder stringBuilder) {
        this.indent = stringBuilder == null ? new StringBuilder(0) : stringBuilder;
        this.indent2 = new StringBuilder(this.indent);
        this.indent2.append("  ");
    }

    public StringBuilder getXml(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(500);
        TagWriter tagWriter = new TagWriter();
        String string = this.getSchema();
        tagWriter.appendOpenTag(stringBuilder, this.indent, TAG_PKG_DEF, new String[]{"schema", "packageName"}, new String[]{string, this.name});
        stringBuilder.append('\n');
        tagWriter.appendTag(stringBuilder, this.indent2, TAG_PKG_SCHEMA, string);
        tagWriter.appendTag(stringBuilder, this.indent2, TAG_PKG_NAME, this.name);
        if (bl) {
            tagWriter.appendTag(stringBuilder, this.indent2, TAG_PKG_SOURCE, this.source, true);
        }
        tagWriter.appendCloseTag(stringBuilder, this.indent, TAG_PKG_DEF);
        return stringBuilder;
    }

    public int hashCode() {
        int n = 7;
        n = 61 * n + (this.owner != null ? this.owner.hashCode() : 0);
        n = 61 * n + (this.name != null ? this.name.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ReportPackage reportPackage = (ReportPackage)object;
        if (this.owner == null ? reportPackage.owner != null : !this.owner.equals(reportPackage.owner)) {
            return false;
        }
        return !(this.name == null ? reportPackage.name != null : !this.name.equals(reportPackage.name));
    }
}

