/*
 * Decompiled with CFR 0.152.
 */
package workbench.db.report;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import workbench.db.BaseObjectType;
import workbench.db.ConnectionInfoBuilder;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbObjectComparator;
import workbench.db.DbSettings;
import workbench.db.FKHandler;
import workbench.db.ProcedureDefinition;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.report.GenericReportObject;
import workbench.db.report.ReportObjectType;
import workbench.db.report.ReportProcedure;
import workbench.db.report.ReportSequence;
import workbench.db.report.ReportTable;
import workbench.db.report.ReportView;
import workbench.db.report.TagWriter;
import workbench.interfaces.Interruptable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.RowActionMonitor;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class SchemaReporter
implements Interruptable {
    public static final String TAG_SETTINGS = "report-settings";
    public static final String TAG_TRG_INFO = "include-triggers";
    public static final String TAG_PARTITION_INFO = "include-partitions";
    public static final String TAG_OBJECT_TYPES = "included-types";
    private WbConnection dbConn;
    private List<DbObject> objects = new ArrayList<DbObject>();
    private List<ReportProcedure> procedures = new ArrayList<ReportProcedure>();
    private List<ReportSequence> sequences = new ArrayList<ReportSequence>();
    private Set<String> types;
    private List<String> schemas;
    private TagWriter tagWriter = new TagWriter();
    private RowActionMonitor monitor;
    private String outputfile;
    protected volatile boolean cancel;
    private String procedureNames;
    private boolean includeGrants;
    private boolean includeTriggers;
    private boolean includePartitions;
    private String schemaNameToUse = null;
    private String reportTitle = null;
    private boolean fullObjectSource;
    private boolean generatePKNames;
    private final FKHandler fkHandler;

    public SchemaReporter(WbConnection wbConnection) {
        this.dbConn = wbConnection;
        this.types = CollectionUtil.caseInsensitiveSet();
        this.types.addAll(wbConnection.getMetadata().getTableTypes());
        this.types.addAll(this.dbConn.getDbSettings().getViewTypes());
        this.fkHandler = FKHandler.createInstance(wbConnection);
        this.fkHandler.initializeSharedCache();
    }

    public void setProgressMonitor(RowActionMonitor rowActionMonitor) {
        this.monitor = rowActionMonitor;
    }

    public void setReportTitle(String string) {
        this.reportTitle = string;
    }

    public void setObjectList(List<? extends DbObject> list) {
        DbMetadata dbMetadata = this.dbConn.getMetadata();
        SequenceReader sequenceReader = dbMetadata.getSequenceReader();
        for (DbObject dbObject : list) {
            DbObject dbObject2;
            if (dbMetadata.isSequenceType(dbObject.getObjectType()) && sequenceReader != null) {
                dbObject2 = sequenceReader.getSequenceDefinition(dbObject.getCatalog(), dbObject.getSchema(), dbObject.getObjectName());
                this.sequences.add(new ReportSequence((SequenceDefinition)dbObject2));
                continue;
            }
            if (dbMetadata.isExtendedObject(dbObject) && dbObject instanceof TableIdentifier) {
                dbObject2 = dbMetadata.getObjectDefinition((TableIdentifier)dbObject);
                this.objects.add(dbObject2);
                continue;
            }
            this.objects.add(dbObject);
        }
    }

    public int getObjectCount() {
        return this.objects.size() + this.sequences.size() + this.procedures.size();
    }

    public void clearObjects() {
        this.objects.clear();
        this.sequences.clear();
        this.procedures.clear();
    }

    public void setSchemas(List<String> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        this.schemas = list;
        this.schemaNameToUse = null;
    }

    public void setSchemaNameToUse(String string) {
        if (this.schemas == null || this.schemas.size() == 1) {
            this.schemaNameToUse = string;
        }
    }

    public void setGenerateConstraintNames(boolean bl) {
        this.generatePKNames = bl;
    }

    public void setProcedureNames(String string) {
        this.procedureNames = string;
    }

    public boolean proceduresIncluded() {
        return this.procedureNames != null;
    }

    public void setCreateFullObjectSource(boolean bl) {
        this.fullObjectSource = bl;
    }

    public void setIncludeProcedures(boolean bl) {
        this.procedureNames = bl ? "*" : null;
    }

    public void setIncludeGrants(boolean bl) {
        this.includeGrants = bl;
    }

    public void setIncludePartitions(boolean bl) {
        this.includePartitions = bl;
    }

    public void setIncludeTriggers(boolean bl) {
        this.includeTriggers = bl;
    }

    public void setOutputFilename(String string) {
        this.outputfile = string;
    }

    public String getXml() {
        this.cancel = false;
        StringWriter stringWriter = new StringWriter(5000);
        try {
            this.writeXml(stringWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void writeXml() throws IOException, SQLException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputfile), "UTF-8"), 16384);
            this.writeXml(bufferedWriter);
        }
        catch (IOException iOException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Error writing report", iOException);
                throw iOException;
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(bufferedWriter);
                this.fkHandler.clearSharedCache();
                throw throwable;
            }
        }
        FileUtil.closeQuietely(bufferedWriter);
        this.fkHandler.clearSharedCache();
    }

    public void writeXml(Writer writer) throws IOException, SQLException {
        String string;
        this.cancel = false;
        this.objects.sort(new DbObjectComparator());
        if (this.proceduresIncluded() && this.procedures.isEmpty()) {
            this.retrieveProcedures();
        }
        if (this.cancel) {
            return;
        }
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("<");
        writer.write("schema-report>\n\n");
        this.writeReportInfo(writer);
        writer.write("\n");
        int n = this.objects.size() + this.procedures.size() + this.sequences.size();
        int n2 = 1;
        DbSettings dbSettings = this.dbConn.getMetadata().getDbSettings();
        for (DbObject object : this.objects) {
            try {
                Object object2;
                String string2;
                if (this.cancel) break;
                string = object.getObjectExpression(this.dbConn);
                if (this.monitor != null) {
                    this.monitor.setCurrentObject(string, n2, n);
                }
                if (dbSettings.isViewType(string2 = object.getObjectType())) {
                    object2 = new ReportView((TableIdentifier)object, this.dbConn, true, this.includeGrants, this.fullObjectSource);
                    ((ReportView)object2).setSchemaNameToUse(this.schemaNameToUse);
                    ((ReportView)object2).writeXml(writer);
                } else if (object instanceof TableIdentifier) {
                    object2 = new ReportTable((TableIdentifier)object, this.dbConn, true, true, true, true, this.includeGrants, this.includeTriggers, this.includePartitions);
                    ((ReportTable)object2).setSchemaNameToUse(this.schemaNameToUse);
                    ((ReportTable)object2).setGeneratePKName(this.generatePKNames);
                    ((ReportTable)object2).writeXml(writer);
                    ((ReportTable)object2).done();
                } else if (object instanceof BaseObjectType) {
                    object2 = new ReportObjectType((BaseObjectType)object);
                    ((ReportObjectType)object2).writeXml(writer);
                } else {
                    object2 = new GenericReportObject(this.dbConn, object);
                    ((GenericReportObject)object2).writeXml(writer);
                }
                writer.flush();
                ++n2;
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error writing table: " + object, exception);
            }
        }
        if (this.procedures.size() > 0) {
            writer.write("\n");
        }
        for (ReportProcedure reportProcedure : this.procedures) {
            if (this.monitor != null) {
                this.monitor.setCurrentObject(reportProcedure.getProcedureName(), n2, n);
            }
            reportProcedure.writeXml(writer);
            writer.write(10);
            ++n2;
            if (!this.cancel) continue;
            break;
        }
        if (this.sequences.size() > 0) {
            writer.write("\n");
        }
        for (ReportSequence reportSequence : this.sequences) {
            string = reportSequence.getSequence().getSequenceName();
            if (this.monitor != null) {
                this.monitor.setCurrentObject(string, n2, n);
            }
            reportSequence.writeXml(writer);
            writer.write(10);
            ++n2;
            if (!this.cancel) continue;
            break;
        }
        writer.write("</");
        writer.write("schema-report>");
        writer.flush();
    }

    private void writeReportInfo(Writer writer) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder("  ");
        StringBuilder stringBuilder3 = new StringBuilder("    ");
        if (!StringUtil.isEmptyString(this.reportTitle)) {
            this.tagWriter.appendTag(stringBuilder, stringBuilder2, "report-title", this.reportTitle);
        }
        ConnectionInfoBuilder connectionInfoBuilder = new ConnectionInfoBuilder();
        stringBuilder.append((CharSequence)connectionInfoBuilder.getDatabaseInfoAsXml(this.dbConn, stringBuilder2));
        TagWriter tagWriter = new TagWriter();
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("<generated-at>");
        stringBuilder.append(StringUtil.getCurrentTimestampWithTZString());
        stringBuilder.append("</generated-at>\n\n");
        tagWriter.appendOpenTag(stringBuilder, stringBuilder2, TAG_SETTINGS);
        stringBuilder.append('\n');
        tagWriter.appendTag(stringBuilder, stringBuilder3, "include-tablegrants", this.includeGrants);
        tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_PARTITION_INFO, this.includePartitions);
        tagWriter.appendTag(stringBuilder, stringBuilder3, TAG_TRG_INFO, this.includeTriggers);
        tagWriter.appendTag(stringBuilder, stringBuilder3, "full-object-source", this.fullObjectSource);
        if (CollectionUtil.isNonEmpty(this.types)) {
            tagWriter.appendOpenTag(stringBuilder, stringBuilder3, TAG_OBJECT_TYPES);
            stringBuilder.append('\n');
            StringBuilder stringBuilder4 = new StringBuilder(stringBuilder3);
            stringBuilder4.append("  ");
            for (String string : this.types) {
                tagWriter.appendTag(stringBuilder, stringBuilder4, "type", string);
            }
            tagWriter.appendCloseTag(stringBuilder, stringBuilder3, TAG_OBJECT_TYPES);
        }
        tagWriter.appendCloseTag(stringBuilder, stringBuilder2, TAG_SETTINGS);
        writer.write(stringBuilder.toString());
    }

    @Override
    public void cancelExecution() {
        this.cancel = true;
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }

    public void retrieveProcedures() {
        if (!this.proceduresIncluded()) {
            return;
        }
        this.procedures.clear();
        if (this.monitor != null) {
            this.monitor.setCurrentObject(ResourceMgr.getString("MsgRetrievingProcedures"), -1L, -1L);
        }
        if (CollectionUtil.isEmpty(this.schemas)) {
            this.retrieveProcedures(null);
        } else {
            for (String string : this.schemas) {
                this.retrieveProcedures(string);
                if (!this.cancel) continue;
                return;
            }
        }
        if (this.monitor != null) {
            this.monitor.setCurrentObject(null, -1L, -1L);
        }
    }

    private void retrieveProcedures(String string) {
        try {
            List<String> list = StringUtil.stringToList(this.procedureNames, ",", true, true, false, false);
            String string2 = this.dbConn.getMetadata().adjustSchemaNameCase(string);
            List<ProcedureDefinition> list2 = null;
            for (String object : list) {
                if (this.cancel) {
                    return;
                }
                String string3 = this.dbConn.getMetadata().adjustObjectnameCase(object);
                if (this.dbConn.getDbSettings().supportsSchemas()) {
                    list2 = this.dbConn.getMetadata().getProcedureReader().getProcedureList(null, string2, string3);
                    continue;
                }
                list2 = this.dbConn.getMetadata().getProcedureReader().getProcedureList(string2, null, string3);
            }
            HashSet hashSet = new HashSet();
            for (ProcedureDefinition procedureDefinition : list2) {
                if (procedureDefinition.isOracleObjectType()) continue;
                if (procedureDefinition.isPackageProcedure()) {
                    if (hashSet.contains(procedureDefinition.getPackageName())) continue;
                    hashSet.add(procedureDefinition.getPackageName());
                }
                ReportProcedure reportProcedure = new ReportProcedure(procedureDefinition, this.dbConn);
                this.procedures.add(reportProcedure);
                if (!this.cancel) continue;
                return;
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving procedures", sQLException);
        }
    }
}

