/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.macros.AddMacroPanel;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.TextSelectionListener;
import workbench.resource.ResourceMgr;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroGroup;
import workbench.sql.macros.MacroManager;
import workbench.util.StringUtil;

public class AddMacroAction
extends WbAction
implements TextSelectionListener {
    private EditorPanel client;
    private final int macroClientId;

    public AddMacroAction(int n) {
        this.macroClientId = n;
        this.setIcon(null);
        this.setMenuItemName("MnuTxtMacro");
        this.initMenuDefinition("MnuTxtAddMacro");
        this.setEnabled(false);
    }

    public void setClient(EditorPanel editorPanel) {
        if (this.client != null) {
            this.client.removeSelectionListener(this);
        }
        this.client = editorPanel;
        if (this.client == null) {
            this.setEnabled(false);
        } else {
            this.client.addSelectionListener(this);
            this.setEnabled(this.client.isTextSelected());
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        String string = this.client.getSelectedText();
        if (StringUtil.isBlank(string)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        AddMacroPanel addMacroPanel = new AddMacroPanel(this.macroClientId);
        ValidatingDialog validatingDialog = ValidatingDialog.createDialog(SwingUtilities.getWindowAncestor(this.client), addMacroPanel, ResourceMgr.getString("TxtGetMacroNameWindowTitle"), null, 0, true);
        validatingDialog.addWindowListener(addMacroPanel);
        validatingDialog.setVisible(true);
        if (!validatingDialog.isCancelled()) {
            MacroGroup macroGroup = addMacroPanel.getSelectedGroup();
            String string2 = addMacroPanel.getMacroName();
            if (StringUtil.isNonBlank(string2) && macroGroup != null) {
                MacroManager.getInstance().getMacros(this.macroClientId).addMacro(macroGroup, new MacroDefinition(string2, string));
            }
        }
    }

    @Override
    public void selectionChanged(int n, int n2) {
        boolean bl = n > -1 && n2 > n;
        this.setEnabled(bl);
    }
}

