/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import java.util.Properties;
import workbench.gui.MainWindow;
import workbench.gui.actions.WbAction;
import workbench.gui.components.MapEditor;
import workbench.gui.components.ValidatingDialog;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class EditWorkspaceVarsAction
extends WbAction {
    private final String CONFIG_PROP = "workbench.gui.edit.workspace.variables.dialog";
    private MainWindow client;

    public EditWorkspaceVarsAction(MainWindow mainWindow) {
        this.client = mainWindow;
        this.initMenuDefinition("MnuTxtEditWkspVars", null);
        this.setMenuItemName("MnuTxtWorkspace");
        this.setIcon(null);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.client == null) {
            return;
        }
        Properties properties = this.client.getCurrentWorkspaceVariables();
        if (properties == null) {
            return;
        }
        MapEditor mapEditor = new MapEditor(properties);
        mapEditor.optimizeColumnWidths();
        ValidatingDialog validatingDialog = ValidatingDialog.createDialog(this.client, mapEditor, ResourceMgr.getPlainString("MnuTxtEditWkspVars"), null, 0, false);
        validatingDialog.setVisible(true);
        Settings.getInstance().storeWindowSize(validatingDialog, "workbench.gui.edit.workspace.variables.dialog");
        if (!validatingDialog.isCancelled()) {
            this.client.replaceWorkspaceVariables(mapEditor.getProperties());
        }
    }
}

