/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import workbench.gui.components.ColumnWidthOptimizer;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.WbTable;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.renderer.SqlTypeRenderer;
import workbench.gui.sql.DwPanel;
import workbench.resource.GuiSettings;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.storage.ResultInfoDisplayBuilder;

public class ResultSetInfoPanel
extends JPanel {
    private WbTable display;

    public ResultSetInfoPanel(DwPanel dwPanel) {
        super(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.display = new WbTable(false, false, false);
        this.display.setRendererSetup(new RendererSetup(false));
        jScrollPane.setViewportView(this.display);
        this.add((Component)jScrollPane, "Center");
        DataStore dataStore = dwPanel.getDataStore();
        if (dataStore != null) {
            ResultInfo resultInfo = dataStore.getResultInfo();
            boolean bl = GuiSettings.getRetrieveQueryComments();
            DataStore dataStore2 = ResultInfoDisplayBuilder.getDataStore(resultInfo, bl);
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore2);
            this.display.setAutoCreateColumnsFromModel(true);
            this.display.setModel(dataStoreTableModel);
            TableColumnModel tableColumnModel = this.display.getColumnModel();
            int n = tableColumnModel.getColumnIndex("JDBC Type");
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            tableColumn.setCellRenderer(new SqlTypeRenderer(true));
            ColumnWidthOptimizer columnWidthOptimizer = new ColumnWidthOptimizer(this.display);
            columnWidthOptimizer.optimizeAllColWidth(true);
        }
    }
}

