/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import workbench.db.WbConnection;
import workbench.gui.actions.WbAction;
import workbench.gui.sql.SqlPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.PlatformShortcuts;
import workbench.resource.ResourceMgr;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ObjectInfo;
import workbench.storage.DataStore;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class ShowObjectInfoAction
extends WbAction {
    private SqlPanel display;

    public ShowObjectInfoAction(SqlPanel sqlPanel) {
        this.display = sqlPanel;
        this.setIcon("object-info");
        this.setMenuItemName("MnuTxtSQL");
        this.initMenuDefinition("MnuTxtShowObjectDef", KeyStroke.getKeyStroke(73, PlatformShortcuts.getDefaultModifier()));
        this.checkEnabled();
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.display.isConnectionBusy()) {
            return;
        }
        final boolean bl = ShowObjectInfoAction.invokedByMouse(actionEvent) ? ShowObjectInfoAction.isCtrlPressed(actionEvent) : false;
        WbThread wbThread = new WbThread("ObjectInfoThread"){

            @Override
            public void run() {
                ShowObjectInfoAction.this.showInfo(bl);
            }
        };
        wbThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showInfo(boolean bl) {
        if (this.display.isConnectionBusy()) {
            return;
        }
        WbConnection wbConnection = this.display.getConnection();
        if (wbConnection == null) {
            return;
        }
        try {
            this.display.setBusy(true);
            this.display.fireDbExecStart();
            this.setEnabled(false);
            ObjectInfo objectInfo = new ObjectInfo();
            boolean bl2 = wbConnection.getDbSettings().objectInfoWithDependencies();
            String string = SqlUtil.getIdentifierAtCursor(this.display.getEditor(), wbConnection);
            if (StringUtil.isNonBlank(string)) {
                this.display.setStatusMessage(ResourceMgr.getString("TxtRetrieveTableDef") + " " + string);
                StatementRunnerResult statementRunnerResult = objectInfo.getObjectInfo(wbConnection, string, bl || bl2, true);
                if (statementRunnerResult != null) {
                    int n = this.display.getResultTabCount();
                    this.display.setBusy(false);
                    boolean bl3 = statementRunnerResult.hasMessages();
                    if (bl3) {
                        this.display.appendToLog("\n");
                        this.display.appendToLog(statementRunnerResult.getMessages());
                    }
                    if (statementRunnerResult.hasDataStores()) {
                        for (DataStore dataStore : statementRunnerResult.getDataStores()) {
                            dataStore.resetStatus();
                        }
                        this.display.addResult(statementRunnerResult);
                        this.display.setSelectedResultTab(n - 1);
                    } else if (bl3) {
                        this.display.showLogPanel();
                    }
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving object info", exception);
        }
        finally {
            this.display.fireDbExecEnd();
            this.display.clearStatusMessage();
            if (this.display.isBusy()) {
                this.display.setBusy(false);
            }
            this.checkEnabled();
        }
    }

    public void checkEnabled() {
        this.setEnabled(this.display != null && this.display.isConnected());
    }
}

