/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.awt.Toolkit;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbSearchPath;
import workbench.db.IndexDefinition;
import workbench.db.IndexReader;
import workbench.db.QuoteHandler;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.objectcache.DbObjectCache;
import workbench.db.objectcache.Namespace;
import workbench.gui.completion.SelectAllMarker;
import workbench.gui.completion.SelectFKValueMarker;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.sql.lexer.SQLToken;
import workbench.sql.syntax.SqlKeywordHelper;
import workbench.util.CollectionUtil;
import workbench.util.SelectColumn;
import workbench.util.SqlParsingUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.TableAlias;

public abstract class BaseAnalyzer {
    public static final String QUALIFIER_DELIM = "\\?*=<>!/{}\\%'(),:;";
    public static final String WORD_DELIM = "\\?*=<>!/{}\\%'(),:;@";
    public static final String SELECT_WORD_DELIM = "\\?*=<>!/{}\\%'(),:;@.";
    public static final int NO_CONTEXT = -1;
    public static final int CONTEXT_TABLE_LIST = 1;
    public static final int CONTEXT_COLUMN_LIST = 2;
    public static final int CONTEXT_FROM_LIST = 3;
    public static final int CONTEXT_TABLE_OR_COLUMN_LIST = 4;
    public static final int CONTEXT_KW_LIST = 5;
    public static final int CONTEXT_WB_PARAMS = 6;
    public static final int CONTEXT_WB_COMMANDS = 7;
    public static final int CONTEXT_WB_PARAMVALUES = 8;
    public static final int CONTEXT_SYNTAX_COMPLETION = 9;
    public static final int CONTEXT_STATEMENT_PARAMETER = 10;
    public static final int CONTEXT_SCHEMA_LIST = 11;
    public static final int CONTEXT_CATALOG_LIST = 12;
    public static final int CONTEXT_SEQUENCE_LIST = 13;
    public static final int CONTEXT_INDEX_LIST = 14;
    public static final int CONTEXT_VIEW_LIST = 15;
    public static final int CONTEXT_VALUE_LIST = 16;
    private final SelectAllMarker allColumnsMarker = new SelectAllMarker();
    private List<String> typeFilter;
    protected String keywordFile;
    protected WbConnection dbConnection;
    protected final String sql;
    protected final String verb;
    protected final int cursorPos;
    protected int context;
    protected TableIdentifier tableForColumnList;
    protected Namespace namespaceForTableList;
    protected boolean addAllMarker;
    protected List elements;
    protected String title;
    private boolean overwriteCurrentWord;
    protected boolean appendDot;
    private String columnPrefix;
    protected BaseAnalyzer parentAnalyzer;
    protected char catalogSeparator;
    protected char schemaSeparator;
    protected SelectFKValueMarker fkMarker;

    public BaseAnalyzer(WbConnection wbConnection, String string, int n) {
        this.dbConnection = wbConnection;
        this.sql = string;
        this.verb = SqlParsingUtil.getInstance(wbConnection).getSqlVerb(this.sql);
        this.cursorPos = n;
        this.catalogSeparator = SqlUtil.getCatalogSeparator(this.dbConnection);
        this.schemaSeparator = SqlUtil.getSchemaSeparator(this.dbConnection);
    }

    public String getPasteValue(Object object) {
        return null;
    }

    public QuoteHandler getQuoteHandler() {
        if (this.dbConnection == null) {
            return QuoteHandler.STANDARD_HANDLER;
        }
        DbMetadata dbMetadata = this.dbConnection.getMetadata();
        if (dbMetadata == null) {
            return QuoteHandler.STANDARD_HANDLER;
        }
        return dbMetadata;
    }

    public WbConnection getConnection() {
        return this.dbConnection;
    }

    public String getWordDelimiters() {
        return SELECT_WORD_DELIM;
    }

    public boolean needsCommaForMultipleSelection() {
        return true;
    }

    public boolean allowMultiSelection() {
        return true;
    }

    void setCatalogSeparator(char c) {
        this.catalogSeparator = c;
    }

    public String getSqlVerb() {
        return this.verb;
    }

    public String getAnalyzedSql() {
        return this.sql;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public char quoteCharForValue(String string) {
        return '\u0000';
    }

    public boolean isWbParam() {
        return false;
    }

    public boolean convertCase() {
        return true;
    }

    protected void setColumnPrefix(String string) {
        this.columnPrefix = string;
    }

    public String getColumnPrefix() {
        return this.columnPrefix;
    }

    protected void setOverwriteCurrentWord(boolean bl) {
        this.overwriteCurrentWord = bl;
    }

    public boolean appendDotToSelection() {
        return this.appendDot;
    }

    public boolean isKeywordList() {
        return this.context == 5 || this.context == 9;
    }

    public boolean getOverwriteCurrentWord() {
        return this.overwriteCurrentWord;
    }

    public Namespace getNamespaceForTableList() {
        return this.namespaceForTableList;
    }

    protected Namespace getCurrentNamespaceToUse() {
        if (this.dbConnection == null) {
            return null;
        }
        if (!this.dbConnection.getDbSettings().useCurrentNamespaceForCompletion()) {
            return null;
        }
        boolean bl = this.dbConnection.getDbSettings().supportsSchemas();
        boolean bl2 = this.dbConnection.getDbSettings().supportsCatalogs();
        if (!bl && bl2) {
            return new Namespace(null, this.dbConnection.getMetadata().getCurrentCatalog());
        }
        if (this.dbConnection.getDbSettings().useFullSearchPathForCompletion()) {
            return null;
        }
        String string = this.dbConnection.getCurrentSchema();
        String string2 = this.dbConnection.getCurrentCatalog();
        if (bl2 && bl) {
            return new Namespace(string, string2);
        }
        if (!bl) {
            return new Namespace(null, string2);
        }
        List<String> list = DbSearchPath.Factory.getSearchPathHandler(this.dbConnection).getSearchPath(this.dbConnection, string);
        if (list.isEmpty()) {
            return new Namespace(string, null);
        }
        if (list.size() == 1) {
            return new Namespace(list.get(0), null);
        }
        return null;
    }

    protected boolean isCurrentNameSpaceCatalog() {
        if (this.namespaceForTableList == null) {
            return false;
        }
        if (this.namespaceForTableList.hasCatalogAndSchema()) {
            return false;
        }
        if (this.dbConnection == null) {
            return false;
        }
        if (this.dbConnection.getDbSettings().supportsCatalogs() && this.dbConnection.getDbSettings().supportsSchemas()) {
            String string = this.namespaceForTableList.getSchema();
            String string2 = this.namespaceForTableList.getCatalog();
            String string3 = StringUtil.coalesce(string, string2);
            List<String> list = this.dbConnection.getMetadata().getAllCatalogs();
            for (String string4 : list) {
                if (!SqlUtil.objectNamesAreEqual(string4, string3)) continue;
                return true;
            }
        }
        return false;
    }

    protected Namespace getNamespaceFromCurrentWord() {
        String string = this.getQualifierLeftOfCursor();
        Namespace namespace = Namespace.fromExpression(this.dbConnection, string);
        if (!namespace.isValid()) {
            return this.getCurrentNamespaceToUse();
        }
        return namespace;
    }

    public void retrieveObjects() {
        this.elements = null;
        this.context = -1;
        this.typeFilter = null;
        this.keywordFile = null;
        this.fkMarker = null;
        this.checkOverwrite();
        this.addAllMarker = false;
        this.checkContext();
        this.buildResult();
    }

    public String getTitle() {
        return this.title;
    }

    public List getData() {
        return this.elements;
    }

    protected abstract void checkContext();

    protected List<TableAlias> getTables() {
        return Collections.emptyList();
    }

    public void setParent(BaseAnalyzer baseAnalyzer) {
        this.parentAnalyzer = baseAnalyzer;
    }

    protected int getPos(int n) {
        if (n == -1) {
            return Integer.MAX_VALUE;
        }
        return n;
    }

    protected boolean between(int n, int n2, int n3) {
        return n > this.getPos(n2) && n < this.getPos(n3);
    }

    public int getContext() {
        return this.context;
    }

    protected String contextToString() {
        switch (this.context) {
            case 2: {
                return "CONTEXT_COLUMN_LIST";
            }
            case 3: {
                return "CONTEXT_FROM_LIST";
            }
            case 5: {
                return "CONTEXT_KW_LIST";
            }
            case 1: {
                return "CONTEXT_TABLE_LIST";
            }
            case 4: {
                return "CONTEXT_TABLE_LIST";
            }
            case 7: {
                return "CONTEXT_WB_COMMANDS";
            }
            case 6: {
                return "CONTEXT_WB_PARAMS";
            }
            case 8: {
                return "CONTEXT_WB_PARAMVALUES";
            }
            case 9: {
                return "CONTEXT_SYNTAX_COMPLETION";
            }
            case 10: {
                return "CONTEXT_STATEMENT_PARAMETER";
            }
        }
        return Integer.toString(this.context);
    }

    protected void buildResult() {
        if (this.context == 4 && this.tableForColumnList != null) {
            if (!this.retrieveColumns()) {
                this.retrieveTables();
            }
        } else if (this.context == 1) {
            if (this.elements == null) {
                this.retrieveTables();
            }
        } else if (this.context == 15) {
            if (this.elements == null) {
                this.retrieveViews();
            }
        } else if (this.context == 2) {
            if (this.elements == null) {
                this.retrieveColumns();
            }
        } else if (this.context == 5) {
            this.title = ResourceMgr.getString("LblCompletionListKws");
            this.elements = this.readKeywords();
        } else if (this.context == 11) {
            this.title = this.namespaceForTableList != null ? this.namespaceForTableList + ".*" : StringUtil.capitalize(this.dbConnection.getMetadata().getSchemaTerm());
            this.retrieveSchemas();
        } else if (this.context == 12) {
            this.title = StringUtil.capitalize(this.dbConnection.getMetadata().getCatalogTerm());
            this.retrieveCatalogs();
        } else if (this.context == 13) {
            this.retrieveSequences();
        } else if (this.context == 14) {
            this.retrieveIndexes();
        } else if (this.context == 7) {
            this.title = ResourceMgr.getString("LblCompletionListWbCmd");
        } else if (this.context == 9 || this.context == 10) {
            this.title = SqlParsingUtil.getInstance(this.dbConnection).getSqlVerb(this.sql);
        } else if (this.elements == null) {
            this.elements = Collections.emptyList();
            this.title = null;
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.addAllMarker && this.elements != null) {
            this.elements.add(0, this.allColumnsMarker);
        }
    }

    private List<String> readKeywords() {
        if (this.keywordFile == null) {
            return null;
        }
        SqlKeywordHelper sqlKeywordHelper = new SqlKeywordHelper(this.dbConnection == null ? null : this.dbConnection.getDbId());
        Set<String> set = sqlKeywordHelper.loadKeywordsFromFile(this.keywordFile);
        return new ArrayList<String>(set);
    }

    protected void retrieveSchemas() {
        List<String> list = null;
        list = this.namespaceForTableList != null && this.namespaceForTableList.getCatalog() != null && this.dbConnection.getMetadata().supportsCatalogForGetSchemas() ? this.dbConnection.getMetadata().getSchemas(this.dbConnection.getSchemaFilter(), this.namespaceForTableList.getCatalog()) : this.dbConnection.getMetadata().getSchemas();
        this.elements = new ArrayList<String>(list);
    }

    protected void retrieveCatalogs() {
        List<String> list = this.dbConnection.getMetadata().getAllCatalogs();
        this.elements = new ArrayList<String>(list);
    }

    protected void retrieveIndexes() {
        IndexReader indexReader = this.dbConnection.getMetadata().getIndexReader();
        this.title = "Index";
        if (this.namespaceForTableList != null) {
            this.namespaceForTableList.adjustCase(this.dbConnection);
        }
        List<IndexDefinition> list = indexReader.getIndexes(this.namespaceForTableList.getCatalog(), this.namespaceForTableList.getSchema(), null, null);
        this.elements = new ArrayList(list.size());
        for (IndexDefinition indexDefinition : list) {
            if (indexDefinition.isPrimaryKeyIndex()) continue;
            indexDefinition.setDisplayName(indexDefinition.getObjectExpression(this.dbConnection) + " (" + indexDefinition.getBaseTable().getTableExpression(this.dbConnection) + ")");
            this.elements.add(indexDefinition);
        }
    }

    protected void retrieveSequences() {
        SequenceReader sequenceReader = this.dbConnection.getMetadata().getSequenceReader();
        if (sequenceReader == null) {
            return;
        }
        try {
            this.title = StringUtil.capitalize(sequenceReader.getSequenceTypeName());
            if (this.namespaceForTableList != null) {
                this.namespaceForTableList.adjustCase(this.dbConnection);
            }
            List<SequenceDefinition> list = sequenceReader.getSequences(this.namespaceForTableList.getCatalog(), this.namespaceForTableList.getSchema(), null);
            this.elements = new ArrayList<SequenceDefinition>(list);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve sequences", sQLException);
        }
    }

    protected void retrieveViews() {
        DbObjectCache dbObjectCache = this.dbConnection.getObjectCache();
        Set<TableIdentifier> set = dbObjectCache.getTables(this.namespaceForTableList, this.dbConnection.getDbSettings().getViewTypes());
        this.title = this.namespaceForTableList == null ? ResourceMgr.getString("LblCompletionListTables") : this.namespaceForTableList + ".*";
        this.elements = new ArrayList<TableIdentifier>(set);
    }

    protected void retrieveTables() {
        DbObjectCache dbObjectCache = this.dbConnection.getObjectCache();
        Set<TableIdentifier> set = dbObjectCache.getTables(this.namespaceForTableList, this.typeFilter);
        this.title = this.namespaceForTableList == null ? ResourceMgr.getString("LblCompletionListTables") : this.namespaceForTableList + ".*";
        this.elements = new ArrayList<TableIdentifier>(set);
    }

    protected List<ColumnIdentifier> retrieveColumnsForTable(TableIdentifier tableIdentifier) {
        TableIdentifier tableIdentifier2;
        if (tableIdentifier == null) {
            return null;
        }
        if (this.dbConnection == null) {
            return null;
        }
        DbObjectCache dbObjectCache = this.dbConnection.getObjectCache();
        List<ColumnIdentifier> list = dbObjectCache.getColumns(tableIdentifier2 = tableIdentifier.createCopy());
        if (list == null) {
            tableIdentifier2 = dbObjectCache.getSynonymTable(this.tableForColumnList);
            list = dbObjectCache.getColumns(tableIdentifier2);
        }
        if (CollectionUtil.isNonEmpty(list) && GuiSettings.getSortCompletionColumns()) {
            list = new ArrayList<ColumnIdentifier>(list);
            Collections.sort(list);
        }
        return list;
    }

    protected boolean retrieveColumns() {
        if (this.tableForColumnList == null) {
            return false;
        }
        if (this.dbConnection == null) {
            return false;
        }
        DbObjectCache dbObjectCache = this.dbConnection.getObjectCache();
        List<ColumnIdentifier> list = this.retrieveColumnsForTable(this.tableForColumnList);
        if (list != null && list.size() > 0) {
            if (dbObjectCache.supportsSearchPath()) {
                TableIdentifier tableIdentifier = dbObjectCache.getTable(this.tableForColumnList);
                this.title = (tableIdentifier == null ? this.tableForColumnList.getTableName() : tableIdentifier.getTableExpression()) + ".*";
            } else {
                this.title = this.tableForColumnList.getTableName() + ".*";
            }
            this.elements = new ArrayList(list.size() + 1);
            this.elements.addAll(list);
            if (this.fkMarker != null) {
                if (GuiSettings.showSelectFkValueAtTop()) {
                    this.elements.add(0, this.fkMarker);
                } else {
                    this.elements.add(this.fkMarker);
                }
            }
        }
        return this.elements == null ? false : this.elements.size() > 0;
    }

    protected void setTableTypeFilter(Collection<String> collection) {
        this.typeFilter = new ArrayList<String>(collection);
    }

    public String getQualifierLeftOfCursor() {
        char c;
        int n = this.sql.length();
        int n2 = this.cursorPos - 1;
        if (this.cursorPos > n) {
            n2 = n - 1;
        }
        if ((c = this.sql.charAt(n2)) != this.schemaSeparator) {
            return null;
        }
        String string = this.getCurrentWord();
        return StringUtil.removeTrailing(string, this.schemaSeparator);
    }

    public boolean isColumnList() {
        return this.context == 2;
    }

    protected String getCurrentWord() {
        return StringUtil.getWordLeftOfCursor(this.sql, this.cursorPos, WORD_DELIM);
    }

    protected void checkOverwrite() {
        String string = this.getCurrentWord();
        if (StringUtil.isEmptyString(string)) {
            this.setOverwriteCurrentWord(false);
        } else {
            char c = SqlUtil.getCatalogSeparator(this.dbConnection);
            this.setOverwriteCurrentWord(string.charAt(string.length() - 1) != c);
        }
    }

    protected SelectFKValueMarker checkFkLookup() {
        SQLToken sQLToken = SqlUtil.getOperatorBeforeCursor(this.sql, this.cursorPos);
        if (sQLToken == null) {
            return null;
        }
        int n = sQLToken.getCharBegin() - 1;
        String string = StringUtil.getWordLeftOfCursor(this.sql, n, " ");
        if (string != null) {
            SelectColumn selectColumn = new SelectColumn(string);
            String string2 = selectColumn.getObjectName();
            boolean bl = !sQLToken.isOperator();
            TableIdentifier tableIdentifier = this.tableForColumnList;
            String string3 = selectColumn.getColumnTable();
            if (string3 != null) {
                List<TableAlias> list = this.getTables();
                for (TableAlias tableAlias : list) {
                    if (!string3.equalsIgnoreCase(tableAlias.getNameToUse())) continue;
                    tableIdentifier = tableAlias.getTable();
                }
            }
            return new SelectFKValueMarker(string2, tableIdentifier, bl);
        }
        return null;
    }

    TableIdentifier getTableForColumnList() {
        return this.tableForColumnList;
    }
}

