/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.gui.completion.TooltipElement;
import workbench.resource.GuiSettings;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class CompletionListRenderer
extends DefaultListCellRenderer {
    private boolean showNotNulls;
    private boolean showColumnDataTypes = GuiSettings.showColumnDataTypesInCompletion();

    public void setShowNotNulls(boolean bl) {
        this.showNotNulls = bl;
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        String string;
        DbObject dbObject;
        Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object instanceof ColumnIdentifier) {
            dbObject = (ColumnIdentifier)object;
            string = SqlUtil.removeObjectQuotes(((ColumnIdentifier)dbObject).getColumnName());
            if (((ColumnIdentifier)dbObject).isPkColumn()) {
                string = "<b>" + string + "</b>";
            } else if (this.showNotNulls && !((ColumnIdentifier)dbObject).isNullable()) {
                string = "<span style='color:red'>" + string + "</span>";
            }
            if (this.showColumnDataTypes && ((ColumnIdentifier)dbObject).getDbmsType() != null) {
                string = string + " - <tt>" + ((ColumnIdentifier)dbObject).getDbmsType() + "</tt>";
            }
            this.setText("<html>" + string + "</html>");
        }
        if (object instanceof DbObject) {
            Object object2;
            dbObject = (DbObject)object;
            string = null;
            if (dbObject instanceof ColumnIdentifier) {
                object2 = (ColumnIdentifier)dbObject;
                string = ((ColumnIdentifier)object2).getDbmsType();
                if (!((ColumnIdentifier)object2).isNullable()) {
                    string = string + " (NN)";
                }
            } else {
                string = dbObject.getObjectType();
            }
            object2 = null;
            String string2 = dbObject.getComment();
            if (StringUtil.isBlank(string2) && StringUtil.isNonBlank(string)) {
                object2 = "<html><tt>" + string + "</tt></html>";
            } else if (StringUtil.isNonBlank(string)) {
                object2 = "<html><tt>" + string + "</tt><br><i>" + string2 + "</i></html>";
            }
            this.setToolTipText((String)object2);
        } else if (object instanceof TooltipElement) {
            this.setToolTipText(((TooltipElement)object).getTooltip());
        } else {
            this.setToolTipText(null);
        }
        return component;
    }
}

